/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.SimpleRegionObserver;
import org.apache.hadoop.hbase.coprocessor.TestRegionObserverInterface;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperListener;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperNodeTracker;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestRegionServerCoprocessorExceptionWithAbort {
    static final Log LOG = LogFactory.getLog(TestRegionObserverInterface.class);
    private static HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    static final int timeout = 30000;
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.set("hbase.coprocessor.region.classes", BuggyRegionObserver.class.getName());
        conf.set("hbase.coprocessor.abortonerror", "true");
        TEST_UTIL.startMiniCluster(2);
    }

    @AfterClass
    public static void teardownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testExceptionFromCoprocessorDuringPut() throws IOException {
        byte[] TEST_TABLE = Bytes.toBytes((String)"observed_table");
        byte[] TEST_FAMILY = Bytes.toBytes((String)"aaa");
        HTable table = TEST_UTIL.createTable(TEST_TABLE, TEST_FAMILY);
        TEST_UTIL.waitUntilAllRegionsAssigned(TEST_UTIL.createMultiRegions(table, TEST_FAMILY));
        HRegionServer regionServer = TEST_UTIL.getRSForFirstRegionInTable(TEST_TABLE);
        ZooKeeperWatcher zkw = new ZooKeeperWatcher(TEST_UTIL.getConfiguration(), "unittest", (Abortable)new zkwAbortable());
        RSTracker rsTracker = new RSTracker(zkw, "/hbase/rs/" + regionServer.getServerName(), Thread.currentThread());
        rsTracker.start();
        zkw.registerListener((ZooKeeperListener)rsTracker);
        boolean caughtInterruption = false;
        try {
            byte[] ROW = Bytes.toBytes((String)"aaa");
            Put put = new Put(ROW);
            put.add(TEST_FAMILY, ROW, ROW);
            table.put(put);
        }
        catch (IOException e) {
            if (e.getCause().getClass().equals(InterruptedException.class)) {
                LOG.debug((Object)"caught interruption here (during put()).");
                caughtInterruption = true;
            }
            Assert.fail((String)("put() failed: " + e));
        }
        if (!caughtInterruption) {
            try {
                Thread.sleep(30000L);
                Assert.fail((String)"RegionServer did not abort within 30 seconds.");
            }
            catch (InterruptedException e) {
                LOG.debug((Object)"caught interruption here (during sleep()).");
                caughtInterruption = true;
            }
        }
        Assert.assertTrue((String)"Main thread caught interruption.", (boolean)caughtInterruption);
        Assert.assertTrue((String)"RegionServer aborted on coprocessor exception, as expected.", (boolean)rsTracker.regionZKNodeWasDeleted);
        table.close();
    }

    public static class BuggyRegionObserver
    extends SimpleRegionObserver {
        @Override
        public void prePut(ObserverContext<RegionCoprocessorEnvironment> c, Put put, WALEdit edit, boolean writeToWAL) {
            String tableName = ((RegionCoprocessorEnvironment)c.getEnvironment()).getRegion().getRegionInfo().getTableNameAsString();
            if (tableName.equals("observed_table")) {
                Integer i = null;
                i = i + 1;
            }
        }
    }

    private class RSTracker
    extends ZooKeeperNodeTracker {
        public boolean regionZKNodeWasDeleted;
        public String rsNode;
        private Thread mainThread;

        public RSTracker(ZooKeeperWatcher zkw, String rsNode, Thread mainThread) {
            super(zkw, rsNode, (Abortable)new zkwAbortable());
            this.regionZKNodeWasDeleted = false;
            this.rsNode = rsNode;
            this.mainThread = mainThread;
        }

        public synchronized void nodeDeleted(String path) {
            if (path.equals(this.rsNode)) {
                this.regionZKNodeWasDeleted = true;
                this.mainThread.interrupt();
            }
        }
    }

    private class zkwAbortable
    implements Abortable {
        private zkwAbortable() {
        }

        public void abort(String why, Throwable e) {
            throw new RuntimeException("Fatal ZK rs tracker error, why=", e);
        }

        public boolean isAborted() {
            return false;
        }
    }
}

