/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor.example;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.coprocessor.example.BulkDeleteEndpoint;
import org.apache.hadoop.hbase.coprocessor.example.BulkDeleteProtocol;
import org.apache.hadoop.hbase.coprocessor.example.BulkDeleteResponse;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestBulkDeleteProtocol {
    private static final byte[] FAMILY1 = Bytes.toBytes((String)"cf1");
    private static final byte[] FAMILY2 = Bytes.toBytes((String)"cf2");
    private static final byte[] QUALIFIER1 = Bytes.toBytes((String)"c1");
    private static final byte[] QUALIFIER2 = Bytes.toBytes((String)"c2");
    private static final byte[] QUALIFIER3 = Bytes.toBytes((String)"c3");
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().set("hbase.coprocessor.user.region.classes", BulkDeleteEndpoint.class.getName());
        TEST_UTIL.startMiniCluster(2);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testBulkDeleteEndpoint() throws Throwable {
        byte[] tableName = Bytes.toBytes((String)"testBulkDeleteEndpoint");
        HTable ht = this.createTable(tableName);
        ArrayList<Put> puts = new ArrayList<Put>(100);
        for (int j = 0; j < 100; ++j) {
            byte[] rowkey = Bytes.toBytes((int)j);
            puts.add(this.createPut(rowkey, "v1"));
        }
        ht.put(puts);
        long noOfRowsDeleted = this.invokeBulkDeleteProtocol(tableName, new Scan(), 500, (byte)0, null);
        Assert.assertEquals((long)100L, (long)noOfRowsDeleted);
        int rows = 0;
        for (Result result : ht.getScanner(new Scan())) {
            ++rows;
        }
        Assert.assertEquals((long)0L, (long)rows);
    }

    @Test
    public void testBulkDeleteEndpointWhenRowBatchSizeLessThanRowsToDeleteFromARegion() throws Throwable {
        byte[] tableName = Bytes.toBytes((String)"testBulkDeleteEndpointWhenRowBatchSizeLessThanRowsToDeleteFromARegion");
        HTable ht = this.createTable(tableName);
        ArrayList<Put> puts = new ArrayList<Put>(100);
        for (int j = 0; j < 100; ++j) {
            byte[] rowkey = Bytes.toBytes((int)j);
            puts.add(this.createPut(rowkey, "v1"));
        }
        ht.put(puts);
        long noOfRowsDeleted = this.invokeBulkDeleteProtocol(tableName, new Scan(), 10, (byte)0, null);
        Assert.assertEquals((long)100L, (long)noOfRowsDeleted);
        int rows = 0;
        for (Result result : ht.getScanner(new Scan())) {
            ++rows;
        }
        Assert.assertEquals((long)0L, (long)rows);
    }

    private long invokeBulkDeleteProtocol(byte[] tableName, final Scan scan, final int rowBatchSize, final byte deleteType, final Long timeStamp) throws Throwable {
        HTable ht = new HTable(TEST_UTIL.getConfiguration(), tableName);
        long noOfDeletedRows = 0L;
        Batch.Call<BulkDeleteProtocol, BulkDeleteResponse> callable = new Batch.Call<BulkDeleteProtocol, BulkDeleteResponse>(){

            public BulkDeleteResponse call(BulkDeleteProtocol instance) throws IOException {
                return instance.delete(scan, deleteType, timeStamp, rowBatchSize);
            }
        };
        Map result = ht.coprocessorExec(BulkDeleteProtocol.class, scan.getStartRow(), scan.getStopRow(), (Batch.Call)callable);
        for (BulkDeleteResponse response : result.values()) {
            noOfDeletedRows += response.getRowsDeleted();
        }
        return noOfDeletedRows;
    }

    @Test
    public void testBulkDeleteWithConditionBasedDelete() throws Throwable {
        byte[] tableName = Bytes.toBytes((String)"testBulkDeleteWithConditionBasedDelete");
        HTable ht = this.createTable(tableName);
        ArrayList<Put> puts = new ArrayList<Put>(100);
        for (int j = 0; j < 100; ++j) {
            byte[] rowkey = Bytes.toBytes((int)j);
            String value = j % 10 == 0 ? "v1" : "v2";
            puts.add(this.createPut(rowkey, value));
        }
        ht.put(puts);
        Scan scan = new Scan();
        FilterList fl = new FilterList(FilterList.Operator.MUST_PASS_ALL);
        SingleColumnValueFilter scvf = new SingleColumnValueFilter(FAMILY1, QUALIFIER3, CompareFilter.CompareOp.EQUAL, Bytes.toBytes((String)"v1"));
        fl.addFilter((Filter)scvf);
        scan.setFilter((Filter)fl);
        long noOfRowsDeleted = this.invokeBulkDeleteProtocol(tableName, scan, 500, (byte)0, null);
        Assert.assertEquals((long)10L, (long)noOfRowsDeleted);
        int rows = 0;
        for (Result result : ht.getScanner(new Scan())) {
            ++rows;
        }
        Assert.assertEquals((long)90L, (long)rows);
    }

    @Test
    public void testBulkDeleteColumn() throws Throwable {
        byte[] tableName = Bytes.toBytes((String)"testBulkDeleteColumn");
        HTable ht = this.createTable(tableName);
        ArrayList<Put> puts = new ArrayList<Put>(100);
        for (int j = 0; j < 100; ++j) {
            byte[] rowkey = Bytes.toBytes((int)j);
            String value = j % 10 == 0 ? "v1" : "v2";
            puts.add(this.createPut(rowkey, value));
        }
        ht.put(puts);
        Scan scan = new Scan();
        scan.addColumn(FAMILY1, QUALIFIER2);
        long noOfRowsDeleted = this.invokeBulkDeleteProtocol(tableName, scan, 500, (byte)2, null);
        Assert.assertEquals((long)100L, (long)noOfRowsDeleted);
        int rows = 0;
        for (Result result : ht.getScanner(new Scan())) {
            Assert.assertEquals((long)2L, (long)result.getFamilyMap(FAMILY1).size());
            Assert.assertTrue((boolean)result.getColumn(FAMILY1, QUALIFIER2).isEmpty());
            Assert.assertEquals((long)1L, (long)result.getColumn(FAMILY1, QUALIFIER1).size());
            Assert.assertEquals((long)1L, (long)result.getColumn(FAMILY1, QUALIFIER3).size());
            ++rows;
        }
        Assert.assertEquals((long)100L, (long)rows);
    }

    @Test
    public void testBulkDeleteFamily() throws Throwable {
        byte[] tableName = Bytes.toBytes((String)"testBulkDeleteFamily");
        HTableDescriptor htd = new HTableDescriptor(tableName);
        htd.addFamily(new HColumnDescriptor(FAMILY1));
        htd.addFamily(new HColumnDescriptor(FAMILY2));
        TEST_UTIL.getHBaseAdmin().createTable(htd, Bytes.toBytes((int)0), Bytes.toBytes((int)120), 5);
        HTable ht = new HTable(TEST_UTIL.getConfiguration(), tableName);
        ArrayList<Put> puts = new ArrayList<Put>(100);
        for (int j = 0; j < 100; ++j) {
            Put put = new Put(Bytes.toBytes((int)j));
            put.add(FAMILY1, QUALIFIER1, "v1".getBytes());
            put.add(FAMILY2, QUALIFIER2, "v2".getBytes());
            puts.add(put);
        }
        ht.put(puts);
        Scan scan = new Scan();
        scan.addFamily(FAMILY1);
        long noOfRowsDeleted = this.invokeBulkDeleteProtocol(tableName, scan, 500, (byte)1, null);
        Assert.assertEquals((long)100L, (long)noOfRowsDeleted);
        int rows = 0;
        for (Result result : ht.getScanner(new Scan())) {
            Assert.assertTrue((boolean)result.getFamilyMap(FAMILY1).isEmpty());
            Assert.assertEquals((long)1L, (long)result.getColumn(FAMILY2, QUALIFIER2).size());
            ++rows;
        }
        Assert.assertEquals((long)100L, (long)rows);
    }

    @Test
    public void testBulkDeleteColumnVersion() throws Throwable {
        byte[] tableName = Bytes.toBytes((String)"testBulkDeleteColumnVersion");
        HTable ht = this.createTable(tableName);
        ArrayList<Put> puts = new ArrayList<Put>(100);
        for (int j = 0; j < 100; ++j) {
            Put put = new Put(Bytes.toBytes((int)j));
            byte[] value = "v1".getBytes();
            put.add(FAMILY1, QUALIFIER1, 1234L, value);
            put.add(FAMILY1, QUALIFIER2, 1234L, value);
            put.add(FAMILY1, QUALIFIER3, 1234L, value);
            value = "v2".getBytes();
            put.add(FAMILY1, QUALIFIER1, value);
            put.add(FAMILY1, QUALIFIER2, value);
            put.add(FAMILY1, QUALIFIER3, value);
            put.add(FAMILY1, null, value);
            puts.add(put);
        }
        ht.put(puts);
        Scan scan = new Scan();
        scan.addFamily(FAMILY1);
        long noOfRowsDeleted = this.invokeBulkDeleteProtocol(tableName, scan, 500, (byte)3, Long.MAX_VALUE);
        Assert.assertEquals((long)100L, (long)noOfRowsDeleted);
        int rows = 0;
        scan = new Scan();
        scan.setMaxVersions();
        for (Result result : ht.getScanner(scan)) {
            Assert.assertEquals((long)3L, (long)result.getFamilyMap(FAMILY1).size());
            List column = result.getColumn(FAMILY1, QUALIFIER1);
            Assert.assertEquals((long)1L, (long)column.size());
            Assert.assertTrue((boolean)Bytes.equals((byte[])"v1".getBytes(), (byte[])((KeyValue)column.get(0)).getValue()));
            column = result.getColumn(FAMILY1, QUALIFIER2);
            Assert.assertEquals((long)1L, (long)column.size());
            Assert.assertTrue((boolean)Bytes.equals((byte[])"v1".getBytes(), (byte[])((KeyValue)column.get(0)).getValue()));
            column = result.getColumn(FAMILY1, QUALIFIER3);
            Assert.assertEquals((long)1L, (long)column.size());
            Assert.assertTrue((boolean)Bytes.equals((byte[])"v1".getBytes(), (byte[])((KeyValue)column.get(0)).getValue()));
            ++rows;
        }
        Assert.assertEquals((long)100L, (long)rows);
    }

    @Test
    public void testBulkDeleteColumnVersionBasedOnTS() throws Throwable {
        byte[] tableName = Bytes.toBytes((String)"testBulkDeleteColumnVersionBasedOnTS");
        HTable ht = this.createTable(tableName);
        ArrayList<Put> puts = new ArrayList<Put>(100);
        for (int j = 0; j < 100; ++j) {
            Put put = new Put(Bytes.toBytes((int)j));
            byte[] value = "v1".getBytes();
            put.add(FAMILY1, QUALIFIER1, 1000L, value);
            put.add(FAMILY1, QUALIFIER2, 1000L, value);
            put.add(FAMILY1, QUALIFIER3, 1000L, value);
            value = "v2".getBytes();
            put.add(FAMILY1, QUALIFIER1, 1234L, value);
            put.add(FAMILY1, QUALIFIER2, 1234L, value);
            put.add(FAMILY1, QUALIFIER3, 1234L, value);
            value = "v3".getBytes();
            put.add(FAMILY1, QUALIFIER1, value);
            put.add(FAMILY1, QUALIFIER2, value);
            put.add(FAMILY1, QUALIFIER3, value);
            puts.add(put);
        }
        ht.put(puts);
        Scan scan = new Scan();
        scan.addColumn(FAMILY1, QUALIFIER3);
        long noOfRowsDeleted = this.invokeBulkDeleteProtocol(tableName, scan, 500, (byte)3, 1234L);
        Assert.assertEquals((long)100L, (long)noOfRowsDeleted);
        int rows = 0;
        scan = new Scan();
        scan.setMaxVersions();
        for (Result result : ht.getScanner(scan)) {
            Assert.assertEquals((long)3L, (long)result.getFamilyMap(FAMILY1).size());
            Assert.assertEquals((long)3L, (long)result.getColumn(FAMILY1, QUALIFIER1).size());
            Assert.assertEquals((long)3L, (long)result.getColumn(FAMILY1, QUALIFIER2).size());
            List column = result.getColumn(FAMILY1, QUALIFIER3);
            Assert.assertEquals((long)2L, (long)column.size());
            Assert.assertTrue((boolean)Bytes.equals((byte[])"v3".getBytes(), (byte[])((KeyValue)column.get(0)).getValue()));
            Assert.assertTrue((boolean)Bytes.equals((byte[])"v1".getBytes(), (byte[])((KeyValue)column.get(1)).getValue()));
            ++rows;
        }
        Assert.assertEquals((long)100L, (long)rows);
    }

    @Test
    public void testBulkDeleteWithNumberOfVersions() throws Throwable {
        byte[] tableName = Bytes.toBytes((String)"testBulkDeleteWithNumberOfVersions");
        HTable ht = this.createTable(tableName);
        ArrayList<Put> puts = new ArrayList<Put>(100);
        for (int j = 0; j < 100; ++j) {
            Put put = new Put(Bytes.toBytes((int)j));
            byte[] value = "v1".getBytes();
            put.add(FAMILY1, QUALIFIER1, 1000L, value);
            put.add(FAMILY1, QUALIFIER2, 1000L, value);
            put.add(FAMILY1, QUALIFIER3, 1000L, value);
            value = "v2".getBytes();
            put.add(FAMILY1, QUALIFIER1, 1234L, value);
            put.add(FAMILY1, QUALIFIER2, 1234L, value);
            put.add(FAMILY1, QUALIFIER3, 1234L, value);
            value = "v3".getBytes();
            put.add(FAMILY1, QUALIFIER1, 2000L, value);
            put.add(FAMILY1, QUALIFIER2, 2000L, value);
            put.add(FAMILY1, QUALIFIER3, 2000L, value);
            value = "v4".getBytes();
            put.add(FAMILY1, QUALIFIER1, value);
            put.add(FAMILY1, QUALIFIER2, value);
            put.add(FAMILY1, QUALIFIER3, value);
            puts.add(put);
        }
        ht.put(puts);
        final Scan scan = new Scan();
        scan.addColumn(FAMILY1, QUALIFIER1);
        scan.addColumn(FAMILY1, QUALIFIER2);
        scan.setTimeRange(1000L, 2000L);
        scan.setMaxVersions();
        long noOfDeletedRows = 0L;
        long noOfVersionsDeleted = 0L;
        Batch.Call<BulkDeleteProtocol, BulkDeleteResponse> callable = new Batch.Call<BulkDeleteProtocol, BulkDeleteResponse>(){

            public BulkDeleteResponse call(BulkDeleteProtocol instance) throws IOException {
                return instance.delete(scan, (byte)3, null, 500);
            }
        };
        Map result = ht.coprocessorExec(BulkDeleteProtocol.class, scan.getStartRow(), scan.getStopRow(), (Batch.Call)callable);
        for (BulkDeleteResponse response : result.values()) {
            noOfDeletedRows += response.getRowsDeleted();
            noOfVersionsDeleted += response.getVersionsDeleted();
        }
        Assert.assertEquals((long)100L, (long)noOfDeletedRows);
        Assert.assertEquals((long)400L, (long)noOfVersionsDeleted);
        int rows = 0;
        Scan scan1 = new Scan();
        scan1.setMaxVersions();
        for (Result res : ht.getScanner(scan1)) {
            Assert.assertEquals((long)3L, (long)res.getFamilyMap(FAMILY1).size());
            List column = res.getColumn(FAMILY1, QUALIFIER1);
            Assert.assertEquals((long)2L, (long)column.size());
            Assert.assertTrue((boolean)Bytes.equals((byte[])"v4".getBytes(), (byte[])((KeyValue)column.get(0)).getValue()));
            Assert.assertTrue((boolean)Bytes.equals((byte[])"v3".getBytes(), (byte[])((KeyValue)column.get(1)).getValue()));
            column = res.getColumn(FAMILY1, QUALIFIER2);
            Assert.assertEquals((long)2L, (long)column.size());
            Assert.assertTrue((boolean)Bytes.equals((byte[])"v4".getBytes(), (byte[])((KeyValue)column.get(0)).getValue()));
            Assert.assertTrue((boolean)Bytes.equals((byte[])"v3".getBytes(), (byte[])((KeyValue)column.get(1)).getValue()));
            Assert.assertEquals((long)4L, (long)res.getColumn(FAMILY1, QUALIFIER3).size());
            ++rows;
        }
        Assert.assertEquals((long)100L, (long)rows);
    }

    private HTable createTable(byte[] tableName) throws IOException {
        HTableDescriptor htd = new HTableDescriptor(tableName);
        HColumnDescriptor hcd = new HColumnDescriptor(FAMILY1);
        hcd.setMaxVersions(10);
        htd.addFamily(hcd);
        TEST_UTIL.getHBaseAdmin().createTable(htd, Bytes.toBytes((int)0), Bytes.toBytes((int)120), 5);
        HTable ht = new HTable(TEST_UTIL.getConfiguration(), tableName);
        return ht;
    }

    private Put createPut(byte[] rowkey, String value) throws IOException {
        Put put = new Put(rowkey);
        put.add(FAMILY1, QUALIFIER1, value.getBytes());
        put.add(FAMILY1, QUALIFIER2, value.getBytes());
        put.add(FAMILY1, QUALIFIER3, value.getBytes());
        return put;
    }
}

