/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import junit.framework.TestCase;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.PageFilter;
import org.apache.hadoop.hbase.filter.PrefixFilter;
import org.apache.hadoop.hbase.filter.WhileMatchFilter;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Rule;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestFilterList
extends TestCase {
    static final int MAX_PAGES = 2;
    static final char FIRST_CHAR = 'a';
    static final char LAST_CHAR = 'e';
    static byte[] GOOD_BYTES = Bytes.toBytes((String)"abc");
    static byte[] BAD_BYTES = Bytes.toBytes((String)"def");
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    public void testMPONE() throws Exception {
        ArrayList<Object> filters = new ArrayList<Object>();
        filters.add(new PageFilter(2L));
        filters.add(new WhileMatchFilter((Filter)new PrefixFilter(Bytes.toBytes((String)"yyy"))));
        FilterList filterMPONE = new FilterList(FilterList.Operator.MUST_PASS_ONE, filters);
        filterMPONE.reset();
        TestFilterList.assertFalse((boolean)filterMPONE.filterAllRemaining());
        byte[] rowkey = Bytes.toBytes((String)"yyyyyyyyy");
        for (int i = 0; i < 1; ++i) {
            TestFilterList.assertFalse((boolean)filterMPONE.filterRowKey(rowkey, 0, rowkey.length));
            TestFilterList.assertFalse((boolean)filterMPONE.filterRow());
            KeyValue kv = new KeyValue(rowkey, rowkey, Bytes.toBytes((int)i), Bytes.toBytes((int)i));
            TestFilterList.assertTrue((Filter.ReturnCode.INCLUDE == filterMPONE.filterKeyValue(kv) ? 1 : 0) != 0);
        }
        rowkey = Bytes.toBytes((String)"z");
        TestFilterList.assertFalse((boolean)filterMPONE.filterRowKey(rowkey, 0, rowkey.length));
        TestFilterList.assertFalse((boolean)filterMPONE.filterRow());
        KeyValue kv = new KeyValue(rowkey, rowkey, Bytes.toBytes((int)0), Bytes.toBytes((int)0));
        TestFilterList.assertTrue((Filter.ReturnCode.INCLUDE == filterMPONE.filterKeyValue(kv) ? 1 : 0) != 0);
        rowkey = Bytes.toBytes((String)"yyy");
        TestFilterList.assertFalse((boolean)filterMPONE.filterRowKey(rowkey, 0, rowkey.length));
        TestFilterList.assertFalse((boolean)filterMPONE.filterRow());
        kv = new KeyValue(rowkey, rowkey, Bytes.toBytes((int)0), Bytes.toBytes((int)0));
        TestFilterList.assertTrue((Filter.ReturnCode.INCLUDE == filterMPONE.filterKeyValue(kv) ? 1 : 0) != 0);
        rowkey = Bytes.toBytes((String)"z");
        TestFilterList.assertTrue((boolean)filterMPONE.filterRowKey(rowkey, 0, rowkey.length));
        TestFilterList.assertTrue((boolean)filterMPONE.filterAllRemaining());
    }

    public void testMPALL() throws Exception {
        ArrayList<Object> filters = new ArrayList<Object>();
        filters.add(new PageFilter(2L));
        filters.add(new WhileMatchFilter((Filter)new PrefixFilter(Bytes.toBytes((String)"yyy"))));
        FilterList filterMPALL = new FilterList(FilterList.Operator.MUST_PASS_ALL, filters);
        filterMPALL.reset();
        TestFilterList.assertFalse((boolean)filterMPALL.filterAllRemaining());
        byte[] rowkey = Bytes.toBytes((String)"yyyyyyyyy");
        for (int i = 0; i < 1; ++i) {
            TestFilterList.assertFalse((boolean)filterMPALL.filterRowKey(rowkey, 0, rowkey.length));
            KeyValue kv = new KeyValue(rowkey, rowkey, Bytes.toBytes((int)i), Bytes.toBytes((int)i));
            TestFilterList.assertTrue((Filter.ReturnCode.INCLUDE == filterMPALL.filterKeyValue(kv) ? 1 : 0) != 0);
        }
        filterMPALL.reset();
        rowkey = Bytes.toBytes((String)"z");
        TestFilterList.assertTrue((boolean)filterMPALL.filterRowKey(rowkey, 0, rowkey.length));
        KeyValue kv = new KeyValue(rowkey, rowkey, rowkey, rowkey);
        TestFilterList.assertTrue((Filter.ReturnCode.NEXT_ROW == filterMPALL.filterKeyValue(kv) ? 1 : 0) != 0);
    }

    public void testOrdering() throws Exception {
        KeyValue kv;
        int i;
        ArrayList<Object> filters = new ArrayList<Object>();
        filters.add(new PrefixFilter(Bytes.toBytes((String)"yyy")));
        filters.add(new PageFilter(2L));
        FilterList filterMPONE = new FilterList(FilterList.Operator.MUST_PASS_ONE, filters);
        filterMPONE.reset();
        TestFilterList.assertFalse((boolean)filterMPONE.filterAllRemaining());
        byte[] rowkey = Bytes.toBytes((String)"yyyyyyyy");
        for (i = 0; i < 2; ++i) {
            TestFilterList.assertFalse((boolean)filterMPONE.filterRowKey(rowkey, 0, rowkey.length));
            kv = new KeyValue(rowkey, rowkey, Bytes.toBytes((int)i), Bytes.toBytes((int)i));
            TestFilterList.assertTrue((Filter.ReturnCode.INCLUDE == filterMPONE.filterKeyValue(kv) ? 1 : 0) != 0);
            TestFilterList.assertFalse((boolean)filterMPONE.filterRow());
        }
        rowkey = Bytes.toBytes((String)"xxxxxxx");
        for (i = 0; i < 2; ++i) {
            TestFilterList.assertFalse((boolean)filterMPONE.filterRowKey(rowkey, 0, rowkey.length));
            kv = new KeyValue(rowkey, rowkey, Bytes.toBytes((int)i), Bytes.toBytes((int)i));
            TestFilterList.assertTrue((Filter.ReturnCode.INCLUDE == filterMPONE.filterKeyValue(kv) ? 1 : 0) != 0);
            TestFilterList.assertFalse((boolean)filterMPONE.filterRow());
        }
        rowkey = Bytes.toBytes((String)"yyy");
        for (i = 0; i < 2; ++i) {
            TestFilterList.assertFalse((boolean)filterMPONE.filterRowKey(rowkey, 0, rowkey.length));
            kv = new KeyValue(rowkey, rowkey, Bytes.toBytes((int)i), Bytes.toBytes((int)i));
            TestFilterList.assertTrue((Filter.ReturnCode.INCLUDE == filterMPONE.filterKeyValue(kv) ? 1 : 0) != 0);
            TestFilterList.assertFalse((boolean)filterMPONE.filterRow());
        }
    }

    public void testSerialization() throws Exception {
        ArrayList<Object> filters = new ArrayList<Object>();
        filters.add(new PageFilter(2L));
        filters.add(new WhileMatchFilter((Filter)new PrefixFilter(Bytes.toBytes((String)"yyy"))));
        FilterList filterMPALL = new FilterList(FilterList.Operator.MUST_PASS_ALL, filters);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(stream);
        filterMPALL.write((DataOutput)out);
        out.close();
        byte[] buffer = stream.toByteArray();
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(buffer));
        FilterList newFilter = new FilterList();
        newFilter.readFields((DataInput)in);
    }

    public void testFilterKeyValue() throws Exception {
        FilterBase includeFilter = new FilterBase(){

            public Filter.ReturnCode filterKeyValue(KeyValue v) {
                return Filter.ReturnCode.INCLUDE;
            }

            public void readFields(DataInput arg0) throws IOException {
            }

            public void write(DataOutput arg0) throws IOException {
            }
        };
        FilterBase alternateFilter = new FilterBase(){
            boolean returnInclude = true;

            public Filter.ReturnCode filterKeyValue(KeyValue v) {
                Filter.ReturnCode returnCode = this.returnInclude ? Filter.ReturnCode.INCLUDE : Filter.ReturnCode.SKIP;
                this.returnInclude = !this.returnInclude;
                return returnCode;
            }

            public void readFields(DataInput arg0) throws IOException {
            }

            public void write(DataOutput arg0) throws IOException {
            }
        };
        FilterBase alternateIncludeFilter = new FilterBase(){
            boolean returnIncludeOnly = false;

            public Filter.ReturnCode filterKeyValue(KeyValue v) {
                Filter.ReturnCode returnCode = this.returnIncludeOnly ? Filter.ReturnCode.INCLUDE : Filter.ReturnCode.INCLUDE_AND_NEXT_COL;
                this.returnIncludeOnly = !this.returnIncludeOnly;
                return returnCode;
            }

            public void readFields(DataInput arg0) throws IOException {
            }

            public void write(DataOutput arg0) throws IOException {
            }
        };
        FilterList mpOnefilterList = new FilterList(FilterList.Operator.MUST_PASS_ONE, Arrays.asList(includeFilter, alternateIncludeFilter, alternateFilter));
        TestFilterList.assertEquals((Object)Filter.ReturnCode.INCLUDE_AND_NEXT_COL, (Object)mpOnefilterList.filterKeyValue(null));
        TestFilterList.assertEquals((Object)Filter.ReturnCode.INCLUDE, (Object)mpOnefilterList.filterKeyValue(null));
        FilterList mpAllfilterList = new FilterList(FilterList.Operator.MUST_PASS_ALL, Arrays.asList(includeFilter, alternateIncludeFilter, alternateFilter));
        TestFilterList.assertEquals((Object)Filter.ReturnCode.INCLUDE_AND_NEXT_COL, (Object)mpAllfilterList.filterKeyValue(null));
        TestFilterList.assertEquals((Object)Filter.ReturnCode.SKIP, (Object)mpAllfilterList.filterKeyValue(null));
    }

    public void testHintPassThru() throws Exception {
        final KeyValue minKeyValue = new KeyValue(Bytes.toBytes((long)0L), null, null);
        KeyValue maxKeyValue = new KeyValue(Bytes.toBytes((long)Long.MAX_VALUE), null, null);
        FilterBase filterNoHint = new FilterBase(){

            public void readFields(DataInput arg0) throws IOException {
            }

            public void write(DataOutput arg0) throws IOException {
            }
        };
        FilterBase filterMinHint = new FilterBase(){

            public KeyValue getNextKeyHint(KeyValue currentKV) {
                return minKeyValue;
            }

            public void readFields(DataInput arg0) throws IOException {
            }

            public void write(DataOutput arg0) throws IOException {
            }
        };
        FilterBase filterMaxHint = new FilterBase(){

            public KeyValue getNextKeyHint(KeyValue currentKV) {
                return new KeyValue(Bytes.toBytes((long)Long.MAX_VALUE), null, null);
            }

            public void readFields(DataInput arg0) throws IOException {
            }

            public void write(DataOutput arg0) throws IOException {
            }
        };
        FilterList filterList = new FilterList(FilterList.Operator.MUST_PASS_ONE, Arrays.asList(filterMinHint, filterMaxHint));
        TestFilterList.assertEquals((int)0, (int)KeyValue.COMPARATOR.compare(filterList.getNextKeyHint(null), minKeyValue));
        filterList = new FilterList(FilterList.Operator.MUST_PASS_ONE, Arrays.asList(filterMinHint, filterMaxHint, filterNoHint));
        TestFilterList.assertNull((Object)filterList.getNextKeyHint(null));
        filterList = new FilterList(FilterList.Operator.MUST_PASS_ONE, Arrays.asList(filterNoHint, filterMaxHint));
        TestFilterList.assertNull((Object)filterList.getNextKeyHint(null));
        filterList = new FilterList(FilterList.Operator.MUST_PASS_ONE, Arrays.asList(filterMaxHint, filterMaxHint));
        TestFilterList.assertEquals((int)0, (int)KeyValue.COMPARATOR.compare(filterList.getNextKeyHint(null), maxKeyValue));
        filterList = new FilterList(FilterList.Operator.MUST_PASS_ALL, Arrays.asList(filterMinHint, filterMaxHint));
        TestFilterList.assertEquals((int)0, (int)KeyValue.COMPARATOR.compare(filterList.getNextKeyHint(null), maxKeyValue));
        filterList = new FilterList(FilterList.Operator.MUST_PASS_ALL, Arrays.asList(filterMinHint, filterMaxHint, filterNoHint));
        TestFilterList.assertEquals((int)0, (int)KeyValue.COMPARATOR.compare(filterList.getNextKeyHint(null), maxKeyValue));
        filterList = new FilterList(FilterList.Operator.MUST_PASS_ALL, Arrays.asList(filterNoHint, filterMaxHint));
        TestFilterList.assertEquals((int)0, (int)KeyValue.COMPARATOR.compare(filterList.getNextKeyHint(null), maxKeyValue));
        filterList = new FilterList(FilterList.Operator.MUST_PASS_ALL, Arrays.asList(filterNoHint, filterMinHint));
        TestFilterList.assertEquals((int)0, (int)KeyValue.COMPARATOR.compare(filterList.getNextKeyHint(null), minKeyValue));
        filterList = new FilterList(FilterList.Operator.MUST_PASS_ALL, Arrays.asList(filterNoHint, filterMinHint));
        TestFilterList.assertEquals((int)0, (int)KeyValue.COMPARATOR.compare(filterList.getNextKeyHint(null), minKeyValue));
    }
}

