/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import junit.framework.TestCase;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.PageFilter;
import org.junit.Rule;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestPageFilter
extends TestCase {
    static final int ROW_LIMIT = 3;
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    public void testPageSize() throws Exception {
        PageFilter f = new PageFilter(3L);
        this.pageSizeTests((Filter)f);
    }

    public void testSerialization() throws Exception {
        PageFilter f = new PageFilter(3L);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(stream);
        f.write((DataOutput)out);
        out.close();
        byte[] buffer = stream.toByteArray();
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(buffer));
        PageFilter newFilter = new PageFilter();
        newFilter.readFields((DataInput)in);
        this.pageSizeTests((Filter)newFilter);
    }

    private void pageSizeTests(Filter f) throws Exception {
        this.testFiltersBeyondPageSize(f, 3);
    }

    private void testFiltersBeyondPageSize(Filter f, int pageSize) {
        boolean filterOut;
        int count = 0;
        for (int i = 0; i < pageSize * 2 && !(filterOut = f.filterRow()); ++i) {
            if (++count == pageSize) {
                TestPageFilter.assertTrue((boolean)f.filterAllRemaining());
                continue;
            }
            TestPageFilter.assertFalse((boolean)f.filterAllRemaining());
        }
        TestPageFilter.assertEquals((int)pageSize, (int)count);
    }
}

