/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.encoding;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.LargeTests;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Threads;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestChangingEncoding {
    private static final Log LOG = LogFactory.getLog(TestChangingEncoding.class);
    static final String CF = "EncodingTestCF";
    static final byte[] CF_BYTES = Bytes.toBytes((String)"EncodingTestCF");
    private static final int NUM_ROWS_PER_BATCH = 100;
    private static final int NUM_COLS_PER_ROW = 20;
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final Configuration conf = TEST_UTIL.getConfiguration();
    private static final int TIMEOUT_MS = 240000;
    private HBaseAdmin admin;
    private HColumnDescriptor hcd;
    private String tableName;
    private static final List<DataBlockEncoding> ENCODINGS_TO_ITERATE = TestChangingEncoding.createEncodingsToIterate();
    private int numBatchesWritten;

    private static final List<DataBlockEncoding> createEncodingsToIterate() {
        ArrayList<DataBlockEncoding> encodings = new ArrayList<DataBlockEncoding>(Arrays.asList(DataBlockEncoding.values()));
        encodings.add(DataBlockEncoding.NONE);
        return Collections.unmodifiableList(encodings);
    }

    private void prepareTest(String testId) throws IOException {
        this.tableName = "test_table_" + testId;
        HTableDescriptor htd = new HTableDescriptor(this.tableName);
        this.hcd = new HColumnDescriptor(CF);
        htd.addFamily(this.hcd);
        this.admin.createTable(htd);
        this.numBatchesWritten = 0;
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        conf.setInt("hbase.hregion.memstore.flush.size", 0x100000);
        TEST_UTIL.startMiniCluster();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() throws Exception {
        this.admin = new HBaseAdmin(conf);
    }

    @After
    public void tearDown() throws IOException {
        this.admin.close();
    }

    private static byte[] getRowKey(int batchId, int i) {
        return Bytes.toBytes((String)("batch" + batchId + "_row" + i));
    }

    private static byte[] getQualifier(int j) {
        return Bytes.toBytes((String)("col" + j));
    }

    private static byte[] getValue(int batchId, int i, int j) {
        return Bytes.toBytes((String)("value_for_" + Bytes.toString((byte[])TestChangingEncoding.getRowKey(batchId, i)) + "_col" + j));
    }

    static void writeTestDataBatch(Configuration conf, String tableName, int batchId) throws Exception {
        LOG.debug((Object)("Writing test data batch " + batchId));
        HTable table = new HTable(conf, tableName);
        for (int i = 0; i < 100; ++i) {
            Put put = new Put(TestChangingEncoding.getRowKey(batchId, i));
            for (int j = 0; j < 20; ++j) {
                put.add(CF_BYTES, TestChangingEncoding.getQualifier(j), TestChangingEncoding.getValue(batchId, i, j));
                table.put(put);
            }
        }
        table.close();
    }

    static void verifyTestDataBatch(Configuration conf, String tableName, int batchId) throws Exception {
        LOG.debug((Object)("Verifying test data batch " + batchId));
        HTable table = new HTable(conf, tableName);
        for (int i = 0; i < 100; ++i) {
            Get get = new Get(TestChangingEncoding.getRowKey(batchId, i));
            Result result = table.get(get);
            for (int j = 0; j < 20; ++j) {
                KeyValue kv = result.getColumnLatest(CF_BYTES, TestChangingEncoding.getQualifier(j));
                Assert.assertEquals((Object)Bytes.toStringBinary((byte[])TestChangingEncoding.getValue(batchId, i, j)), (Object)Bytes.toStringBinary((byte[])kv.getValue()));
            }
        }
        table.close();
    }

    private void writeSomeNewData() throws Exception {
        TestChangingEncoding.writeTestDataBatch(conf, this.tableName, this.numBatchesWritten);
        ++this.numBatchesWritten;
    }

    private void verifyAllData() throws Exception {
        for (int i = 0; i < this.numBatchesWritten; ++i) {
            TestChangingEncoding.verifyTestDataBatch(conf, this.tableName, i);
        }
    }

    private void setEncodingConf(DataBlockEncoding encoding, boolean encodeOnDisk) throws IOException {
        LOG.debug((Object)("Setting CF encoding to " + encoding + " (ordinal=" + encoding.ordinal() + "), encodeOnDisk=" + encodeOnDisk));
        this.admin.disableTable(this.tableName);
        this.hcd.setDataBlockEncoding(encoding);
        this.hcd.setEncodeOnDisk(encodeOnDisk);
        this.admin.modifyColumn(this.tableName, this.hcd);
        this.admin.enableTable(this.tableName);
    }

    @Test(timeout=240000L)
    public void testChangingEncoding() throws Exception {
        this.prepareTest("ChangingEncoding");
        for (boolean encodeOnDisk : new boolean[]{false, true}) {
            for (DataBlockEncoding encoding : ENCODINGS_TO_ITERATE) {
                this.setEncodingConf(encoding, encodeOnDisk);
                this.writeSomeNewData();
                this.verifyAllData();
            }
        }
    }

    @Test(timeout=240000L)
    public void testChangingEncodingWithCompaction() throws Exception {
        this.prepareTest("ChangingEncodingWithCompaction");
        for (boolean encodeOnDisk : new boolean[]{false, true}) {
            for (DataBlockEncoding encoding : ENCODINGS_TO_ITERATE) {
                this.setEncodingConf(encoding, encodeOnDisk);
                this.writeSomeNewData();
                this.verifyAllData();
                this.compactAndWait();
                this.verifyAllData();
            }
        }
    }

    @Test(timeout=240000L)
    public void testFlippingEncodeOnDisk() throws Exception {
        DataBlockEncoding[] encodings;
        this.prepareTest("FlippingEncodeOnDisk");
        for (DataBlockEncoding encoding : encodings = new DataBlockEncoding[]{DataBlockEncoding.NONE, DataBlockEncoding.FAST_DIFF}) {
            boolean[] flagValues = encoding == DataBlockEncoding.NONE ? new boolean[]{true} : new boolean[]{false, true, false, true};
            for (boolean encodeOnDisk : flagValues) {
                this.setEncodingConf(encoding, encodeOnDisk);
                this.writeSomeNewData();
                this.verifyAllData();
                this.compactAndWait();
                this.verifyAllData();
            }
        }
    }

    private void compactAndWait() throws IOException, InterruptedException {
        LOG.debug((Object)("Compacting table " + this.tableName));
        this.admin.majorCompact(this.tableName);
        Threads.sleepWithoutInterrupt((long)500L);
        HRegionServer rs = TEST_UTIL.getMiniHBaseCluster().getRegionServer(0);
        while (rs.compactSplitThread.getCompactionQueueSize() > 0) {
            Threads.sleep((long)50L);
        }
        LOG.debug((Object)"Compaction queue size reached 0, continuing");
    }

    @Test
    public void testCrazyRandomChanges() throws Exception {
        this.prepareTest("RandomChanges");
        Random rand = new Random(2934298742974297L);
        for (int i = 0; i < 20; ++i) {
            int encodingOrdinal = rand.nextInt(DataBlockEncoding.values().length);
            DataBlockEncoding encoding = DataBlockEncoding.values()[encodingOrdinal];
            this.setEncodingConf(encoding, rand.nextBoolean());
            this.writeSomeNewData();
            this.verifyAllData();
        }
    }
}

