/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.encoding;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.LruBlockCache;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.LoadTestKVGenerator;
import org.apache.hadoop.hbase.util.MultiThreadedWriter;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={SmallTests.class})
@RunWith(value=Parameterized.class)
public class TestEncodedSeekers {
    private static final String TABLE_NAME = "encodedSeekersTable";
    private static final String CF_NAME = "encodedSeekersCF";
    private static final byte[] CF_BYTES = Bytes.toBytes((String)"encodedSeekersCF");
    private static final int MAX_VERSIONS = 5;
    private static final int MIN_VALUE_SIZE = 30;
    private static final int MAX_VALUE_SIZE = 60;
    private static final int NUM_ROWS = 1000;
    private static final int NUM_COLS_PER_ROW = 20;
    private static final int NUM_HFILES = 4;
    private static final int NUM_ROWS_PER_FLUSH = 250;
    private final HBaseTestingUtility testUtil = new HBaseTestingUtility();
    private final DataBlockEncoding encoding;
    private final boolean encodeOnDisk;
    private static final boolean VERBOSE = false;

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        for (DataBlockEncoding encoding : DataBlockEncoding.values()) {
            for (boolean encodeOnDisk : new boolean[]{false, true}) {
                paramList.add(new Object[]{encoding, encodeOnDisk});
            }
        }
        return paramList;
    }

    public TestEncodedSeekers(DataBlockEncoding encoding, boolean encodeOnDisk) {
        this.encoding = encoding;
        this.encodeOnDisk = encodeOnDisk;
    }

    @Test
    public void testEncodedSeeker() throws IOException {
        System.err.println("Testing encoded seekers for encoding " + this.encoding);
        LruBlockCache cache = (LruBlockCache)new CacheConfig(this.testUtil.getConfiguration()).getBlockCache();
        cache.clearCache();
        HRegion region = this.testUtil.createTestRegion(TABLE_NAME, new HColumnDescriptor(CF_NAME).setMaxVersions(5).setDataBlockEncoding(this.encoding).setEncodeOnDisk(this.encodeOnDisk));
        LoadTestKVGenerator dataGenerator = new LoadTestKVGenerator(30, 60);
        for (int i = 0; i < 1000; ++i) {
            byte[] key = MultiThreadedWriter.longToByteArrayKey(i);
            for (int j = 0; j < 20; ++j) {
                Put put = new Put(key);
                String colAsStr = String.valueOf(j);
                byte[] value = dataGenerator.generateRandomSizeValue(i, colAsStr);
                put.add(CF_BYTES, Bytes.toBytes((String)colAsStr), value);
                region.put(put);
            }
            if (i % 250 != 0) continue;
            region.flushcache();
        }
        for (int doneCompaction = 0; doneCompaction <= 1; ++doneCompaction) {
            for (int i = 0; i < 1000; ++i) {
                byte[] rowKey = MultiThreadedWriter.longToByteArrayKey(i);
                for (int j = 0; j < 20; ++j) {
                    String qualStr = String.valueOf(j);
                    byte[] qualBytes = Bytes.toBytes((String)qualStr);
                    Get get = new Get(rowKey);
                    get.addColumn(CF_BYTES, qualBytes);
                    Result result = region.get(get, null);
                    Assert.assertEquals((long)1L, (long)result.size());
                    Assert.assertTrue((boolean)LoadTestKVGenerator.verify(Bytes.toString((byte[])rowKey), qualStr, result.getValue(CF_BYTES, qualBytes)));
                }
            }
            if (doneCompaction != 0) continue;
            region.compactStores();
        }
        Map encodingCounts = cache.getEncodingCountsForTest();
        System.err.println("encodingCounts=" + encodingCounts);
        Assert.assertEquals((long)1L, (long)encodingCounts.size());
        DataBlockEncoding encodingInCache = (DataBlockEncoding)encodingCounts.keySet().iterator().next();
        Assert.assertEquals((Object)this.encoding, (Object)encodingInCache);
        Assert.assertTrue(((Integer)encodingCounts.get(encodingInCache) > 0 ? 1 : 0) != 0);
    }
}

