/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.encoding;

import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.LargeTests;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.encoding.TestChangingEncoding;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestUpgradeFromHFileV1ToEncoding {
    private static final Log LOG = LogFactory.getLog(TestUpgradeFromHFileV1ToEncoding.class);
    private static final String TABLE = "UpgradeTable";
    private static final byte[] TABLE_BYTES = Bytes.toBytes((String)"UpgradeTable");
    private static HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final Configuration conf = TEST_UTIL.getConfiguration();
    private static final int NUM_HFILE_V1_BATCHES = 10;
    private static final int NUM_HFILE_V2_BATCHES = 20;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        conf.setInt("hbase.hregion.memstore.flush.size", 0x100000);
        conf.setInt("hfile.format.version", 1);
        TEST_UTIL.startMiniCluster();
        LOG.debug((Object)"Started an HFile v1 cluster");
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testUpgrade() throws Exception {
        int i;
        int numBatches = 0;
        HTableDescriptor htd = new HTableDescriptor(TABLE);
        HColumnDescriptor hcd = new HColumnDescriptor("EncodingTestCF");
        htd.addFamily(hcd);
        HBaseAdmin admin = new HBaseAdmin(conf);
        admin.createTable(htd);
        admin.close();
        for (i = 0; i < 10; ++i) {
            TestChangingEncoding.writeTestDataBatch(conf, TABLE, numBatches++);
        }
        TEST_UTIL.shutdownMiniHBaseCluster();
        conf.setInt("hfile.format.version", 2);
        TEST_UTIL.startMiniHBaseCluster(1, 1);
        LOG.debug((Object)"Started an HFile v2 cluster");
        admin = new HBaseAdmin(conf);
        htd = admin.getTableDescriptor(TABLE_BYTES);
        hcd = htd.getFamily(TestChangingEncoding.CF_BYTES);
        hcd.setDataBlockEncoding(DataBlockEncoding.PREFIX);
        admin.disableTable(TABLE);
        admin.modifyColumn(TABLE, hcd);
        admin.enableTable(TABLE);
        admin.close();
        for (i = 0; i < 20; ++i) {
            TestChangingEncoding.writeTestDataBatch(conf, TABLE, numBatches++);
        }
        LOG.debug((Object)"Verifying all 'batches', both HFile v1 and encoded HFile v2");
        this.verifyBatches(numBatches);
        LOG.debug((Object)"Doing a manual compaction");
        admin.compact(TABLE);
        Thread.sleep(TimeUnit.SECONDS.toMillis(10L));
        LOG.debug((Object)"Verify all the data again");
        this.verifyBatches(numBatches);
    }

    private void verifyBatches(int numBatches) throws Exception {
        for (int i = 0; i < numBatches; ++i) {
            TestChangingEncoding.verifyTestDataBatch(conf, TABLE, i);
        }
    }
}

