/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.io.hfile.Compression;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.metrics.SchemaMetrics;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={MediumTests.class})
@RunWith(value=Parameterized.class)
public class TestForceCacheImportantBlocks {
    private final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final String TABLE = "myTable";
    private static final String CF = "myCF";
    private static final byte[] CF_BYTES = Bytes.toBytes((String)"myCF");
    private static final int MAX_VERSIONS = 3;
    private static final int NUM_HFILES = 5;
    private static final int ROWS_PER_HFILE = 100;
    private static final int NUM_ROWS = 500;
    private static final int NUM_COLS_PER_ROW = 50;
    private static final int NUM_TIMESTAMPS_PER_COL = 50;
    private static final int BLOCK_SIZE = 256;
    private static final Compression.Algorithm COMPRESSION_ALGORITHM = Compression.Algorithm.GZ;
    private static final StoreFile.BloomType BLOOM_TYPE = StoreFile.BloomType.ROW;
    private final int hfileVersion;
    private final boolean cfCacheEnabled;

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({new Integer(1), false}, {new Integer(1), true}, {new Integer(2), false}, {new Integer(2), true});
    }

    public TestForceCacheImportantBlocks(int hfileVersion, boolean cfCacheEnabled) {
        this.hfileVersion = hfileVersion;
        this.cfCacheEnabled = cfCacheEnabled;
        this.TEST_UTIL.getConfiguration().setInt("hfile.format.version", hfileVersion);
    }

    @Test
    public void testCacheBlocks() throws IOException {
        this.TEST_UTIL.getConfiguration().setInt("hfile.index.block.max.size", 256);
        SchemaMetrics.setUseTableNameInTest((boolean)false);
        HColumnDescriptor hcd = new HColumnDescriptor(Bytes.toBytes((String)CF)).setMaxVersions(3).setCompressionType(COMPRESSION_ALGORITHM).setBloomFilterType(BLOOM_TYPE);
        hcd.setBlocksize(256);
        hcd.setBlockCacheEnabled(this.cfCacheEnabled);
        HRegion region = this.TEST_UTIL.createTestRegion(TABLE, hcd);
        this.writeTestData(region);
        Map metricsBefore = SchemaMetrics.getMetricsSnapshot();
        for (int i = 0; i < 500; ++i) {
            Get get = new Get(Bytes.toBytes((String)("row" + i)));
            region.get(get, null);
        }
        SchemaMetrics.validateMetricChanges((Map)metricsBefore);
        Map metricsAfter = SchemaMetrics.getMetricsSnapshot();
        Map metricsDelta = SchemaMetrics.diffMetrics((Map)metricsBefore, (Map)metricsAfter);
        SchemaMetrics metrics = SchemaMetrics.getInstance((String)TABLE, (String)CF);
        ArrayList<BlockType.BlockCategory> importantBlockCategories = new ArrayList<BlockType.BlockCategory>();
        importantBlockCategories.add(BlockType.BlockCategory.BLOOM);
        if (this.hfileVersion == 2) {
            importantBlockCategories.add(BlockType.BlockCategory.INDEX);
        }
        for (BlockType.BlockCategory category : importantBlockCategories) {
            String hitsMetricName = this.getMetricName(metrics, category);
            Assert.assertTrue((String)("Metric " + hitsMetricName + " was not incremented"), (boolean)metricsDelta.containsKey(hitsMetricName));
            long hits = (Long)metricsDelta.get(hitsMetricName);
            Assert.assertTrue((String)("Invalid value of " + hitsMetricName + ": " + hits), (hits > 0L ? 1 : 0) != 0);
        }
        if (!this.cfCacheEnabled) {
            String dataHitMetricName = this.getMetricName(metrics, BlockType.BlockCategory.DATA);
            Assert.assertFalse((String)("Nonzero value for metric " + dataHitMetricName), (boolean)metricsDelta.containsKey(dataHitMetricName));
        }
    }

    private String getMetricName(SchemaMetrics metrics, BlockType.BlockCategory category) {
        String hitsMetricName = metrics.getBlockMetricName(category, false, SchemaMetrics.BlockMetricType.CACHE_HIT);
        return hitsMetricName;
    }

    private void writeTestData(HRegion region) throws IOException {
        for (int i = 0; i < 500; ++i) {
            Put put = new Put(Bytes.toBytes((String)("row" + i)));
            for (int j = 0; j < 50; ++j) {
                for (long ts = 1L; ts < 50L; ++ts) {
                    put.add(CF_BYTES, Bytes.toBytes((String)("col" + j)), ts, Bytes.toBytes((String)("value" + i + "_" + j + "_" + ts)));
                }
            }
            region.put(put);
            if ((i + 1) % 100 != 0) continue;
            region.flushcache();
        }
    }
}

