/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.mapreduce.ImportTsv;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.util.GenericOptionsParser;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestImportTsv {
    private static final Log LOG = LogFactory.getLog(TestImportTsv.class);
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    @Test
    public void testTsvParserSpecParsing() {
        ImportTsv.TsvParser parser = new ImportTsv.TsvParser("HBASE_ROW_KEY", "\t");
        Assert.assertNull((Object)parser.getFamily(0));
        Assert.assertNull((Object)parser.getQualifier(0));
        Assert.assertEquals((long)0L, (long)parser.getRowKeyColumnIndex());
        Assert.assertFalse((boolean)parser.hasTimestamp());
        parser = new ImportTsv.TsvParser("HBASE_ROW_KEY,col1:scol1", "\t");
        Assert.assertNull((Object)parser.getFamily(0));
        Assert.assertNull((Object)parser.getQualifier(0));
        this.assertBytesEquals(Bytes.toBytes((String)"col1"), parser.getFamily(1));
        this.assertBytesEquals(Bytes.toBytes((String)"scol1"), parser.getQualifier(1));
        Assert.assertEquals((long)0L, (long)parser.getRowKeyColumnIndex());
        Assert.assertFalse((boolean)parser.hasTimestamp());
        parser = new ImportTsv.TsvParser("HBASE_ROW_KEY,col1:scol1,col1:scol2", "\t");
        Assert.assertNull((Object)parser.getFamily(0));
        Assert.assertNull((Object)parser.getQualifier(0));
        this.assertBytesEquals(Bytes.toBytes((String)"col1"), parser.getFamily(1));
        this.assertBytesEquals(Bytes.toBytes((String)"scol1"), parser.getQualifier(1));
        this.assertBytesEquals(Bytes.toBytes((String)"col1"), parser.getFamily(2));
        this.assertBytesEquals(Bytes.toBytes((String)"scol2"), parser.getQualifier(2));
        Assert.assertEquals((long)0L, (long)parser.getRowKeyColumnIndex());
        Assert.assertFalse((boolean)parser.hasTimestamp());
        parser = new ImportTsv.TsvParser("HBASE_ROW_KEY,col1:scol1,HBASE_TS_KEY,col1:scol2", "\t");
        Assert.assertNull((Object)parser.getFamily(0));
        Assert.assertNull((Object)parser.getQualifier(0));
        this.assertBytesEquals(Bytes.toBytes((String)"col1"), parser.getFamily(1));
        this.assertBytesEquals(Bytes.toBytes((String)"scol1"), parser.getQualifier(1));
        this.assertBytesEquals(Bytes.toBytes((String)"col1"), parser.getFamily(3));
        this.assertBytesEquals(Bytes.toBytes((String)"scol2"), parser.getQualifier(3));
        Assert.assertEquals((long)0L, (long)parser.getRowKeyColumnIndex());
        Assert.assertTrue((boolean)parser.hasTimestamp());
        Assert.assertEquals((long)2L, (long)parser.getTimestampKeyColumnIndex());
    }

    @Test
    public void testTsvParser() throws ImportTsv.TsvParser.BadTsvLineException {
        ImportTsv.TsvParser parser = new ImportTsv.TsvParser("col_a,col_b:qual,HBASE_ROW_KEY,col_d", "\t");
        this.assertBytesEquals(Bytes.toBytes((String)"col_a"), parser.getFamily(0));
        this.assertBytesEquals(HConstants.EMPTY_BYTE_ARRAY, parser.getQualifier(0));
        this.assertBytesEquals(Bytes.toBytes((String)"col_b"), parser.getFamily(1));
        this.assertBytesEquals(Bytes.toBytes((String)"qual"), parser.getQualifier(1));
        Assert.assertNull((Object)parser.getFamily(2));
        Assert.assertNull((Object)parser.getQualifier(2));
        Assert.assertEquals((long)2L, (long)parser.getRowKeyColumnIndex());
        Assert.assertEquals((long)-1L, (long)parser.getTimestampKeyColumnIndex());
        byte[] line = Bytes.toBytes((String)"val_a\tval_b\tval_c\tval_d");
        ImportTsv.TsvParser.ParsedLine parsed = parser.parse(line, line.length);
        this.checkParsing(parsed, Splitter.on((String)"\t").split((CharSequence)Bytes.toString((byte[])line)));
    }

    @Test
    public void testTsvParserWithTimestamp() throws ImportTsv.TsvParser.BadTsvLineException {
        ImportTsv.TsvParser parser = new ImportTsv.TsvParser("HBASE_ROW_KEY,HBASE_TS_KEY,col_a,", "\t");
        Assert.assertNull((Object)parser.getFamily(0));
        Assert.assertNull((Object)parser.getQualifier(0));
        Assert.assertNull((Object)parser.getFamily(1));
        Assert.assertNull((Object)parser.getQualifier(1));
        this.assertBytesEquals(Bytes.toBytes((String)"col_a"), parser.getFamily(2));
        this.assertBytesEquals(HConstants.EMPTY_BYTE_ARRAY, parser.getQualifier(2));
        Assert.assertEquals((long)0L, (long)parser.getRowKeyColumnIndex());
        Assert.assertEquals((long)1L, (long)parser.getTimestampKeyColumnIndex());
        byte[] line = Bytes.toBytes((String)"rowkey\t1234\tval_a");
        ImportTsv.TsvParser.ParsedLine parsed = parser.parse(line, line.length);
        Assert.assertEquals((long)1234L, (long)parsed.getTimestamp(-1L));
        this.checkParsing(parsed, Splitter.on((String)"\t").split((CharSequence)Bytes.toString((byte[])line)));
    }

    private void checkParsing(ImportTsv.TsvParser.ParsedLine parsed, Iterable<String> expected) {
        ArrayList<String> parsedCols = new ArrayList<String>();
        for (int i = 0; i < parsed.getColumnCount(); ++i) {
            parsedCols.add(Bytes.toString((byte[])parsed.getLineBytes(), (int)parsed.getColumnOffset(i), (int)parsed.getColumnLength(i)));
        }
        if (!Iterables.elementsEqual(parsedCols, expected)) {
            Assert.fail((String)("Expected: " + Joiner.on((String)",").join(expected) + "\n" + "Got:" + Joiner.on((String)",").join(parsedCols)));
        }
    }

    private void assertBytesEquals(byte[] a, byte[] b) {
        Assert.assertEquals((Object)Bytes.toStringBinary((byte[])a), (Object)Bytes.toStringBinary((byte[])b));
    }

    @Test(expected=ImportTsv.TsvParser.BadTsvLineException.class)
    public void testTsvParserBadTsvLineExcessiveColumns() throws ImportTsv.TsvParser.BadTsvLineException {
        ImportTsv.TsvParser parser = new ImportTsv.TsvParser("HBASE_ROW_KEY,col_a", "\t");
        byte[] line = Bytes.toBytes((String)"val_a\tval_b\tval_c");
        parser.parse(line, line.length);
    }

    @Test(expected=ImportTsv.TsvParser.BadTsvLineException.class)
    public void testTsvParserBadTsvLineZeroColumn() throws ImportTsv.TsvParser.BadTsvLineException {
        ImportTsv.TsvParser parser = new ImportTsv.TsvParser("HBASE_ROW_KEY,col_a", "\t");
        byte[] line = Bytes.toBytes((String)"");
        parser.parse(line, line.length);
    }

    @Test(expected=ImportTsv.TsvParser.BadTsvLineException.class)
    public void testTsvParserBadTsvLineOnlyKey() throws ImportTsv.TsvParser.BadTsvLineException {
        ImportTsv.TsvParser parser = new ImportTsv.TsvParser("HBASE_ROW_KEY,col_a", "\t");
        byte[] line = Bytes.toBytes((String)"key_only");
        parser.parse(line, line.length);
    }

    @Test(expected=ImportTsv.TsvParser.BadTsvLineException.class)
    public void testTsvParserBadTsvLineNoRowKey() throws ImportTsv.TsvParser.BadTsvLineException {
        ImportTsv.TsvParser parser = new ImportTsv.TsvParser("col_a,HBASE_ROW_KEY", "\t");
        byte[] line = Bytes.toBytes((String)"only_cola_data_and_no_row_key");
        parser.parse(line, line.length);
    }

    @Test(expected=ImportTsv.TsvParser.BadTsvLineException.class)
    public void testTsvParserInvalidTimestamp() throws ImportTsv.TsvParser.BadTsvLineException {
        ImportTsv.TsvParser parser = new ImportTsv.TsvParser("HBASE_ROW_KEY,HBASE_TS_KEY,col_a,", "\t");
        Assert.assertEquals((long)1L, (long)parser.getTimestampKeyColumnIndex());
        byte[] line = Bytes.toBytes((String)"rowkey\ttimestamp\tval_a");
        ImportTsv.TsvParser.ParsedLine parsed = parser.parse(line, line.length);
        Assert.assertEquals((long)-1L, (long)parsed.getTimestamp(-1L));
        this.checkParsing(parsed, Splitter.on((String)"\t").split((CharSequence)Bytes.toString((byte[])line)));
    }

    @Test(expected=ImportTsv.TsvParser.BadTsvLineException.class)
    public void testTsvParserNoTimestampValue() throws ImportTsv.TsvParser.BadTsvLineException {
        ImportTsv.TsvParser parser = new ImportTsv.TsvParser("HBASE_ROW_KEY,col_a,HBASE_TS_KEY", "\t");
        Assert.assertEquals((long)2L, (long)parser.getTimestampKeyColumnIndex());
        byte[] line = Bytes.toBytes((String)"rowkey\tval_a");
        parser.parse(line, line.length);
    }

    @Test
    public void testMROnTable() throws Exception {
        String TABLE_NAME = "TestTable";
        String FAMILY = "FAM";
        String INPUT_FILE = "InputFile.esv";
        String[] args = new String[]{"-Dimporttsv.columns=HBASE_ROW_KEY,FAM:A,FAM:B", "-Dimporttsv.separator=\u001b", TABLE_NAME, INPUT_FILE};
        this.doMROnTableTest(INPUT_FILE, FAMILY, TABLE_NAME, null, args, 1);
    }

    @Test
    public void testMROnTableWithTimestamp() throws Exception {
        String TABLE_NAME = "TestTable";
        String FAMILY = "FAM";
        String INPUT_FILE = "InputFile1.csv";
        String[] args = new String[]{"-Dimporttsv.columns=HBASE_ROW_KEY,HBASE_TS_KEY,FAM:A,FAM:B", "-Dimporttsv.separator=,", TABLE_NAME, INPUT_FILE};
        String data = "KEY,1234,VALUE1,VALUE2\n";
        this.doMROnTableTest(INPUT_FILE, FAMILY, TABLE_NAME, data, args, 1);
    }

    @Test
    public void testMROnTableWithCustomMapper() throws Exception {
        String TABLE_NAME = "TestTable";
        String FAMILY = "FAM";
        String INPUT_FILE = "InputFile2.esv";
        String[] args = new String[]{"-Dimporttsv.mapper.class=org.apache.hadoop.hbase.mapreduce.TsvImporterCustomTestMapper", TABLE_NAME, INPUT_FILE};
        this.doMROnTableTest(INPUT_FILE, FAMILY, TABLE_NAME, null, args, 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doMROnTableTest(String inputFile, String family, String tableName, String data, String[] args, int valueMultiplier) throws Exception {
        HBaseTestingUtility htu1 = new HBaseTestingUtility();
        htu1.startMiniCluster();
        htu1.startMiniMapReduceCluster();
        GenericOptionsParser opts = new GenericOptionsParser(htu1.getConfiguration(), args);
        Configuration conf = opts.getConfiguration();
        args = opts.getRemainingArgs();
        try {
            FileSystem fs = FileSystem.get((Configuration)conf);
            FSDataOutputStream op = fs.create(new Path(inputFile), true);
            if (data == null) {
                data = "KEY\u001bVALUE1\u001bVALUE2\n";
            }
            op.write(Bytes.toBytes((String)data));
            op.close();
            byte[] FAM = Bytes.toBytes((String)family);
            byte[] TAB = Bytes.toBytes((String)tableName);
            if (conf.get("importtsv.bulk.output") == null) {
                HTableDescriptor desc = new HTableDescriptor(TAB);
                desc.addFamily(new HColumnDescriptor(FAM));
                HBaseAdmin admin = new HBaseAdmin(conf);
                admin.createTable(desc);
                admin.close();
            } else {
                LOG.info((Object)"set the hbaseAdmin");
                ImportTsv.createHbaseAdmin((Configuration)conf);
            }
            Job job = ImportTsv.createSubmittableJob((Configuration)conf, (String[])args);
            job.waitForCompletion(false);
            Assert.assertTrue((boolean)job.isSuccessful());
            HTable table = new HTable(new Configuration(conf), TAB);
            boolean verified = false;
            long pause = conf.getLong("hbase.client.pause", 5000L);
            int numRetries = conf.getInt("hbase.client.retries.number", 5);
            for (int i = 0; i < numRetries; ++i) {
                try {
                    Scan scan = new Scan();
                    scan.addFamily(FAM);
                    ResultScanner resScanner = table.getScanner(scan);
                    for (Result res : resScanner) {
                        Assert.assertTrue((res.size() == 2 ? 1 : 0) != 0);
                        List kvs = res.list();
                        Assert.assertEquals((Object)TestImportTsv.toU8Str(((KeyValue)kvs.get(0)).getRow()), (Object)TestImportTsv.toU8Str(Bytes.toBytes((String)"KEY")));
                        Assert.assertEquals((Object)TestImportTsv.toU8Str(((KeyValue)kvs.get(1)).getRow()), (Object)TestImportTsv.toU8Str(Bytes.toBytes((String)"KEY")));
                        Assert.assertEquals((Object)TestImportTsv.toU8Str(((KeyValue)kvs.get(0)).getValue()), (Object)TestImportTsv.toU8Str(Bytes.toBytes((String)("VALUE" + valueMultiplier))));
                        Assert.assertEquals((Object)TestImportTsv.toU8Str(((KeyValue)kvs.get(1)).getValue()), (Object)TestImportTsv.toU8Str(Bytes.toBytes((String)("VALUE" + 2 * valueMultiplier))));
                    }
                    verified = true;
                    break;
                }
                catch (NullPointerException e) {
                    try {
                        Thread.sleep(pause);
                    }
                    catch (InterruptedException e2) {
                        // empty catch block
                    }
                    continue;
                }
            }
            table.close();
            Assert.assertTrue((boolean)verified);
        }
        finally {
            htu1.shutdownMiniMapReduceCluster();
            htu1.shutdownMiniCluster();
        }
    }

    @Test
    public void testBulkOutputWithoutAnExistingTable() throws Exception {
        String TABLE_NAME = "TestTable";
        String FAMILY = "FAM";
        String INPUT_FILE = "InputFile2.esv";
        String[] args = new String[]{"-Dimporttsv.columns=HBASE_ROW_KEY,FAM:A,FAM:B", "-Dimporttsv.separator=\u001b", "-Dimporttsv.bulk.output=output", TABLE_NAME, INPUT_FILE};
        this.doMROnTableTest(INPUT_FILE, FAMILY, TABLE_NAME, null, args, 3);
    }

    public static String toU8Str(byte[] bytes) throws UnsupportedEncodingException {
        return new String(bytes);
    }
}

