/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import com.google.common.collect.Multimap;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.NavigableMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.LargeTests;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.ipc.HRegionInterface;
import org.apache.hadoop.hbase.mapreduce.LoadIncrementalHFiles;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.TestHRegionServerBulkLoad;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={LargeTests.class})
public class TestLoadIncrementalHFilesSplitRecovery {
    static final Log LOG = LogFactory.getLog(TestHRegionServerBulkLoad.class);
    static HBaseTestingUtility util;
    static boolean useSecure;
    static final int NUM_CFS = 10;
    static final byte[] QUAL;
    static final int ROWCOUNT = 100;
    private static final byte[][] families;
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    static byte[] rowkey(int i) {
        return Bytes.toBytes((String)String.format("row_%08d", i));
    }

    static String family(int i) {
        return String.format("family_%04d", i);
    }

    static byte[] value(int i) {
        return Bytes.toBytes((String)String.format("%010d", i));
    }

    public static void buildHFiles(FileSystem fs, Path dir, int value) throws IOException {
        byte[] val = TestLoadIncrementalHFilesSplitRecovery.value(value);
        for (int i = 0; i < 10; ++i) {
            Path testIn = new Path(dir, TestLoadIncrementalHFilesSplitRecovery.family(i));
            TestHRegionServerBulkLoad.createHFile(fs, new Path(testIn, "hfile_" + i), Bytes.toBytes((String)TestLoadIncrementalHFilesSplitRecovery.family(i)), QUAL, val, 100);
        }
    }

    private void setupTable(String table, int cfs) throws IOException {
        try {
            LOG.info((Object)("Creating table " + table));
            HTableDescriptor htd = new HTableDescriptor(table);
            for (int i = 0; i < 10; ++i) {
                htd.addFamily(new HColumnDescriptor(TestLoadIncrementalHFilesSplitRecovery.family(i)));
            }
            util.getHBaseAdmin().createTable(htd);
        }
        catch (TableExistsException tee) {
            LOG.info((Object)("Table " + table + " already exists"));
        }
    }

    private Path buildBulkFiles(String table, int value) throws Exception {
        Path dir = util.getDataTestDir(table);
        Path bulk1 = new Path(dir, table + value);
        FileSystem fs = util.getTestFileSystem();
        TestLoadIncrementalHFilesSplitRecovery.buildHFiles(fs, bulk1, value);
        return bulk1;
    }

    private void populateTable(String table, int value) throws Exception {
        LoadIncrementalHFiles lih = new LoadIncrementalHFiles(util.getConfiguration(), Boolean.valueOf(useSecure));
        Path bulk1 = this.buildBulkFiles(table, value);
        HTable t = new HTable(util.getConfiguration(), Bytes.toBytes((String)table));
        lih.doBulkLoad(bulk1, t);
    }

    private void forceSplit(String table) {
        try {
            int regions;
            HRegionServer hrs = util.getRSForFirstRegionInTable(Bytes.toBytes((String)table));
            for (HRegionInfo hri : hrs.getOnlineRegions()) {
                if (!Bytes.equals((byte[])hri.getTableName(), (byte[])Bytes.toBytes((String)table))) continue;
                hrs.splitRegion(hri, TestLoadIncrementalHFilesSplitRecovery.rowkey(50));
            }
            do {
                regions = 0;
                for (HRegionInfo hri : hrs.getOnlineRegions()) {
                    if (!Bytes.equals((byte[])hri.getTableName(), (byte[])Bytes.toBytes((String)table))) continue;
                    ++regions;
                }
                if (regions == 2) continue;
                LOG.info((Object)"Taking some time to complete split...");
                Thread.sleep(250L);
            } while (regions != 2);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @BeforeClass
    public static void setupCluster() throws Exception {
        util = new HBaseTestingUtility();
        util.startMiniCluster(1);
    }

    @AfterClass
    public static void teardownCluster() throws Exception {
        util.shutdownMiniCluster();
    }

    void assertExpectedTable(String table, int count, int value) {
        try {
            Assert.assertEquals((long)util.getHBaseAdmin().listTables(table).length, (long)1L);
            HTable t = new HTable(util.getConfiguration(), table);
            Scan s = new Scan();
            ResultScanner sr = t.getScanner(s);
            int i = 0;
            for (Result r : sr) {
                ++i;
                for (NavigableMap nm : r.getNoVersionMap().values()) {
                    for (byte[] val : nm.values()) {
                        Assert.assertTrue((boolean)Bytes.equals((byte[])val, (byte[])TestLoadIncrementalHFilesSplitRecovery.value(value)));
                    }
                }
            }
            Assert.assertEquals((long)count, (long)i);
        }
        catch (IOException e) {
            Assert.fail((String)"Failed due to exception");
        }
    }

    @Test(expected=IOException.class)
    public void testBulkLoadPhaseFailure() throws Exception {
        String table = "bulkLoadPhaseFailure";
        this.setupTable(table, 10);
        final AtomicInteger attmptedCalls = new AtomicInteger();
        final AtomicInteger failedCalls = new AtomicInteger();
        LoadIncrementalHFiles lih = new LoadIncrementalHFiles(util.getConfiguration(), useSecure){

            protected List<LoadIncrementalHFiles.LoadQueueItem> tryAtomicRegionLoad(HConnection conn, byte[] tableName, byte[] first, Collection<LoadIncrementalHFiles.LoadQueueItem> lqis) throws IOException {
                int i = attmptedCalls.incrementAndGet();
                if (i == 1) {
                    HConnection errConn = null;
                    try {
                        errConn = TestLoadIncrementalHFilesSplitRecovery.this.getMockedConnection(util.getConfiguration());
                    }
                    catch (Exception e) {
                        LOG.fatal((Object)"mocking cruft, should never happen", (Throwable)e);
                        throw new RuntimeException("mocking cruft, should never happen");
                    }
                    failedCalls.incrementAndGet();
                    return super.tryAtomicRegionLoad(errConn, tableName, first, lqis);
                }
                return super.tryAtomicRegionLoad(conn, tableName, first, lqis);
            }
        };
        Path dir = this.buildBulkFiles(table, 1);
        HTable t = new HTable(util.getConfiguration(), Bytes.toBytes((String)table));
        lih.doBulkLoad(dir, t);
        Assert.fail((String)"doBulkLoad should have thrown an exception");
    }

    private HConnection getMockedConnection(Configuration conf) throws IOException {
        HConnection c = (HConnection)Mockito.mock(HConnection.class);
        Mockito.when((Object)c.getConfiguration()).thenReturn((Object)conf);
        ((HConnection)Mockito.doNothing().when((Object)c)).close();
        HRegionLocation loc = new HRegionLocation(HRegionInfo.FIRST_META_REGIONINFO, "example.org", 1234);
        Mockito.when((Object)c.getRegionLocation((byte[])Mockito.any(), (byte[])Mockito.any(), Mockito.anyBoolean())).thenReturn((Object)loc);
        Mockito.when((Object)c.locateRegion((byte[])Mockito.any(), (byte[])Mockito.any())).thenReturn((Object)loc);
        HRegionInterface hri = (HRegionInterface)Mockito.mock(HRegionInterface.class);
        Mockito.when((Object)hri.bulkLoadHFiles(Mockito.anyList(), (byte[])Mockito.any())).thenThrow(new Throwable[]{new IOException("injecting bulk load error")});
        Mockito.when((Object)c.getHRegionConnection(Mockito.anyString(), Mockito.anyInt())).thenReturn((Object)hri);
        return c;
    }

    @Test
    public void testSplitWhileBulkLoadPhase() throws Exception {
        String table = "splitWhileBulkloadPhase";
        this.setupTable("splitWhileBulkloadPhase", 10);
        this.populateTable("splitWhileBulkloadPhase", 1);
        this.assertExpectedTable("splitWhileBulkloadPhase", 100, 1);
        final AtomicInteger attemptedCalls = new AtomicInteger();
        LoadIncrementalHFiles lih2 = new LoadIncrementalHFiles(util.getConfiguration(), useSecure){

            protected void bulkLoadPhase(HTable htable, HConnection conn, ExecutorService pool, Deque<LoadIncrementalHFiles.LoadQueueItem> queue, Multimap<ByteBuffer, LoadIncrementalHFiles.LoadQueueItem> regionGroups) throws IOException {
                int i = attemptedCalls.incrementAndGet();
                if (i == 1) {
                    TestLoadIncrementalHFilesSplitRecovery.this.forceSplit("splitWhileBulkloadPhase");
                }
                super.bulkLoadPhase(htable, conn, pool, queue, regionGroups);
            }
        };
        HTable t = new HTable(util.getConfiguration(), Bytes.toBytes((String)"splitWhileBulkloadPhase"));
        Path bulk = this.buildBulkFiles("splitWhileBulkloadPhase", 2);
        lih2.doBulkLoad(bulk, t);
        Assert.assertEquals((long)attemptedCalls.get(), (long)3L);
        this.assertExpectedTable("splitWhileBulkloadPhase", 100, 2);
    }

    @Test
    public void testGroupOrSplitPresplit() throws Exception {
        String table = "groupOrSplitPresplit";
        this.setupTable("groupOrSplitPresplit", 10);
        this.populateTable("groupOrSplitPresplit", 1);
        this.assertExpectedTable("groupOrSplitPresplit", 100, 1);
        this.forceSplit("groupOrSplitPresplit");
        final AtomicInteger countedLqis = new AtomicInteger();
        LoadIncrementalHFiles lih = new LoadIncrementalHFiles(util.getConfiguration(), useSecure){

            protected List<LoadIncrementalHFiles.LoadQueueItem> groupOrSplit(Multimap<ByteBuffer, LoadIncrementalHFiles.LoadQueueItem> regionGroups, LoadIncrementalHFiles.LoadQueueItem item, HTable htable, Pair<byte[][], byte[][]> startEndKeys) throws IOException {
                List lqis = super.groupOrSplit(regionGroups, item, htable, startEndKeys);
                if (lqis != null) {
                    countedLqis.addAndGet(lqis.size());
                }
                return lqis;
            }
        };
        Path bulk = this.buildBulkFiles("groupOrSplitPresplit", 2);
        HTable ht = new HTable(util.getConfiguration(), Bytes.toBytes((String)"groupOrSplitPresplit"));
        lih.doBulkLoad(bulk, ht);
        this.assertExpectedTable("groupOrSplitPresplit", 100, 2);
        Assert.assertEquals((long)20L, (long)countedLqis.get());
    }

    @Test(expected=IOException.class)
    public void testGroupOrSplitFailure() throws Exception {
        String table = "groupOrSplitFailure";
        this.setupTable(table, 10);
        LoadIncrementalHFiles lih = new LoadIncrementalHFiles(util.getConfiguration(), useSecure){
            int i;
            {
                this.i = 0;
            }

            protected List<LoadIncrementalHFiles.LoadQueueItem> groupOrSplit(Multimap<ByteBuffer, LoadIncrementalHFiles.LoadQueueItem> regionGroups, LoadIncrementalHFiles.LoadQueueItem item, HTable table, Pair<byte[][], byte[][]> startEndKeys) throws IOException {
                ++this.i;
                if (this.i == 5) {
                    throw new IOException("failure");
                }
                return super.groupOrSplit(regionGroups, item, table, startEndKeys);
            }
        };
        Path dir = this.buildBulkFiles(table, 1);
        HTable t = new HTable(util.getConfiguration(), Bytes.toBytes((String)table));
        lih.doBulkLoad(dir, t);
        Assert.fail((String)"doBulkLoad should have thrown an exception");
    }

    static {
        useSecure = false;
        QUAL = Bytes.toBytes((String)"qual");
        families = new byte[10][];
        for (int i = 0; i < 10; ++i) {
            TestLoadIncrementalHFilesSplitRecovery.families[i] = Bytes.toBytes((String)TestLoadIncrementalHFilesSplitRecovery.family(i));
        }
    }
}

