/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.master.DeadServer;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestDeadServer {
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    @Test
    public void testIsDead() {
        DeadServer ds = new DeadServer();
        ServerName hostname123 = new ServerName("127.0.0.1", 123, 3L);
        ds.add(hostname123);
        Assert.assertTrue((boolean)ds.areDeadServersInProgress());
        ds.finish(hostname123);
        Assert.assertFalse((boolean)ds.areDeadServersInProgress());
        ServerName hostname1234 = new ServerName("127.0.0.2", 1234, 4L);
        ds.add(hostname1234);
        Assert.assertTrue((boolean)ds.areDeadServersInProgress());
        ds.finish(hostname1234);
        Assert.assertFalse((boolean)ds.areDeadServersInProgress());
        ServerName hostname12345 = new ServerName("127.0.0.2", 12345, 4L);
        ds.add(hostname12345);
        Assert.assertTrue((boolean)ds.areDeadServersInProgress());
        ds.finish(hostname12345);
        Assert.assertFalse((boolean)ds.areDeadServersInProgress());
        ServerName deadServer = new ServerName("127.0.0.1", 9090, 112321L);
        Assert.assertFalse((boolean)ds.cleanPreviousInstance(deadServer));
        ds.add(deadServer);
        Assert.assertTrue((boolean)ds.isDeadServer(deadServer));
        ServerName deadServerHostComingAlive = new ServerName("127.0.0.1", 9090, 112321L);
        Assert.assertTrue((boolean)ds.cleanPreviousInstance(deadServerHostComingAlive));
        Assert.assertFalse((boolean)ds.isDeadServer(deadServer));
        Assert.assertFalse((boolean)ds.cleanPreviousInstance(deadServerHostComingAlive));
    }
}

