/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.handler;

import java.io.IOException;
import java.util.Set;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.LargeTests;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSTableDescriptors;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestTableDescriptorModification {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final byte[] TABLE_NAME = Bytes.toBytes((String)"table");
    private static final byte[] FAMILY_0 = Bytes.toBytes((String)"cf0");
    private static final byte[] FAMILY_1 = Bytes.toBytes((String)"cf1");

    @BeforeClass
    public static void beforeAllTests() throws Exception {
        TEST_UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void afterAllTests() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testModifyTable() throws IOException {
        HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
        HTableDescriptor baseHtd = new HTableDescriptor(TABLE_NAME);
        baseHtd.addFamily(new HColumnDescriptor(FAMILY_0));
        admin.createTable(baseHtd);
        admin.disableTable(TABLE_NAME);
        try {
            this.verifyTableDescriptor(TABLE_NAME, new byte[][]{FAMILY_0});
            HTableDescriptor modifiedHtd = new HTableDescriptor(TABLE_NAME);
            modifiedHtd.addFamily(new HColumnDescriptor(FAMILY_0));
            modifiedHtd.addFamily(new HColumnDescriptor(FAMILY_1));
            admin.modifyTable(TABLE_NAME, modifiedHtd);
            this.verifyTableDescriptor(TABLE_NAME, FAMILY_0, FAMILY_1);
        }
        finally {
            admin.deleteTable(TABLE_NAME);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddColumn() throws IOException {
        HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
        HTableDescriptor baseHtd = new HTableDescriptor(TABLE_NAME);
        baseHtd.addFamily(new HColumnDescriptor(FAMILY_0));
        admin.createTable(baseHtd);
        admin.disableTable(TABLE_NAME);
        try {
            this.verifyTableDescriptor(TABLE_NAME, new byte[][]{FAMILY_0});
            admin.addColumn(TABLE_NAME, new HColumnDescriptor(FAMILY_1));
            this.verifyTableDescriptor(TABLE_NAME, FAMILY_0, FAMILY_1);
        }
        finally {
            admin.deleteTable(TABLE_NAME);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteColumn() throws IOException {
        HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
        HTableDescriptor baseHtd = new HTableDescriptor(TABLE_NAME);
        baseHtd.addFamily(new HColumnDescriptor(FAMILY_0));
        baseHtd.addFamily(new HColumnDescriptor(FAMILY_1));
        admin.createTable(baseHtd);
        admin.disableTable(TABLE_NAME);
        try {
            this.verifyTableDescriptor(TABLE_NAME, FAMILY_0, FAMILY_1);
            admin.deleteColumn(TABLE_NAME, FAMILY_1);
            this.verifyTableDescriptor(TABLE_NAME, new byte[][]{FAMILY_0});
        }
        finally {
            admin.deleteTable(TABLE_NAME);
        }
    }

    private void verifyTableDescriptor(byte[] tableName, byte[] ... families) throws IOException {
        HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
        HTableDescriptor htd = admin.getTableDescriptor(tableName);
        this.verifyTableDescriptor(htd, tableName, families);
        MasterFileSystem mfs = TEST_UTIL.getMiniHBaseCluster().getMaster().getMasterFileSystem();
        Path tableDir = HTableDescriptor.getTableDir((Path)mfs.getRootDir(), (byte[])tableName);
        htd = FSTableDescriptors.getTableDescriptor((FileSystem)mfs.getFileSystem(), (Path)tableDir);
        this.verifyTableDescriptor(htd, tableName, families);
    }

    private void verifyTableDescriptor(HTableDescriptor htd, byte[] tableName, byte[] ... families) {
        Set htdFamilies = htd.getFamiliesKeys();
        Assert.assertTrue((boolean)Bytes.equals((byte[])tableName, (byte[])htd.getName()));
        Assert.assertEquals((long)families.length, (long)htdFamilies.size());
        for (byte[] familyName : families) {
            Assert.assertTrue((String)("Expected family " + Bytes.toString((byte[])familyName)), (boolean)htdFamilies.contains(familyName));
        }
    }
}

