/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import junit.framework.Assert;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.MXBeanImpl;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestMXBean {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();

    @BeforeClass
    public static void setup() throws Exception {
        TEST_UTIL.startMiniCluster(1, 1);
    }

    @AfterClass
    public static void teardown() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testInfo() {
        HRegionServer rs = TEST_UTIL.getMiniHBaseCluster().getRegionServer(0);
        HMaster master = TEST_UTIL.getHBaseCluster().getMaster();
        MXBeanImpl info = MXBeanImpl.init((HRegionServer)rs);
        Assert.assertEquals((String)rs.getServerName().getServerName(), (String)info.getServerName());
        Assert.assertEquals((int)rs.getCoprocessors().length, (int)info.getCoprocessors().length);
        rs.getConfiguration().setInt("hbase.master.info.port", master.getServerName().getPort());
        Assert.assertEquals((String)rs.getZooKeeperWatcher().getQuorum(), (String)info.getZookeeperQuorum());
    }
}

