/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.HBaseTestCase;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.TimestampsFilter;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.junit.Rule;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestMinVersions
extends HBaseTestCase {
    private final byte[] T0 = Bytes.toBytes((String)"0");
    private final byte[] T1 = Bytes.toBytes((String)"1");
    private final byte[] T2 = Bytes.toBytes((String)"2");
    private final byte[] T3 = Bytes.toBytes((String)"3");
    private final byte[] T4 = Bytes.toBytes((String)"4");
    private final byte[] T5 = Bytes.toBytes((String)"5");
    private final byte[] c0 = COLUMNS[0];
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetClosestBefore() throws Exception {
        HTableDescriptor htd = this.createTableDescriptor(this.getName(), 1, 1000, 1, false);
        HRegion region = this.createNewHRegion(htd, null, null);
        try {
            long ts = EnvironmentEdgeManager.currentTimeMillis() - 2000L;
            Put p = new Put(this.T1, ts);
            p.add(this.c0, this.c0, this.T1);
            region.put(p);
            p = new Put(this.T1, ts + 1L);
            p.add(this.c0, this.c0, this.T4);
            region.put(p);
            p = new Put(this.T3, ts);
            p.add(this.c0, this.c0, this.T3);
            region.put(p);
            Result r = region.getClosestRowBefore(this.T1, this.c0);
            this.checkResult(r, this.c0, new byte[][]{this.T4});
            r = region.getClosestRowBefore(this.T2, this.c0);
            this.checkResult(r, this.c0, new byte[][]{this.T4});
            region.flushcache();
            region.compactStores(true);
            r = region.getClosestRowBefore(this.T1, this.c0);
            this.checkResult(r, this.c0, new byte[][]{this.T4});
            r = region.getClosestRowBefore(this.T2, this.c0);
            this.checkResult(r, this.c0, new byte[][]{this.T4});
        }
        finally {
            region.close();
            region.getLog().closeAndDelete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStoreMemStore() throws Exception {
        HTableDescriptor htd = this.createTableDescriptor(this.getName(), 3, 1000, 1, false);
        HRegion region = this.createNewHRegion(htd, null, null);
        long ts = EnvironmentEdgeManager.currentTimeMillis() - 2000L;
        try {
            Put p = new Put(this.T1, ts - 1L);
            p.add(this.c0, this.c0, this.T2);
            region.put(p);
            p = new Put(this.T1, ts - 3L);
            p.add(this.c0, this.c0, this.T0);
            region.put(p);
            region.flushcache();
            region.compactStores(true);
            p = new Put(this.T1, ts);
            p.add(this.c0, this.c0, this.T3);
            region.put(p);
            p = new Put(this.T1, ts - 2L);
            p.add(this.c0, this.c0, this.T1);
            region.put(p);
            p = new Put(this.T1, ts - 3L);
            p.add(this.c0, this.c0, this.T0);
            region.put(p);
            Get g = new Get(this.T1);
            g.setMaxVersions();
            Result r = region.get(g, null);
            this.checkResult(r, this.c0, this.T3, this.T2, this.T1);
            g = new Get(this.T1);
            g.setMaxVersions();
            g.addColumn(this.c0, this.c0);
            r = region.get(g, null);
            this.checkResult(r, this.c0, this.T3, this.T2, this.T1);
        }
        finally {
            region.close();
            region.getLog().closeAndDelete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDelete() throws Exception {
        HTableDescriptor htd = this.createTableDescriptor(this.getName(), 3, 1000, 1, false);
        HRegion region = this.createNewHRegion(htd, null, null);
        long ts = EnvironmentEdgeManager.currentTimeMillis() - 2000L;
        try {
            Put p = new Put(this.T1, ts - 2L);
            p.add(this.c0, this.c0, this.T1);
            region.put(p);
            p = new Put(this.T1, ts - 1L);
            p.add(this.c0, this.c0, this.T2);
            region.put(p);
            p = new Put(this.T1, ts);
            p.add(this.c0, this.c0, this.T3);
            region.put(p);
            Delete d = new Delete(this.T1, ts - 1L, null);
            region.delete(d, null, true);
            Get g = new Get(this.T1);
            g.setMaxVersions();
            Result r = region.get(g, null);
            this.checkResult(r, this.c0, new byte[][]{this.T3});
            g = new Get(this.T1);
            g.setMaxVersions();
            g.addColumn(this.c0, this.c0);
            r = region.get(g, null);
            this.checkResult(r, this.c0, new byte[][]{this.T3});
            region.flushcache();
            region.compactStores(true);
            g = new Get(this.T1);
            g.setMaxVersions();
            r = region.get(g, null);
            this.checkResult(r, this.c0, new byte[][]{this.T3});
            g = new Get(this.T1);
            g.setMaxVersions();
            g.addColumn(this.c0, this.c0);
            r = region.get(g, null);
            this.checkResult(r, this.c0, new byte[][]{this.T3});
        }
        finally {
            region.close();
            region.getLog().closeAndDelete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMemStore() throws Exception {
        HTableDescriptor htd = this.createTableDescriptor(this.getName(), 2, 1000, 1, false);
        HRegion region = this.createNewHRegion(htd, null, null);
        long ts = EnvironmentEdgeManager.currentTimeMillis() - 2000L;
        try {
            Put p = new Put(this.T1, ts - 2L);
            p.add(this.c0, this.c0, this.T2);
            region.put(p);
            p = new Put(this.T1, ts - 1L);
            p.add(this.c0, this.c0, this.T3);
            region.put(p);
            p = new Put(this.T1, ts);
            p.add(this.c0, this.c0, this.T4);
            region.put(p);
            region.flushcache();
            region.compactStores(true);
            p = new Put(this.T1, ts - 3L);
            p.add(this.c0, this.c0, this.T1);
            region.put(p);
            Result r = region.get(new Get(this.T1), null);
            this.checkResult(r, this.c0, new byte[][]{this.T4});
            Get g = new Get(this.T1);
            g.setMaxVersions();
            r = region.get(g, null);
            this.checkResult(r, this.c0, this.T4, this.T3);
            g = new Get(this.T1);
            g.setMaxVersions();
            g.addColumn(this.c0, this.c0);
            r = region.get(g, null);
            this.checkResult(r, this.c0, this.T4, this.T3);
            p = new Put(this.T1, ts + 1L);
            p.add(this.c0, this.c0, this.T5);
            region.put(p);
            g = new Get(this.T1);
            g.setMaxVersions();
            r = region.get(g, null);
            this.checkResult(r, this.c0, this.T5, this.T4);
            g = new Get(this.T1);
            g.setMaxVersions();
            g.addColumn(this.c0, this.c0);
            r = region.get(g, null);
            this.checkResult(r, this.c0, this.T5, this.T4);
        }
        finally {
            region.close();
            region.getLog().closeAndDelete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBaseCase() throws Exception {
        HTableDescriptor htd = this.createTableDescriptor(this.getName(), 2, 1000, 1, false);
        HRegion region = this.createNewHRegion(htd, null, null);
        try {
            long ts = EnvironmentEdgeManager.currentTimeMillis() - 2000L;
            Put p = new Put(this.T1, ts - 3L);
            p.add(this.c0, this.c0, this.T1);
            region.put(p);
            p = new Put(this.T1, ts - 2L);
            p.add(this.c0, this.c0, this.T2);
            region.put(p);
            p = new Put(this.T1, ts - 1L);
            p.add(this.c0, this.c0, this.T3);
            region.put(p);
            p = new Put(this.T1, ts);
            p.add(this.c0, this.c0, this.T4);
            region.put(p);
            Result r = region.get(new Get(this.T1), null);
            this.checkResult(r, this.c0, new byte[][]{this.T4});
            Get g = new Get(this.T1);
            g.setTimeRange(0L, ts + 1L);
            r = region.get(g, null);
            this.checkResult(r, this.c0, new byte[][]{this.T4});
            g.setTimeRange(0L, ts - 2L);
            r = region.get(g, null);
            this.checkResult(r, this.c0, new byte[][]{this.T1});
            g = new Get(this.T1);
            g.setMaxVersions();
            r = region.get(g, null);
            this.checkResult(r, this.c0, this.T4, this.T3);
            g = new Get(this.T1);
            g.setMaxVersions();
            g.addColumn(this.c0, this.c0);
            r = region.get(g, null);
            this.checkResult(r, this.c0, this.T4, this.T3);
            region.flushcache();
            g = new Get(this.T1);
            g.setTimeRange(0L, ts - 2L);
            r = region.get(g, null);
            TestMinVersions.assertTrue((boolean)r.isEmpty());
            region.compactStores(true);
            g = new Get(this.T1);
            g.setTimeRange(0L, ts + 1L);
            r = region.get(g, null);
            this.checkResult(r, this.c0, new byte[][]{this.T4});
            g.setTimeRange(0L, ts);
            r = region.get(g, null);
            this.checkResult(r, this.c0, new byte[][]{this.T3});
            g.setTimeRange(0L, ts - 1L);
            r = region.get(g, null);
            TestMinVersions.assertTrue((boolean)r.isEmpty());
        }
        finally {
            region.close();
            region.getLog().closeAndDelete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFilters() throws Exception {
        HTableDescriptor htd = this.createTableDescriptor(this.getName(), 2, 1000, 1, false);
        HRegion region = this.createNewHRegion(htd, null, null);
        byte[] c1 = COLUMNS[1];
        long ts = EnvironmentEdgeManager.currentTimeMillis() - 2000L;
        try {
            Put p = new Put(this.T1, ts - 3L);
            p.add(this.c0, this.c0, this.T0);
            p.add(c1, c1, this.T0);
            region.put(p);
            p = new Put(this.T1, ts - 2L);
            p.add(this.c0, this.c0, this.T1);
            p.add(c1, c1, this.T1);
            region.put(p);
            p = new Put(this.T1, ts - 1L);
            p.add(this.c0, this.c0, this.T2);
            p.add(c1, c1, this.T2);
            region.put(p);
            p = new Put(this.T1, ts);
            p.add(this.c0, this.c0, this.T3);
            p.add(c1, c1, this.T3);
            region.put(p);
            ArrayList<Long> tss = new ArrayList<Long>();
            tss.add(ts - 1L);
            tss.add(ts - 2L);
            Get g = new Get(this.T1);
            g.addColumn(c1, c1);
            g.setFilter((Filter)new TimestampsFilter(tss));
            g.setMaxVersions();
            Result r = region.get(g, null);
            this.checkResult(r, c1, this.T2, this.T1);
            g = new Get(this.T1);
            g.addColumn(this.c0, this.c0);
            g.setFilter((Filter)new TimestampsFilter(tss));
            g.setMaxVersions();
            r = region.get(g, null);
            this.checkResult(r, this.c0, this.T2, this.T1);
            region.flushcache();
            region.compactStores(true);
            g = new Get(this.T1);
            g.addColumn(c1, c1);
            g.setFilter((Filter)new TimestampsFilter(tss));
            g.setMaxVersions();
            r = region.get(g, null);
            this.checkResult(r, c1, new byte[][]{this.T2});
            g = new Get(this.T1);
            g.addColumn(this.c0, this.c0);
            g.setFilter((Filter)new TimestampsFilter(tss));
            g.setMaxVersions();
            r = region.get(g, null);
            this.checkResult(r, this.c0, new byte[][]{this.T2});
        }
        finally {
            region.close();
            region.getLog().closeAndDelete();
        }
    }

    private void checkResult(Result r, byte[] col, byte[] ... vals) {
        TestMinVersions.assertEquals((int)r.size(), (int)vals.length);
        List kvs = r.getColumn(col, col);
        TestMinVersions.assertEquals((int)kvs.size(), (int)vals.length);
        for (int i = 0; i < vals.length; ++i) {
            TestMinVersions.assertEquals(((KeyValue)kvs.get(i)).getValue(), vals[i]);
        }
    }
}

