/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HServerAddress;
import org.apache.hadoop.hbase.HServerInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MasterAddressTracker;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.metrics.RegionServerMetrics;
import org.apache.hadoop.hbase.tmpl.regionserver.RSStatusTmpl;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={SmallTests.class})
public class TestRSStatusServlet {
    private HRegionServer rs;
    static final int FAKE_IPC_PORT = 1585;
    static final int FAKE_WEB_PORT = 1586;
    private final HServerAddress fakeAddress = new HServerAddress("localhost", 1585);
    private final HServerInfo fakeInfo = new HServerInfo(this.fakeAddress, 1586);
    private final RegionServerMetrics metrics = new RegionServerMetrics();
    private final ServerName fakeMasterAddress = new ServerName("localhost", 60010, 1212121212L);
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    @Before
    public void setupBasicMocks() throws IOException {
        this.rs = (HRegionServer)Mockito.mock(HRegionServer.class);
        ((HRegionServer)Mockito.doReturn((Object)HBaseConfiguration.create()).when((Object)this.rs)).getConfiguration();
        ((HRegionServer)Mockito.doReturn((Object)this.fakeInfo).when((Object)this.rs)).getHServerInfo();
        ((HRegionServer)Mockito.doReturn((Object)this.metrics).when((Object)this.rs)).getMetrics();
        ZooKeeperWatcher zkw = (ZooKeeperWatcher)Mockito.mock(ZooKeeperWatcher.class);
        ((ZooKeeperWatcher)Mockito.doReturn((Object)"fakequorum").when((Object)zkw)).getQuorum();
        ((HRegionServer)Mockito.doReturn((Object)zkw).when((Object)this.rs)).getZooKeeper();
        MasterAddressTracker mat = (MasterAddressTracker)Mockito.mock(MasterAddressTracker.class);
        ((MasterAddressTracker)Mockito.doReturn((Object)this.fakeMasterAddress).when((Object)mat)).getMasterAddress();
        ((HRegionServer)Mockito.doReturn((Object)mat).when((Object)this.rs)).getMasterAddressManager();
    }

    @Test
    public void testBasic() throws IOException {
        new RSStatusTmpl().render((Writer)new StringWriter(), this.rs);
    }

    @Test
    public void testWithRegions() throws IOException {
        HTableDescriptor htd = new HTableDescriptor("mytable");
        ArrayList regions = Lists.newArrayList((Object[])new HRegionInfo[]{new HRegionInfo(htd.getName(), Bytes.toBytes((String)"a"), Bytes.toBytes((String)"d")), new HRegionInfo(htd.getName(), Bytes.toBytes((String)"d"), Bytes.toBytes((String)"z"))});
        ((HRegionServer)Mockito.doReturn((Object)regions).when((Object)this.rs)).getOnlineRegions();
        new RSStatusTmpl().render((Writer)new StringWriter(), this.rs);
    }
}

