/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.metrics.RegionMetricsStorage;
import org.apache.hadoop.hbase.regionserver.metrics.SchemaMetrics;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestRegionServerMetrics {
    private static final Log LOG = LogFactory.getLog((String)TestRegionServerMetrics.class.getName());
    private static final String TABLE_NAME = TestRegionServerMetrics.class.getSimpleName() + "Table";
    private String[] FAMILIES = new String[]{"cf1", "cf2", "anotherCF"};
    private static final int MAX_VERSIONS = 1;
    private static final int NUM_COLS_PER_ROW = 15;
    private static final int NUM_FLUSHES = 3;
    private static final int NUM_REGIONS = 4;
    private static final SchemaMetrics ALL_METRICS = SchemaMetrics.ALL_SCHEMA_METRICS;
    private final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private Map<String, Long> startingMetrics;
    private final int META_AND_ROOT = 2;
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    @Before
    public void setUp() throws Exception {
        SchemaMetrics.setUseTableNameInTest((boolean)true);
        this.startingMetrics = SchemaMetrics.getMetricsSnapshot();
        this.TEST_UTIL.startMiniCluster();
    }

    @After
    public void tearDown() throws Exception {
        this.TEST_UTIL.shutdownMiniCluster();
        SchemaMetrics.validateMetricChanges(this.startingMetrics);
    }

    private void assertTimeVaryingMetricCount(int expectedCount, String table, String cf, String regionName, String metricPrefix) {
        Integer expectedCountInteger = new Integer(expectedCount);
        if (cf != null) {
            String cfKey = "tbl." + table + "." + "cf." + cf + "." + metricPrefix;
            Pair cfPair = RegionMetricsStorage.getTimeVaryingMetric((String)cfKey);
            Assert.assertEquals((Object)expectedCountInteger, (Object)cfPair.getSecond());
        }
        if (regionName != null) {
            String rKey = "tbl." + table + "." + "region." + regionName + "." + metricPrefix;
            Pair regionPair = RegionMetricsStorage.getTimeVaryingMetric((String)rKey);
            Assert.assertEquals((Object)expectedCountInteger, (Object)regionPair.getSecond());
        }
    }

    private void assertStoreMetricEquals(long expected, SchemaMetrics schemaMetrics, SchemaMetrics.StoreMetricType storeMetricType) {
        String storeMetricName = schemaMetrics.getStoreMetricName(storeMetricType);
        Long startValue = this.startingMetrics.get(storeMetricName);
        Assert.assertEquals((String)("Invalid value for store metric " + storeMetricName + " (type " + storeMetricType + ")"), (long)expected, (long)(RegionMetricsStorage.getNumericMetric((String)storeMetricName) - (startValue != null ? startValue : 0L)));
    }

    @Test
    public void testOperationMetrics() throws IOException {
        String cf = "OPCF";
        String otherCf = "otherCF";
        String rk = "testRK";
        String icvCol = "icvCol";
        String appendCol = "appendCol";
        String regionName = null;
        HTable hTable = this.TEST_UTIL.createTable(TABLE_NAME.getBytes(), new byte[][]{cf.getBytes(), otherCf.getBytes()});
        Set regionInfos = hTable.getRegionLocations().keySet();
        regionName = regionInfos.toArray(new HRegionInfo[regionInfos.size()])[0].getEncodedName();
        Put pOne = new Put(rk.getBytes());
        pOne.add(cf.getBytes(), icvCol.getBytes(), Bytes.toBytes((long)0L));
        Put pTwo = new Put("ignored1RK".getBytes());
        pTwo.add(cf.getBytes(), "ignored".getBytes(), Bytes.toBytes((long)0L));
        hTable.put(Arrays.asList(pOne, pTwo));
        Put pThree = new Put("ignored2RK".getBytes());
        pThree.add(cf.getBytes(), "ignored".getBytes(), Bytes.toBytes((String)"TEST1"));
        Put pFour = new Put("ignored3RK".getBytes());
        pFour.add(otherCf.getBytes(), "ignored".getBytes(), Bytes.toBytes((long)0L));
        hTable.put(Arrays.asList(pThree, pFour));
        hTable.incrementColumnValue(rk.getBytes(), cf.getBytes(), icvCol.getBytes(), 1L);
        Increment i = new Increment(rk.getBytes());
        i.addColumn(cf.getBytes(), icvCol.getBytes(), 1L);
        hTable.increment(i);
        Get g = new Get(rk.getBytes());
        g.addColumn(cf.getBytes(), appendCol.getBytes());
        hTable.get(g);
        Append a = new Append(rk.getBytes());
        a.add(cf.getBytes(), appendCol.getBytes(), Bytes.toBytes((String)"-APPEND"));
        hTable.append(a);
        Delete dOne = new Delete(rk.getBytes());
        dOne.deleteFamily(cf.getBytes());
        hTable.delete(dOne);
        Delete dTwo = new Delete(rk.getBytes());
        hTable.delete(dTwo);
        this.assertTimeVaryingMetricCount(1, TABLE_NAME, cf, null, "multiput_");
        this.assertTimeVaryingMetricCount(2, TABLE_NAME, null, regionName, "multiput_");
        this.assertTimeVaryingMetricCount(1, TABLE_NAME, "__unknown", null, "multiput_");
        this.assertTimeVaryingMetricCount(1, TABLE_NAME, cf, regionName, "incrementColumnValue_");
        this.assertTimeVaryingMetricCount(1, TABLE_NAME, cf, regionName, "increment_");
        this.assertTimeVaryingMetricCount(1, TABLE_NAME, cf, regionName, "append_");
        this.assertTimeVaryingMetricCount(1, TABLE_NAME, cf, null, "delete_");
        this.assertTimeVaryingMetricCount(2, TABLE_NAME, null, regionName, "delete_");
        this.assertTimeVaryingMetricCount(4, TABLE_NAME, cf, regionName, "get_");
        hTable.close();
    }

    @Test
    public void testRemoveRegionMetrics() throws IOException, InterruptedException {
        String cf = "REMOVECF";
        HTable hTable = this.TEST_UTIL.createTable(TABLE_NAME.getBytes(), cf.getBytes());
        HRegionInfo[] regionInfos = hTable.getRegionLocations().keySet().toArray(new HRegionInfo[hTable.getRegionLocations().keySet().size()]);
        String regionName = regionInfos[0].getEncodedName();
        Put pOne = new Put("TEST".getBytes());
        pOne.add(cf.getBytes(), "test".getBytes(), "test".getBytes());
        hTable.put(pOne);
        Get g = new Get("TEST".getBytes());
        g.addFamily(cf.getBytes());
        hTable.get(g);
        this.assertTimeVaryingMetricCount(1, TABLE_NAME, cf, regionName, "get_");
        HBaseAdmin admin = this.TEST_UTIL.getHBaseAdmin();
        admin.disableTable(TABLE_NAME.getBytes());
        admin.deleteTable(TABLE_NAME.getBytes());
        this.assertTimeVaryingMetricCount(0, TABLE_NAME, cf, regionName, "get_");
        hTable.close();
    }

    @Test
    public void testMultipleRegions() throws IOException, InterruptedException {
        this.TEST_UTIL.createRandomTable(TABLE_NAME, Arrays.asList(this.FAMILIES), 1, 15, 3, 4, 1000);
        HRegionServer rs = this.TEST_UTIL.getMiniHBaseCluster().getRegionServer(0);
        Assert.assertEquals((long)6L, (long)rs.getOnlineRegions().size());
        rs.doMetrics();
        for (HRegion r : this.TEST_UTIL.getMiniHBaseCluster().getRegions(Bytes.toBytes((String)TABLE_NAME))) {
            for (Map.Entry storeEntry : r.getStores().entrySet()) {
                LOG.info((Object)("For region " + r.getRegionNameAsString() + ", CF " + Bytes.toStringBinary((byte[])((byte[])storeEntry.getKey())) + " found store files " + ": " + ((Store)storeEntry.getValue()).getStorefiles()));
            }
        }
        this.assertStoreMetricEquals(12 * this.FAMILIES.length + 2, ALL_METRICS, SchemaMetrics.StoreMetricType.STORE_FILE_COUNT);
        for (String cf : this.FAMILIES) {
            SchemaMetrics schemaMetrics = SchemaMetrics.getInstance((String)TABLE_NAME, (String)cf);
            this.assertStoreMetricEquals(12L, schemaMetrics, SchemaMetrics.StoreMetricType.STORE_FILE_COUNT);
        }
        String storeMetricName = ALL_METRICS.getStoreMetricNameMax(SchemaMetrics.StoreMetricType.STORE_FILE_COUNT);
        Assert.assertEquals((String)("Invalid value for store metric " + storeMetricName), (long)3L, (long)RegionMetricsStorage.getNumericMetric((String)storeMetricName));
    }

    private void assertSizeMetric(String table, String[] cfs, int[] metrics) {
        Assert.assertEquals((long)(cfs.length * 2), (long)metrics.length);
        for (int i = 0; i < cfs.length; ++i) {
            String prefix = SchemaMetrics.generateSchemaMetricsPrefix((String)table, (String)cfs[i]);
            String getMetric = prefix + "getsize";
            String nextMetric = prefix + "nextsize";
            int getSize = RegionMetricsStorage.getNumericMetrics().containsKey(getMetric) ? ((AtomicLong)RegionMetricsStorage.getNumericMetrics().get(getMetric)).intValue() : 0;
            int nextSize = RegionMetricsStorage.getNumericMetrics().containsKey(nextMetric) ? ((AtomicLong)RegionMetricsStorage.getNumericMetrics().get(nextMetric)).intValue() : 0;
            Assert.assertEquals((long)metrics[i], (long)getSize);
            Assert.assertEquals((long)metrics[cfs.length + i], (long)nextSize);
        }
    }

    @Test
    public void testGetNextSize() throws IOException, InterruptedException {
        String rowName = "row1";
        byte[] ROW = Bytes.toBytes((String)rowName);
        String tableName = "SizeMetricTest";
        byte[] TABLE = Bytes.toBytes((String)tableName);
        String cf1Name = "cf1";
        String cf2Name = "cf2";
        String[] cfs = new String[]{cf1Name, cf2Name};
        byte[] CF1 = Bytes.toBytes((String)cf1Name);
        byte[] CF2 = Bytes.toBytes((String)cf2Name);
        long ts = 1234L;
        HTable hTable = this.TEST_UTIL.createTable(TABLE, new byte[][]{CF1, CF2});
        HBaseAdmin admin = new HBaseAdmin(this.TEST_UTIL.getConfiguration());
        Put p = new Put(ROW);
        p.add(CF1, CF1, ts, CF1);
        p.add(CF2, CF2, ts, CF2);
        hTable.put(p);
        KeyValue kv1 = new KeyValue(ROW, CF1, CF1, ts, CF1);
        KeyValue kv2 = new KeyValue(ROW, CF2, CF2, ts, CF2);
        int kvLength = kv1.getLength();
        Assert.assertEquals((long)kvLength, (long)kv2.getLength());
        hTable.get(new Get(ROW).addFamily(CF1));
        this.assertSizeMetric(tableName, cfs, new int[]{kvLength, 0, 0, 0});
        hTable.get(new Get(ROW).addFamily(CF2));
        this.assertSizeMetric(tableName, cfs, new int[]{kvLength, kvLength, 0, 0});
        for (Result res : hTable.getScanner(CF2)) {
        }
        this.assertSizeMetric(tableName, cfs, new int[]{kvLength, kvLength, 0, kvLength});
        for (Result res : hTable.getScanner(CF1)) {
        }
        this.assertSizeMetric(tableName, cfs, new int[]{kvLength, kvLength, kvLength, kvLength});
        for (HRegion hr : this.TEST_UTIL.getMiniHBaseCluster().getRegions(TABLE)) {
            hr.flushcache();
            hr.compactStores();
        }
        this.assertSizeMetric(tableName, cfs, new int[]{kvLength, kvLength, kvLength, kvLength});
        hTable.close();
    }
}

