/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.List;
import java.util.NavigableMap;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.LargeTests;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.UnknownRegionException;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.catalog.CatalogTracker;
import org.apache.hadoop.hbase.catalog.MetaReader;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.executor.EventHandler;
import org.apache.hadoop.hbase.executor.RegionTransitionData;
import org.apache.hadoop.hbase.master.AssignmentManager;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.handler.SplitRegionHandler;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.SplitTransaction;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.zookeeper.ZKAssign;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestSplitTransactionOnCluster {
    private static final Log LOG = LogFactory.getLog(TestSplitTransactionOnCluster.class);
    private HBaseAdmin admin = null;
    private MiniHBaseCluster cluster = null;
    private static final int NB_SERVERS = 2;
    private static CountDownLatch latch = new CountDownLatch(1);
    private static volatile boolean secondSplit = false;
    private static volatile boolean callRollBack = false;
    private static volatile boolean firstSplitCompleted = false;
    private static final HBaseTestingUtility TESTING_UTIL = new HBaseTestingUtility();
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    @BeforeClass
    public static void before() throws Exception {
        TESTING_UTIL.getConfiguration().setInt("hbase.balancer.period", 60000);
        TESTING_UTIL.getConfiguration().setInt("hbase.master.assignment.timeoutmonitor.timeout", 4000);
        TESTING_UTIL.startMiniCluster(2);
    }

    @AfterClass
    public static void after() throws Exception {
        TESTING_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setup() throws IOException {
        TESTING_UTIL.ensureSomeNonStoppedRegionServersAvailable(2);
        this.admin = new HBaseAdmin(TESTING_UTIL.getConfiguration());
        this.cluster = TESTING_UTIL.getMiniHBaseCluster();
    }

    private HRegionInfo getAndCheckSingleTableRegion(List<HRegion> regions) {
        Assert.assertEquals((long)1L, (long)regions.size());
        return regions.get(0).getRegionInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=2000000L)
    public void testShouldFailSplitIfZNodeDoesNotExistDueToPrevRollBack() throws Exception {
        byte[] tableName = Bytes.toBytes((String)"testShouldFailSplitIfZNodeDoesNotExistDueToPrevRollBack");
        HBaseAdmin admin = new HBaseAdmin(TESTING_UTIL.getConfiguration());
        try {
            HTable t = this.createTableAndWait(tableName, Bytes.toBytes((String)"cf"));
            final List<HRegion> regions = this.cluster.getRegions(tableName);
            HRegionInfo hri = this.getAndCheckSingleTableRegion(regions);
            int regionServerIndex = this.cluster.getServerWith(regions.get(0).getRegionName());
            final HRegionServer regionServer = this.cluster.getRegionServer(regionServerIndex);
            this.insertData(tableName, admin, t);
            this.admin.setBalancerRunning(false, false);
            this.cluster.getMaster().setCatalogJanitorEnabled(false);
            new Thread(){

                @Override
                public void run() {
                    MockedSplitTransaction st = null;
                    st = new MockedSplitTransaction((HRegion)regions.get(0), Bytes.toBytes((String)"row2"));
                    try {
                        st.prepare();
                        st.execute((Server)regionServer, (RegionServerServices)regionServer);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }.start();
            for (int i = 0; !callRollBack && i < 100; ++i) {
                Thread.sleep(100L);
            }
            Assert.assertTrue((String)"Waited too long for rollback", (boolean)callRollBack);
            MockedSplitTransaction st = null;
            st = new MockedSplitTransaction(regions.get(0), Bytes.toBytes((String)"row2"));
            try {
                secondSplit = true;
                st.prepare();
                st.execute((Server)regionServer, (RegionServerServices)regionServer);
            }
            catch (IOException e) {
                LOG.debug((Object)("Rollback started :" + e.getMessage()));
                st.rollback((Server)regionServer, (RegionServerServices)regionServer);
            }
            for (int i = 0; !firstSplitCompleted && i < 100; ++i) {
                Thread.sleep(100L);
            }
            Assert.assertTrue((String)"fist split did not complete", (boolean)firstSplitCompleted);
            NavigableMap rit = this.cluster.getMaster().getAssignmentManager().getRegionsInTransition();
            for (int i = 0; rit.containsKey(hri.getTableNameAsString()) && i < 100; ++i) {
                Thread.sleep(100L);
            }
            Assert.assertFalse((String)"region still in transition", (boolean)rit.containsKey(hri.getTableNameAsString()));
            List onlineRegions = regionServer.getOnlineRegions(tableName);
            Assert.assertEquals((String)"The parent region should be splitted", (long)2L, (long)onlineRegions.size());
            List regionsOfTable = this.cluster.getMaster().getAssignmentManager().getRegionsOfTable(tableName);
            Assert.assertEquals((String)"No of regions in master", (long)2L, (long)regionsOfTable.size());
        }
        finally {
            admin.setBalancerRunning(true, false);
            secondSplit = false;
            firstSplitCompleted = false;
            callRollBack = false;
            this.cluster.getMaster().setCatalogJanitorEnabled(true);
        }
        if (admin.isTableAvailable(tableName) && admin.isTableEnabled(tableName)) {
            admin.disableTable(tableName);
            admin.deleteTable(tableName);
            admin.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testRSSplitEphemeralsDisappearButDaughtersAreOnlinedAfterShutdownHandling() throws IOException, InterruptedException, KeeperException.NodeExistsException, KeeperException {
        byte[] tableName = Bytes.toBytes((String)"ephemeral");
        HTable t = this.createTableAndWait(tableName, HConstants.CATALOG_FAMILY);
        List<HRegion> regions = this.cluster.getRegions(tableName);
        HRegionInfo hri = this.getAndCheckSingleTableRegion(regions);
        int tableRegionIndex = this.ensureTableRegionNotOnSameServerAsMeta(this.admin, hri);
        this.admin.setBalancerRunning(false, true);
        this.cluster.getMaster().setCatalogJanitorEnabled(false);
        try {
            TESTING_UTIL.loadTable(t, HConstants.CATALOG_FAMILY);
            HRegionServer server = this.cluster.getRegionServer(tableRegionIndex);
            this.printOutRegions(server, "Initial regions: ");
            int regionCount = server.getOnlineRegions().size();
            SplitRegionHandler.TEST_SKIP = true;
            this.split(hri, server, regionCount);
            List<HRegion> daughters = this.checkAndGetDaughters(tableName);
            String path = ZKAssign.getNodeName((ZooKeeperWatcher)t.getConnection().getZooKeeperWatcher(), (String)hri.getEncodedName());
            Stat stats = t.getConnection().getZooKeeperWatcher().getRecoverableZooKeeper().exists(path, false);
            LOG.info((Object)("EPHEMERAL NODE BEFORE SERVER ABORT, path=" + path + ", stats=" + stats));
            RegionTransitionData rtd = ZKAssign.getData((ZooKeeperWatcher)t.getConnection().getZooKeeperWatcher(), (String)hri.getEncodedName());
            Assert.assertTrue((rtd.getEventType().equals((Object)EventHandler.EventType.RS_ZK_REGION_SPLIT) || rtd.getEventType().equals((Object)EventHandler.EventType.RS_ZK_REGION_SPLITTING) ? 1 : 0) != 0);
            this.cluster.abortRegionServer(tableRegionIndex);
            this.waitUntilRegionServerDead();
            this.awaitDaughters(tableName, daughters.size());
            regions = this.cluster.getRegions(tableName);
            for (HRegion r : regions) {
                Assert.assertTrue((boolean)daughters.contains(r));
            }
            for (int i = 0; i < 100 && (stats = t.getConnection().getZooKeeperWatcher().getRecoverableZooKeeper().exists(path, false)) != null; ++i) {
                Thread.sleep(100L);
            }
            LOG.info((Object)("EPHEMERAL NODE AFTER SERVER ABORT, path=" + path + ", stats=" + stats));
            Assert.assertTrue((stats == null ? 1 : 0) != 0);
        }
        finally {
            SplitRegionHandler.TEST_SKIP = false;
            this.admin.setBalancerRunning(true, false);
            this.cluster.getMaster().setCatalogJanitorEnabled(true);
            t.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testExistingZnodeBlocksSplitAndWeRollback() throws IOException, InterruptedException, KeeperException.NodeExistsException, KeeperException {
        byte[] tableName = Bytes.toBytes((String)"testExistingZnodeBlocksSplitAndWeRollback");
        HTable t = this.createTableAndWait(tableName, HConstants.CATALOG_FAMILY);
        List<HRegion> regions = this.cluster.getRegions(tableName);
        HRegionInfo hri = this.getAndCheckSingleTableRegion(regions);
        int tableRegionIndex = this.ensureTableRegionNotOnSameServerAsMeta(this.admin, hri);
        this.admin.setBalancerRunning(false, true);
        this.cluster.getMaster().setCatalogJanitorEnabled(false);
        try {
            TESTING_UTIL.loadTable(t, HConstants.CATALOG_FAMILY);
            HRegionServer server = this.cluster.getRegionServer(tableRegionIndex);
            this.printOutRegions(server, "Initial regions: ");
            int regionCount = server.getOnlineRegions().size();
            ZKAssign.createNodeClosing((ZooKeeperWatcher)t.getConnection().getZooKeeperWatcher(), (HRegionInfo)hri, (ServerName)new ServerName("any.old.server", 1234, -1L));
            this.admin.split(hri.getRegionNameAsString());
            this.admin.split(hri.getRegionNameAsString());
            this.admin.split(hri.getRegionNameAsString());
            for (int i = 0; i < 10; ++i) {
                Thread.sleep(100L);
                Assert.assertEquals((long)regionCount, (long)server.getOnlineRegions().size());
            }
            ZKAssign.deleteClosingNode((ZooKeeperWatcher)t.getConnection().getZooKeeperWatcher(), (HRegionInfo)hri);
            this.split(hri, server, regionCount);
            this.checkAndGetDaughters(tableName);
        }
        finally {
            this.admin.setBalancerRunning(true, false);
            this.cluster.getMaster().setCatalogJanitorEnabled(true);
            t.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testShutdownSimpleFixup() throws IOException, InterruptedException {
        byte[] tableName = Bytes.toBytes((String)"testShutdownSimpleFixup");
        HTable t = this.createTableAndWait(tableName, HConstants.CATALOG_FAMILY);
        List<HRegion> regions = this.cluster.getRegions(tableName);
        HRegionInfo hri = this.getAndCheckSingleTableRegion(regions);
        int tableRegionIndex = this.ensureTableRegionNotOnSameServerAsMeta(this.admin, hri);
        this.admin.setBalancerRunning(false, true);
        this.cluster.getMaster().setCatalogJanitorEnabled(false);
        try {
            TESTING_UTIL.loadTable(t, HConstants.CATALOG_FAMILY);
            HRegionServer server = this.cluster.getRegionServer(tableRegionIndex);
            this.printOutRegions(server, "Initial regions: ");
            int regionCount = server.getOnlineRegions().size();
            this.split(hri, server, regionCount);
            List<HRegion> daughters = this.checkAndGetDaughters(tableName);
            this.removeDaughterFromMeta(daughters.get(0).getRegionName());
            this.cluster.abortRegionServer(tableRegionIndex);
            this.waitUntilRegionServerDead();
            this.awaitDaughters(tableName, daughters.size());
            regions = this.cluster.getRegions(tableName);
            for (HRegion r : regions) {
                Assert.assertTrue((boolean)daughters.contains(r));
            }
        }
        finally {
            this.admin.setBalancerRunning(true, false);
            this.cluster.getMaster().setCatalogJanitorEnabled(true);
            t.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testShutdownFixupWhenDaughterHasSplit() throws IOException, InterruptedException {
        byte[] tableName = Bytes.toBytes((String)"testShutdownFixupWhenDaughterHasSplit");
        HTable t = this.createTableAndWait(tableName, HConstants.CATALOG_FAMILY);
        List<HRegion> regions = this.cluster.getRegions(tableName);
        HRegionInfo hri = this.getAndCheckSingleTableRegion(regions);
        int tableRegionIndex = this.ensureTableRegionNotOnSameServerAsMeta(this.admin, hri);
        this.admin.setBalancerRunning(false, true);
        this.cluster.getMaster().setCatalogJanitorEnabled(false);
        try {
            TESTING_UTIL.loadTable(t, HConstants.CATALOG_FAMILY);
            HRegionServer server = this.cluster.getRegionServer(tableRegionIndex);
            this.printOutRegions(server, "Initial regions: ");
            int regionCount = server.getOnlineRegions().size();
            this.split(hri, server, regionCount);
            List<HRegion> daughters = this.checkAndGetDaughters(tableName);
            regionCount = server.getOnlineRegions().size();
            HRegionInfo daughter = daughters.get(0).getRegionInfo();
            this.admin.compact(daughter.getRegionName());
            daughters = this.cluster.getRegions(tableName);
            HRegion daughterRegion = null;
            for (HRegion r : daughters) {
                if (!r.getRegionInfo().equals((Object)daughter)) continue;
                daughterRegion = r;
            }
            Assert.assertTrue((daughterRegion != null ? 1 : 0) != 0);
            for (int i = 0; i < 100 && daughterRegion.hasReferences(); ++i) {
                Threads.sleep((long)100L);
            }
            Assert.assertFalse((String)"Waiting for refereces to be compacted", (boolean)daughterRegion.hasReferences());
            this.split(daughter, server, regionCount);
            daughters = this.cluster.getRegions(tableName);
            this.cluster.abortRegionServer(tableRegionIndex);
            this.waitUntilRegionServerDead();
            this.awaitDaughters(tableName, daughters.size());
            regions = this.cluster.getRegions(tableName);
            Assert.assertEquals((long)daughters.size(), (long)regions.size());
            for (HRegion r : regions) {
                Assert.assertTrue((boolean)daughters.contains(r));
            }
        }
        finally {
            this.admin.setBalancerRunning(true, false);
            this.cluster.getMaster().setCatalogJanitorEnabled(true);
            t.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testMasterRestartWhenSplittingIsPartial() throws IOException, InterruptedException, KeeperException.NodeExistsException, KeeperException {
        byte[] tableName = Bytes.toBytes((String)"testMasterRestartWhenSplittingIsPartial");
        HTable t = this.createTableAndWait(tableName, HConstants.CATALOG_FAMILY);
        List<HRegion> regions = this.cluster.getRegions(tableName);
        HRegionInfo hri = this.getAndCheckSingleTableRegion(regions);
        int tableRegionIndex = this.ensureTableRegionNotOnSameServerAsMeta(this.admin, hri);
        this.cluster.getMaster().setCatalogJanitorEnabled(false);
        this.admin.setBalancerRunning(false, true);
        try {
            TESTING_UTIL.loadTable(t, HConstants.CATALOG_FAMILY);
            HRegionServer server = this.cluster.getRegionServer(tableRegionIndex);
            this.printOutRegions(server, "Initial regions: ");
            int regionCount = server.getOnlineRegions().size();
            SplitRegionHandler.TEST_SKIP = true;
            this.split(hri, server, regionCount);
            this.checkAndGetDaughters(tableName);
            String path = ZKAssign.getNodeName((ZooKeeperWatcher)t.getConnection().getZooKeeperWatcher(), (String)hri.getEncodedName());
            Stat stats = t.getConnection().getZooKeeperWatcher().getRecoverableZooKeeper().exists(path, false);
            LOG.info((Object)("EPHEMERAL NODE BEFORE SERVER ABORT, path=" + path + ", stats=" + stats));
            RegionTransitionData rtd = ZKAssign.getData((ZooKeeperWatcher)t.getConnection().getZooKeeperWatcher(), (String)hri.getEncodedName());
            Assert.assertTrue((rtd.getEventType().equals((Object)EventHandler.EventType.RS_ZK_REGION_SPLIT) || rtd.getEventType().equals((Object)EventHandler.EventType.RS_ZK_REGION_SPLITTING) ? 1 : 0) != 0);
            MockMasterWithoutCatalogJanitor master = this.abortAndWaitForMaster();
            this.admin = new HBaseAdmin(TESTING_UTIL.getConfiguration());
            hri.setOffline(true);
            hri.setSplit(true);
            ServerName regionServerOfRegion = master.getAssignmentManager().getRegionServerOfRegion(hri);
            Assert.assertTrue((regionServerOfRegion != null ? 1 : 0) != 0);
        }
        finally {
            SplitRegionHandler.TEST_SKIP = false;
            this.admin.setBalancerRunning(true, false);
            this.cluster.getMaster().setCatalogJanitorEnabled(true);
            t.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testMasterRestartAtRegionSplitPendingCatalogJanitor() throws IOException, InterruptedException, KeeperException.NodeExistsException, KeeperException {
        byte[] tableName = Bytes.toBytes((String)"testMasterRestartAtRegionSplitPendingCatalogJanitor");
        this.admin = new HBaseAdmin(TESTING_UTIL.getConfiguration());
        HTable t = this.createTableAndWait(tableName, HConstants.CATALOG_FAMILY);
        List<HRegion> regions = this.cluster.getRegions(tableName);
        HRegionInfo hri = this.getAndCheckSingleTableRegion(regions);
        int tableRegionIndex = this.ensureTableRegionNotOnSameServerAsMeta(this.admin, hri);
        this.admin.setBalancerRunning(false, true);
        this.cluster.getMaster().setCatalogJanitorEnabled(false);
        try {
            TESTING_UTIL.loadTable(t, HConstants.CATALOG_FAMILY);
            HRegionServer server = this.cluster.getRegionServer(tableRegionIndex);
            this.printOutRegions(server, "Initial regions: ");
            int regionCount = server.getOnlineRegions().size();
            this.split(hri, server, regionCount);
            this.checkAndGetDaughters(tableName);
            String path = ZKAssign.getNodeName((ZooKeeperWatcher)t.getConnection().getZooKeeperWatcher(), (String)hri.getEncodedName());
            Stat stats = t.getConnection().getZooKeeperWatcher().getRecoverableZooKeeper().exists(path, false);
            LOG.info((Object)("EPHEMERAL NODE BEFORE SERVER ABORT, path=" + path + ", stats=" + stats));
            String node = ZKAssign.getNodeName((ZooKeeperWatcher)t.getConnection().getZooKeeperWatcher(), (String)hri.getEncodedName());
            Stat stat = new Stat();
            byte[] data = ZKUtil.getDataNoWatch((ZooKeeperWatcher)t.getConnection().getZooKeeperWatcher(), (String)node, (Stat)stat);
            for (int i = 0; data != null && i < 60; ++i) {
                Thread.sleep(1000L);
                data = ZKUtil.getDataNoWatch((ZooKeeperWatcher)t.getConnection().getZooKeeperWatcher(), (String)node, (Stat)stat);
            }
            Assert.assertNull((String)("Waited too long for ZK node to be removed: " + node), (Object)data);
            MockMasterWithoutCatalogJanitor master = this.abortAndWaitForMaster();
            this.admin = new HBaseAdmin(TESTING_UTIL.getConfiguration());
            hri.setOffline(true);
            hri.setSplit(true);
            ServerName regionServerOfRegion = master.getAssignmentManager().getRegionServerOfRegion(hri);
            Assert.assertTrue((regionServerOfRegion == null ? 1 : 0) != 0);
        }
        finally {
            SplitRegionHandler.TEST_SKIP = false;
            this.admin.setBalancerRunning(true, false);
            this.cluster.getMaster().setCatalogJanitorEnabled(true);
            t.close();
        }
    }

    @Test
    public void testSplitBeforeSettingSplittingInZK() throws Exception, InterruptedException, KeeperException {
        this.testSplitBeforeSettingSplittingInZK(true);
        this.testSplitBeforeSettingSplittingInZK(false);
    }

    private void testSplitBeforeSettingSplittingInZK(boolean nodeCreated) throws Exception {
        byte[] tableName = Bytes.toBytes((String)"testSplitBeforeSettingSplittingInZK");
        HBaseAdmin admin = new HBaseAdmin(TESTING_UTIL.getConfiguration());
        HTableDescriptor htd = new HTableDescriptor(tableName);
        htd.addFamily(new HColumnDescriptor("cf"));
        admin.createTable(htd);
        List<HRegion> regions = null;
        for (int i = 0; i < 100 && (regions = this.cluster.getRegions(tableName)).size() <= 0; ++i) {
            Thread.sleep(100L);
        }
        int regionServerIndex = this.cluster.getServerWith(regions.get(0).getRegionName());
        HRegionServer regionServer = this.cluster.getRegionServer(regionServerIndex);
        MockedSplitTransaction st = null;
        st = nodeCreated ? new MockedSplitTransaction(regions.get(0), null){

            int transitionNodeSplitting(ZooKeeperWatcher zkw, HRegionInfo parent, ServerName serverName, int version) throws KeeperException, IOException {
                throw new TransitionToSplittingFailedException();
            }
        } : new MockedSplitTransaction(regions.get(0), null){

            void createNodeSplitting(ZooKeeperWatcher zkw, HRegionInfo region, ServerName serverName) throws KeeperException, IOException {
                throw new SplittingNodeCreationFailedException();
            }
        };
        String node = ZKAssign.getNodeName((ZooKeeperWatcher)regionServer.getZooKeeper(), (String)regions.get(0).getRegionInfo().getEncodedName());
        regionServer.getZooKeeper().sync(node);
        for (int i = 0; i < 100; ++i) {
            if (ZKUtil.checkExists((ZooKeeperWatcher)regionServer.getZooKeeper(), (String)node) == -1) continue;
            Thread.sleep(100L);
        }
        try {
            st.execute((Server)regionServer, (RegionServerServices)regionServer);
        }
        catch (IOException e) {
            if (nodeCreated) {
                Assert.assertTrue((String)"Should be instance of TransitionToSplittingFailedException", (boolean)(e instanceof TransitionToSplittingFailedException));
            } else {
                Assert.assertTrue((String)"Should be instance of CreateSplittingNodeFailedException", (boolean)(e instanceof SplittingNodeCreationFailedException));
            }
            node = ZKAssign.getNodeName((ZooKeeperWatcher)regionServer.getZooKeeper(), (String)regions.get(0).getRegionInfo().getEncodedName());
            regionServer.getZooKeeper().sync(node);
            if (nodeCreated) {
                Assert.assertFalse((ZKUtil.checkExists((ZooKeeperWatcher)regionServer.getZooKeeper(), (String)node) == -1 ? 1 : 0) != 0);
            } else {
                Assert.assertTrue((ZKUtil.checkExists((ZooKeeperWatcher)regionServer.getZooKeeper(), (String)node) == -1 ? 1 : 0) != 0);
            }
            Assert.assertTrue((boolean)st.rollback((Server)regionServer, (RegionServerServices)regionServer));
            Assert.assertTrue((ZKUtil.checkExists((ZooKeeperWatcher)regionServer.getZooKeeper(), (String)node) == -1 ? 1 : 0) != 0);
        }
        if (admin.isTableAvailable(tableName) && admin.isTableEnabled(tableName)) {
            admin.disableTable(tableName);
            admin.deleteTable(tableName);
        }
    }

    @Test
    public void testShouldClearRITWhenNodeFoundInSplittingState() throws Exception {
        byte[] tableName = Bytes.toBytes((String)"testShouldClearRITWhenNodeFoundInSplittingState");
        HBaseAdmin admin = new HBaseAdmin(TESTING_UTIL.getConfiguration());
        HTableDescriptor htd = new HTableDescriptor(tableName);
        htd.addFamily(new HColumnDescriptor("cf"));
        admin.createTable(htd);
        for (int i = 0; this.cluster.getRegions(tableName).size() == 0 && i < 100; ++i) {
            Thread.sleep(100L);
        }
        Assert.assertTrue((String)"Table not online", (this.cluster.getRegions(tableName).size() != 0 ? 1 : 0) != 0);
        HRegion region = this.cluster.getRegions(tableName).get(0);
        int regionServerIndex = this.cluster.getServerWith(region.getRegionName());
        HRegionServer regionServer = this.cluster.getRegionServer(regionServerIndex);
        MockedSplitTransaction st = null;
        st = new MockedSplitTransaction(region, null){

            void createSplitDir(FileSystem fs, Path splitdir) throws IOException {
                throw new IOException("");
            }
        };
        try {
            st.execute((Server)regionServer, (RegionServerServices)regionServer);
        }
        catch (IOException e) {
            String node = ZKAssign.getNodeName((ZooKeeperWatcher)regionServer.getZooKeeper(), (String)region.getRegionInfo().getEncodedName());
            Assert.assertFalse((ZKUtil.checkExists((ZooKeeperWatcher)regionServer.getZooKeeper(), (String)node) == -1 ? 1 : 0) != 0);
            AssignmentManager am = this.cluster.getMaster().getAssignmentManager();
            for (int i = 0; !am.getRegionsInTransition().containsKey(region.getRegionInfo().getEncodedName()) && i < 100; ++i) {
                Thread.sleep(200L);
            }
            Assert.assertTrue((String)("region is not in transition " + region), (boolean)am.getRegionsInTransition().containsKey(region.getRegionInfo().getEncodedName()));
            AssignmentManager.RegionState regionState = (AssignmentManager.RegionState)am.getRegionsInTransition().get(region.getRegionInfo().getEncodedName());
            Assert.assertTrue((regionState.getState() == AssignmentManager.RegionState.State.SPLITTING ? 1 : 0) != 0);
            Assert.assertTrue((boolean)st.rollback((Server)regionServer, (RegionServerServices)regionServer));
            Assert.assertTrue((ZKUtil.checkExists((ZooKeeperWatcher)regionServer.getZooKeeper(), (String)node) == -1 ? 1 : 0) != 0);
            for (int i = 0; am.getRegionsInTransition().containsKey(region.getRegionInfo().getEncodedName()) && i < 100; ++i) {
                Thread.sleep(200L);
            }
            Assert.assertFalse((String)"region is still in transition", (boolean)am.getRegionsInTransition().containsKey(region.getRegionInfo().getEncodedName()));
        }
        if (admin.isTableAvailable(tableName) && admin.isTableEnabled(tableName)) {
            admin.disableTable(tableName);
            admin.deleteTable(tableName);
            admin.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=20000L)
    public void testTableExistsIfTheSpecifiedTableRegionIsSplitParent() throws Exception {
        byte[] tableName = Bytes.toBytes((String)"testTableExistsIfTheSpecifiedTableRegionIsSplitParent");
        HRegionServer regionServer = null;
        List<HRegion> regions = null;
        HBaseAdmin admin = new HBaseAdmin(TESTING_UTIL.getConfiguration());
        try {
            HTable t = this.createTableAndWait(tableName, Bytes.toBytes((String)"cf"));
            regions = this.cluster.getRegions(tableName);
            int regionServerIndex = this.cluster.getServerWith(regions.get(0).getRegionName());
            regionServer = this.cluster.getRegionServer(regionServerIndex);
            this.insertData(tableName, admin, t);
            this.cluster.getMaster().setCatalogJanitorEnabled(false);
            boolean tableExists = MetaReader.tableExists((CatalogTracker)regionServer.getCatalogTracker(), (String)Bytes.toString((byte[])tableName));
            Assert.assertEquals((String)"The specified table should present.", (Object)true, (Object)tableExists);
            SplitTransaction st = new SplitTransaction(regions.get(0), Bytes.toBytes((String)"row2"));
            try {
                st.prepare();
                st.createDaughters((Server)regionServer, (RegionServerServices)regionServer);
            }
            catch (IOException e) {
                // empty catch block
            }
            tableExists = MetaReader.tableExists((CatalogTracker)regionServer.getCatalogTracker(), (String)Bytes.toString((byte[])tableName));
            Assert.assertEquals((String)"The specified table should present.", (Object)true, (Object)tableExists);
        }
        finally {
            this.cluster.getMaster().setCatalogJanitorEnabled(true);
            admin.close();
        }
    }

    private void insertData(byte[] tableName, HBaseAdmin admin, HTable t) throws IOException, InterruptedException {
        Put p = new Put(Bytes.toBytes((String)"row1"));
        p.add(Bytes.toBytes((String)"cf"), Bytes.toBytes((String)"q1"), Bytes.toBytes((String)"1"));
        t.put(p);
        p = new Put(Bytes.toBytes((String)"row2"));
        p.add(Bytes.toBytes((String)"cf"), Bytes.toBytes((String)"q1"), Bytes.toBytes((String)"2"));
        t.put(p);
        p = new Put(Bytes.toBytes((String)"row3"));
        p.add(Bytes.toBytes((String)"cf"), Bytes.toBytes((String)"q1"), Bytes.toBytes((String)"3"));
        t.put(p);
        p = new Put(Bytes.toBytes((String)"row4"));
        p.add(Bytes.toBytes((String)"cf"), Bytes.toBytes((String)"q1"), Bytes.toBytes((String)"4"));
        t.put(p);
        admin.flush(tableName);
    }

    private List<HRegion> checkAndGetDaughters(byte[] tableName) throws InterruptedException {
        List<HRegion> daughters = null;
        for (int i = 0; i < 100 && (daughters = this.cluster.getRegions(tableName)).size() < 2; ++i) {
            Thread.sleep(100L);
        }
        Assert.assertTrue((daughters.size() >= 2 ? 1 : 0) != 0);
        return daughters;
    }

    private MockMasterWithoutCatalogJanitor abortAndWaitForMaster() throws IOException, InterruptedException {
        this.cluster.abortMaster(0);
        this.cluster.waitOnMaster(0);
        this.cluster.getConfiguration().setClass("hbase.master.impl", MockMasterWithoutCatalogJanitor.class, HMaster.class);
        MockMasterWithoutCatalogJanitor master = null;
        master = (MockMasterWithoutCatalogJanitor)this.cluster.startMaster().getMaster();
        this.cluster.waitForActiveAndReadyMaster();
        return master;
    }

    private void split(HRegionInfo hri, HRegionServer server, int regionCount) throws IOException, InterruptedException {
        this.admin.split(hri.getRegionNameAsString());
        for (int i = 0; server.getOnlineRegions().size() <= regionCount && i < 100; ++i) {
            LOG.debug((Object)"Waiting on region to split");
            Thread.sleep(100L);
        }
        Assert.assertFalse((String)"Waited too long for split", (server.getOnlineRegions().size() <= regionCount ? 1 : 0) != 0);
    }

    private void removeDaughterFromMeta(byte[] regionName) throws IOException {
        HTable metaTable = new HTable(TESTING_UTIL.getConfiguration(), HConstants.META_TABLE_NAME);
        Delete d = new Delete(regionName);
        LOG.info((Object)("Deleted " + Bytes.toString((byte[])regionName)));
        metaTable.delete(d);
    }

    private int ensureTableRegionNotOnSameServerAsMeta(HBaseAdmin admin, HRegionInfo hri) throws UnknownRegionException, MasterNotRunningException, ZooKeeperConnectionException, InterruptedException {
        MiniHBaseCluster cluster = TESTING_UTIL.getMiniHBaseCluster();
        int metaServerIndex = cluster.getServerWithMeta();
        Assert.assertTrue((metaServerIndex != -1 ? 1 : 0) != 0);
        HRegionServer metaRegionServer = cluster.getRegionServer(metaServerIndex);
        int tableRegionIndex = cluster.getServerWith(hri.getRegionName());
        Assert.assertTrue((tableRegionIndex != -1 ? 1 : 0) != 0);
        HRegionServer tableRegionServer = cluster.getRegionServer(tableRegionIndex);
        if (metaRegionServer.getServerName().equals((Object)tableRegionServer.getServerName())) {
            HRegionServer hrs = this.getOtherRegionServer(cluster, metaRegionServer);
            Assert.assertNotNull((Object)hrs);
            Assert.assertNotNull((Object)hri);
            LOG.info((Object)("Moving " + hri.getRegionNameAsString() + " to " + hrs.getServerName() + "; metaServerIndex=" + metaServerIndex));
            for (int i = 0; cluster.getMaster().getAssignmentManager().getRegionServerOfRegion(hri) == null && i < 100; ++i) {
                Thread.sleep(10L);
            }
            admin.move(hri.getEncodedNameAsBytes(), Bytes.toBytes((String)hrs.getServerName().toString()));
        }
        for (int i = 0; i < 100 && ((tableRegionIndex = cluster.getServerWith(hri.getRegionName())) == -1 || tableRegionIndex == metaServerIndex); ++i) {
            LOG.debug((Object)("Waiting on region move off the .META. server; current index " + tableRegionIndex + " and metaServerIndex=" + metaServerIndex));
            Thread.sleep(100L);
        }
        Assert.assertTrue((String)"Region not moved off .META. server", (tableRegionIndex != -1 && tableRegionIndex != metaServerIndex ? 1 : 0) != 0);
        tableRegionIndex = cluster.getServerWith(hri.getRegionName());
        Assert.assertTrue((tableRegionIndex != -1 ? 1 : 0) != 0);
        Assert.assertNotSame((Object)metaServerIndex, (Object)tableRegionIndex);
        return tableRegionIndex;
    }

    private HRegionServer getOtherRegionServer(MiniHBaseCluster cluster, HRegionServer notThisOne) {
        for (JVMClusterUtil.RegionServerThread rst : cluster.getRegionServerThreads()) {
            HRegionServer hrs = rst.getRegionServer();
            if (hrs.getServerName().equals((Object)notThisOne.getServerName()) || hrs.isStopping() || hrs.isStopped()) continue;
            return hrs;
        }
        return null;
    }

    private void printOutRegions(HRegionServer hrs, String prefix) throws IOException {
        List regions = hrs.getOnlineRegions();
        for (HRegionInfo region : regions) {
            LOG.info((Object)(prefix + region.getRegionNameAsString()));
        }
    }

    private void waitUntilRegionServerDead() throws InterruptedException {
        for (int i = 0; this.cluster.getMaster().getClusterStatus().getServers().size() == 2 && i < 100; ++i) {
            LOG.info((Object)"Waiting on server to go down");
            Thread.sleep(100L);
        }
        Assert.assertFalse((String)"Waited too long for RS to die", (this.cluster.getMaster().getClusterStatus().getServers().size() == 2 ? 1 : 0) != 0);
    }

    private void awaitDaughters(byte[] tableName, int numDaughters) throws InterruptedException {
        for (int i = 0; this.cluster.getRegions(tableName).size() < numDaughters && i < 60; ++i) {
            LOG.info((Object)"Waiting for repair to happen");
            Thread.sleep(1000L);
        }
        if (this.cluster.getRegions(tableName).size() < numDaughters) {
            Assert.fail((String)"Waiting too long for daughter regions");
        }
    }

    private HTable createTableAndWait(byte[] tableName, byte[] cf) throws IOException, InterruptedException {
        HTable t = TESTING_UTIL.createTable(tableName, cf);
        for (int i = 0; this.cluster.getRegions(tableName).size() == 0 && i < 100; ++i) {
            Thread.sleep(100L);
        }
        Assert.assertTrue((String)("Table not online: " + Bytes.toString((byte[])tableName)), (this.cluster.getRegions(tableName).size() != 0 ? 1 : 0) != 0);
        return t;
    }

    private static class SplittingNodeCreationFailedException
    extends IOException {
    }

    private static class TransitionToSplittingFailedException
    extends IOException {
    }

    public static class MockMasterWithoutCatalogJanitor
    extends HMaster {
        public MockMasterWithoutCatalogJanitor(Configuration conf) throws IOException, KeeperException, InterruptedException {
            super(conf);
        }

        protected void startCatalogJanitorChore() {
            LOG.debug((Object)"Customised master executed.");
        }
    }

    public static class MockedSplitTransaction
    extends SplitTransaction {
        private HRegion currentRegion;

        public MockedSplitTransaction(HRegion r, byte[] splitrow) {
            super(r, splitrow);
            this.currentRegion = r;
        }

        void transitionZKNode(Server server, RegionServerServices services, HRegion a, HRegion b) throws IOException {
            if (this.currentRegion.getRegionInfo().getTableNameAsString().equals("testShouldFailSplitIfZNodeDoesNotExistDueToPrevRollBack")) {
                try {
                    if (!secondSplit) {
                        callRollBack = true;
                        latch.await();
                    }
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            super.transitionZKNode(server, services, a, b);
            if (this.currentRegion.getRegionInfo().getTableNameAsString().equals("testShouldFailSplitIfZNodeDoesNotExistDueToPrevRollBack")) {
                firstSplitCompleted = true;
            }
        }

        public boolean rollback(Server server, RegionServerServices services) throws IOException {
            if (this.currentRegion.getRegionInfo().getTableNameAsString().equals("testShouldFailSplitIfZNodeDoesNotExistDueToPrevRollBack") && secondSplit) {
                super.rollback(server, services);
                latch.countDown();
                return true;
            }
            return super.rollback(server, services);
        }
    }
}

