/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.handler;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.executor.EventHandler;
import org.apache.hadoop.hbase.executor.RegionTransitionData;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.RegionAlreadyInTransitionException;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.handler.OpenRegionHandler;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.MockRegionServerServices;
import org.apache.hadoop.hbase.util.MockServer;
import org.apache.hadoop.hbase.zookeeper.ZKAssign;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestOpenRegionHandler {
    static final Log LOG = LogFactory.getLog(TestOpenRegionHandler.class);
    private static final HBaseTestingUtility HTU = new HBaseTestingUtility();
    private static HTableDescriptor TEST_HTD;
    private HRegionInfo TEST_HRI;
    private int testIndex = 0;
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    @BeforeClass
    public static void before() throws Exception {
        Configuration c = HTU.getConfiguration();
        c.setClass("hbase.regionserver.impl", TestOpenRegionHandlerRegionServer.class, HRegionServer.class);
        HTU.startMiniCluster();
        TEST_HTD = new HTableDescriptor("TestOpenRegionHandler.java");
    }

    @AfterClass
    public static void after() throws IOException {
        TEST_HTD = null;
        try {
            HTU.shutdownMiniCluster();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Before
    public void setupHRI() {
        this.TEST_HRI = new HRegionInfo(TEST_HTD.getName(), Bytes.toBytes((int)this.testIndex), Bytes.toBytes((int)(this.testIndex + 1)));
        ++this.testIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testYankingRegionFromUnderIt() throws IOException, KeeperException.NodeExistsException, KeeperException {
        MockServer server = new MockServer(HTU);
        MockRegionServerServices rss = new MockRegionServerServices();
        HTableDescriptor htd = TEST_HTD;
        final HRegionInfo hri = this.TEST_HRI;
        HRegion region = HRegion.createHRegion((HRegionInfo)hri, (Path)HTU.getDataTestDir(), (Configuration)HTU.getConfiguration(), (HTableDescriptor)htd);
        Assert.assertNotNull((Object)region);
        try {
            OpenRegionHandler handler = new OpenRegionHandler(server, rss, hri, htd){

                HRegion openRegion() {
                    HRegion region = super.openRegion();
                    ZooKeeperWatcher zkw = this.server.getZooKeeper();
                    String node = ZKAssign.getNodeName((ZooKeeperWatcher)zkw, (String)hri.getEncodedName());
                    try {
                        ZKUtil.deleteNodeFailSilent((ZooKeeperWatcher)zkw, (String)node);
                    }
                    catch (KeeperException e) {
                        throw new RuntimeException("Ugh failed delete of " + node, e);
                    }
                    return region;
                }
            };
            handler.process();
            ZKAssign.createNodeOffline((ZooKeeperWatcher)server.getZooKeeper(), (HRegionInfo)hri, (ServerName)server.getServerName());
            handler.process();
        }
        finally {
            HRegion.closeHRegion((HRegion)region);
        }
    }

    @Test
    public void testFailedOpenRegion() throws Exception {
        MockServer server = new MockServer(HTU);
        MockRegionServerServices rsServices = new MockRegionServerServices();
        ZKAssign.createNodeOffline((ZooKeeperWatcher)server.getZooKeeper(), (HRegionInfo)this.TEST_HRI, (ServerName)server.getServerName());
        ZKAssign.transitionNodeOpening((ZooKeeperWatcher)server.getZooKeeper(), (HRegionInfo)this.TEST_HRI, (ServerName)server.getServerName());
        OpenRegionHandler handler = new OpenRegionHandler(server, rsServices, this.TEST_HRI, TEST_HTD){

            HRegion openRegion() {
                return null;
            }
        };
        handler.process();
        RegionTransitionData data = ZKAssign.getData((ZooKeeperWatcher)server.getZooKeeper(), (String)this.TEST_HRI.getEncodedName());
        Assert.assertEquals((Object)EventHandler.EventType.RS_ZK_REGION_FAILED_OPEN, (Object)data.getEventType());
    }

    @Test
    public void testFailedUpdateMeta() throws Exception {
        MockServer server = new MockServer(HTU);
        MockRegionServerServices rsServices = new MockRegionServerServices();
        ZKAssign.createNodeOffline((ZooKeeperWatcher)server.getZooKeeper(), (HRegionInfo)this.TEST_HRI, (ServerName)server.getServerName());
        ZKAssign.transitionNodeOpening((ZooKeeperWatcher)server.getZooKeeper(), (HRegionInfo)this.TEST_HRI, (ServerName)server.getServerName());
        OpenRegionHandler handler = new OpenRegionHandler(server, rsServices, this.TEST_HRI, TEST_HTD){

            boolean updateMeta(HRegion r) {
                return false;
            }
        };
        handler.process();
        RegionTransitionData data = ZKAssign.getData((ZooKeeperWatcher)server.getZooKeeper(), (String)this.TEST_HRI.getEncodedName());
        Assert.assertEquals((Object)EventHandler.EventType.RS_ZK_REGION_FAILED_OPEN, (Object)data.getEventType());
    }

    @Test
    public void testTransitionToFailedOpenEvenIfCleanupFails() throws Exception {
        MiniHBaseCluster cluster = HTU.getHBaseCluster();
        HRegionServer server = cluster.getLiveRegionServerThreads().get(0).getRegionServer();
        ZKAssign.createNodeOffline((ZooKeeperWatcher)server.getZooKeeper(), (HRegionInfo)this.TEST_HRI, (ServerName)server.getServerName());
        ZKAssign.transitionNodeOpening((ZooKeeperWatcher)server.getZooKeeper(), (HRegionInfo)this.TEST_HRI, (ServerName)server.getServerName());
        OpenRegionHandler handler = new OpenRegionHandler((Server)server, (RegionServerServices)server, this.TEST_HRI, TEST_HTD){

            boolean updateMeta(HRegion r) {
                return false;
            }

            void cleanupFailedOpen(HRegion region) throws IOException {
                throw new IOException("FileSystem got closed.");
            }
        };
        ((TestOpenRegionHandlerRegionServer)server).addRegionsInTransition(this.TEST_HRI, "OPEN");
        try {
            handler.process();
        }
        catch (Exception e) {
            // empty catch block
        }
        RegionTransitionData data = ZKAssign.getData((ZooKeeperWatcher)server.getZooKeeper(), (String)this.TEST_HRI.getEncodedName());
        Assert.assertEquals((Object)EventHandler.EventType.RS_ZK_REGION_FAILED_OPEN, (Object)data.getEventType());
    }

    public static class TestOpenRegionHandlerRegionServer
    extends HRegionServer {
        public TestOpenRegionHandlerRegionServer(Configuration conf) throws IOException, InterruptedException {
            super(conf);
        }

        public void addRegionsInTransition(HRegionInfo region, String currentAction) throws RegionAlreadyInTransitionException {
            super.addRegionsInTransition(region, currentAction);
        }
    }
}

