/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.regionserver.wal.HLogKey;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public final class HLogPerformanceEvaluation
extends Configured
implements Tool {
    static final Log LOG = LogFactory.getLog((String)HLogPerformanceEvaluation.class.getName());
    private final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    static final String TABLE_NAME = "HLogPerformanceEvaluation";
    static final String QUALIFIER_PREFIX = "q";
    static final String FAMILY_PREFIX = "cf";
    private int numQualifiers = 1;
    private int valueSize = 512;
    private int keySize = 16;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run(String[] args) throws Exception {
        Path rootRegionDir = null;
        int numThreads = 1;
        long numIterations = 10000L;
        int numFamilies = 1;
        boolean noSync = false;
        boolean verify = false;
        boolean verbose = false;
        long roll = Long.MAX_VALUE;
        for (int i = 0; i < args.length; ++i) {
            String cmd = args[i];
            try {
                if (cmd.equals("-threads")) {
                    numThreads = Integer.parseInt(args[++i]);
                    continue;
                }
                if (cmd.equals("-iterations")) {
                    numIterations = Long.parseLong(args[++i]);
                    continue;
                }
                if (cmd.equals("-path")) {
                    rootRegionDir = new Path(args[++i]);
                    continue;
                }
                if (cmd.equals("-families")) {
                    numFamilies = Integer.parseInt(args[++i]);
                    continue;
                }
                if (cmd.equals("-qualifiers")) {
                    this.numQualifiers = Integer.parseInt(args[++i]);
                    continue;
                }
                if (cmd.equals("-keySize")) {
                    this.keySize = Integer.parseInt(args[++i]);
                    continue;
                }
                if (cmd.equals("-valueSize")) {
                    this.valueSize = Integer.parseInt(args[++i]);
                    continue;
                }
                if (cmd.equals("-nosync")) {
                    noSync = true;
                    continue;
                }
                if (cmd.equals("-verify")) {
                    verify = true;
                    continue;
                }
                if (cmd.equals("-verbose")) {
                    verbose = true;
                    continue;
                }
                if (cmd.equals("-roll")) {
                    roll = Long.parseLong(args[++i]);
                    continue;
                }
                if (cmd.equals("-h")) {
                    this.printUsageAndExit();
                    continue;
                }
                if (cmd.equals("--help")) {
                    this.printUsageAndExit();
                    continue;
                }
                System.err.println("UNEXPECTED: " + cmd);
                this.printUsageAndExit();
                continue;
            }
            catch (Exception e) {
                this.printUsageAndExit();
            }
        }
        FileSystem fs = FileSystem.get((Configuration)this.getConf());
        LOG.info((Object)("" + fs));
        try {
            if (rootRegionDir == null) {
                rootRegionDir = this.TEST_UTIL.getDataTestDir(TABLE_NAME);
            }
            rootRegionDir = rootRegionDir.makeQualified(fs);
            this.cleanRegionRootDir(fs, rootRegionDir);
            HTableDescriptor htd = HLogPerformanceEvaluation.createHTableDescriptor(numFamilies);
            final long whenToRoll = roll;
            HLog hlog = new HLog(fs, new Path(rootRegionDir, "wals"), new Path(rootRegionDir, "old.wals"), this.getConf()){
                int appends;
                {
                    super(x0, x1, x2, x3);
                    this.appends = 0;
                }

                protected void doWrite(HRegionInfo info, HLogKey logKey, WALEdit logEdit, HTableDescriptor htd) throws IOException {
                    ++this.appends;
                    if ((long)this.appends % whenToRoll == 0L) {
                        LOG.info((Object)("Rolling after " + this.appends + " edits"));
                        this.rollWriter();
                    }
                    super.doWrite(info, logKey, logEdit, htd);
                }
            };
            hlog.rollWriter();
            HRegion region = null;
            try {
                region = this.openRegion(fs, rootRegionDir, htd, hlog);
                long putTime = this.runBenchmark(new HLogPutBenchmark(region, htd, numIterations, noSync), numThreads);
                HLogPerformanceEvaluation.logBenchmarkResult("Summary: threads=" + numThreads + ", iterations=" + numIterations, numIterations * (long)numThreads, putTime);
                if (region != null) {
                    this.closeRegion(region);
                    region = null;
                }
                if (verify) {
                    Path dir = hlog.getDir();
                    long editCount = 0L;
                    for (FileStatus fss : fs.listStatus(dir)) {
                        editCount += this.verify(fss.getPath(), verbose);
                    }
                    long expected = numIterations * (long)numThreads;
                    if (editCount != expected) {
                        throw new IllegalStateException("Counted=" + editCount + ", expected=" + expected);
                    }
                }
            }
            finally {
                if (region != null) {
                    this.closeRegion(region);
                }
                this.cleanRegionRootDir(fs, rootRegionDir);
            }
        }
        finally {
            fs.close();
        }
        return 0;
    }

    private static HTableDescriptor createHTableDescriptor(int numFamilies) {
        HTableDescriptor htd = new HTableDescriptor(TABLE_NAME);
        for (int i = 0; i < numFamilies; ++i) {
            HColumnDescriptor colDef = new HColumnDescriptor(FAMILY_PREFIX + i);
            htd.addFamily(colDef);
        }
        return htd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long verify(Path wal, boolean verbose) throws IOException {
        HLog.Reader reader = HLog.getReader((FileSystem)wal.getFileSystem(this.getConf()), (Path)wal, (Configuration)this.getConf());
        long previousSeqid = -1L;
        long count = 0L;
        try {
            HLog.Entry e;
            while ((e = reader.next()) != null) {
                ++count;
                long seqid = e.getKey().getLogSeqNum();
                if (verbose) {
                    LOG.info((Object)("seqid=" + seqid));
                }
                if (previousSeqid >= seqid) {
                    throw new IllegalStateException("wal=" + wal.getName() + ", previousSeqid=" + previousSeqid + ", seqid=" + seqid);
                }
                previousSeqid = seqid;
            }
        }
        finally {
            reader.close();
        }
        return count;
    }

    private static void logBenchmarkResult(String testName, long numTests, long totalTime) {
        float tsec = (float)totalTime / 1000.0f;
        LOG.info((Object)String.format("%s took %.3fs %.3fops/s", testName, Float.valueOf(tsec), Float.valueOf((float)numTests / tsec)));
    }

    private void printUsageAndExit() {
        System.err.printf("Usage: bin/hbase %s [options]\n", ((Object)((Object)this)).getClass().getName());
        System.err.println(" where [options] are:");
        System.err.println("  -h|-help         Show this help and exit.");
        System.err.println("  -threads <N>     Number of threads writing on the WAL.");
        System.err.println("  -iterations <N>  Number of iterations per thread.");
        System.err.println("  -path <PATH>     Path where region's root directory is created.");
        System.err.println("  -families <N>    Number of column families to write.");
        System.err.println("  -qualifiers <N>  Number of qualifiers to write.");
        System.err.println("  -keySize <N>     Row key size in byte.");
        System.err.println("  -valueSize <N>   Row/Col value size in byte.");
        System.err.println("  -nosync          Append without syncing");
        System.err.println("  -verify          Verify edits written in sequence");
        System.err.println("  -verbose         Output extra info; e.g. all edit seq ids when verifying");
        System.err.println("  -roll <N>        Roll the way every N appends");
        System.err.println("");
        System.err.println("Examples:");
        System.err.println("");
        System.err.println(" To run 100 threads on hdfs with log rolling every 10k edits and verification afterward do:");
        System.err.println(" $ ./bin/hbase org.apache.hadoop.hbase.regionserver.wal.HLogPerformanceEvaluation \\");
        System.err.println("    -conf ./core-site.xml -path hdfs://example.org:7000/tmp -threads 100 -roll 10000 -verify");
        System.exit(1);
    }

    private HRegion openRegion(FileSystem fs, Path dir, HTableDescriptor htd, HLog hlog) throws IOException {
        HRegionInfo regionInfo = new HRegionInfo(htd.getName());
        return HRegion.createHRegion((HRegionInfo)regionInfo, (Path)dir, (Configuration)this.getConf(), (HTableDescriptor)htd, (HLog)hlog);
    }

    private void closeRegion(HRegion region) throws IOException {
        if (region != null) {
            region.close();
            HLog wal = region.getLog();
            if (wal != null) {
                wal.close();
            }
        }
    }

    private void cleanRegionRootDir(FileSystem fs, Path dir) throws IOException {
        if (fs.exists(dir)) {
            fs.delete(dir, true);
        }
    }

    private Put setupPut(Random rand, byte[] key, byte[] value, int numFamilies) {
        rand.nextBytes(key);
        Put put = new Put(key);
        for (int cf = 0; cf < numFamilies; ++cf) {
            for (int q = 0; q < this.numQualifiers; ++q) {
                rand.nextBytes(value);
                put.add(Bytes.toBytes((String)(FAMILY_PREFIX + cf)), Bytes.toBytes((String)(QUALIFIER_PREFIX + q)), value);
            }
        }
        return put;
    }

    private void addFamilyMapToWALEdit(Map<byte[], List<KeyValue>> familyMap, WALEdit walEdit) {
        for (List<KeyValue> edits : familyMap.values()) {
            for (KeyValue kv : edits) {
                walEdit.add(kv);
            }
        }
    }

    private long runBenchmark(Runnable runnable, int numThreads) throws InterruptedException {
        Thread[] threads = new Thread[numThreads];
        long startTime = System.currentTimeMillis();
        for (int i = 0; i < numThreads; ++i) {
            threads[i] = new Thread(runnable);
            threads[i].start();
        }
        for (Thread t : threads) {
            t.join();
        }
        long endTime = System.currentTimeMillis();
        return endTime - startTime;
    }

    static int innerMain(String[] args) throws Exception {
        return ToolRunner.run((Configuration)HBaseConfiguration.create(), (Tool)new HLogPerformanceEvaluation(), (String[])args);
    }

    public static void main(String[] args) throws Exception {
        System.exit(HLogPerformanceEvaluation.innerMain(args));
    }

    class HLogPutBenchmark
    implements Runnable {
        private final long numIterations;
        private final int numFamilies;
        private final boolean noSync;
        private final HRegion region;
        private final HTableDescriptor htd;

        HLogPutBenchmark(HRegion region, HTableDescriptor htd, long numIterations, boolean noSync) {
            this.numIterations = numIterations;
            this.noSync = noSync;
            this.numFamilies = htd.getColumnFamilies().length;
            this.region = region;
            this.htd = htd;
        }

        @Override
        public void run() {
            byte[] key = new byte[HLogPerformanceEvaluation.this.keySize];
            byte[] value = new byte[HLogPerformanceEvaluation.this.valueSize];
            Random rand = new Random(Thread.currentThread().getId());
            HLog hlog = this.region.getLog();
            try {
                long startTime = System.currentTimeMillis();
                int i = 0;
                while ((long)i < this.numIterations) {
                    Put put = HLogPerformanceEvaluation.this.setupPut(rand, key, value, this.numFamilies);
                    long now = System.currentTimeMillis();
                    WALEdit walEdit = new WALEdit();
                    HLogPerformanceEvaluation.this.addFamilyMapToWALEdit(put.getFamilyMap(), walEdit);
                    HRegionInfo hri = this.region.getRegionInfo();
                    if (this.noSync) {
                        hlog.appendNoSync(hri, hri.getTableName(), walEdit, HConstants.DEFAULT_CLUSTER_ID, now, this.htd);
                    } else {
                        hlog.append(hri, hri.getTableName(), walEdit, now, this.htd);
                    }
                    ++i;
                }
                long totalTime = System.currentTimeMillis() - startTime;
                HLogPerformanceEvaluation.logBenchmarkResult(Thread.currentThread().getName(), this.numIterations, totalTime);
            }
            catch (Exception e) {
                LOG.error((Object)(this.getClass().getSimpleName() + " Thread failed"), (Throwable)e);
            }
        }
    }
}

