/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.regionserver.wal.CompressionContext;
import org.apache.hadoop.hbase.regionserver.wal.KeyValueCompression;
import org.apache.hadoop.hbase.regionserver.wal.LRUDictionary;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.DataOutputBuffer;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestKeyValueCompression {
    private static final byte[] VALUE = Bytes.toBytes((String)"fake value");
    private static final int BUF_SIZE = 262144;

    @Test
    public void testCountingKVs() throws Exception {
        ArrayList kvs = Lists.newArrayList();
        for (int i = 0; i < 400; ++i) {
            byte[] row = Bytes.toBytes((String)("row" + i));
            byte[] fam = Bytes.toBytes((String)("fam" + i));
            byte[] qual = Bytes.toBytes((String)("qual" + i));
            kvs.add(new KeyValue(row, fam, qual, 12345L, VALUE));
        }
        this.runTestCycle(kvs);
    }

    @Test
    public void testRepeatingKVs() throws Exception {
        ArrayList kvs = Lists.newArrayList();
        for (int i = 0; i < 400; ++i) {
            byte[] row = Bytes.toBytes((String)("row" + i % 10));
            byte[] fam = Bytes.toBytes((String)("fam" + i % 127));
            byte[] qual = Bytes.toBytes((String)("qual" + i % 128));
            kvs.add(new KeyValue(row, fam, qual, 12345L, VALUE));
        }
        this.runTestCycle(kvs);
    }

    private void runTestCycle(List<KeyValue> kvs) throws Exception {
        CompressionContext ctx = new CompressionContext(LRUDictionary.class);
        DataOutputBuffer buf = new DataOutputBuffer(262144);
        for (KeyValue kv : kvs) {
            KeyValueCompression.writeKV((DataOutput)buf, (KeyValue)kv, (CompressionContext)ctx);
        }
        ctx.clear();
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(buf.getData(), 0, buf.getLength()));
        for (KeyValue kv : kvs) {
            KeyValue readBack = KeyValueCompression.readKV((DataInput)in, (CompressionContext)ctx);
            Assert.assertEquals((Object)kv, (Object)readBack);
        }
    }
}

