/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.replication.ReplicationAdmin;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.MiniZooKeeperCluster;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.junit.AfterClass;
import org.junit.BeforeClass;

public class TestReplicationBase {
    private static final Log LOG = LogFactory.getLog(TestReplicationBase.class);
    protected static Configuration conf1 = HBaseConfiguration.create();
    protected static Configuration conf2;
    protected static Configuration CONF_WITH_LOCALFS;
    protected static ZooKeeperWatcher zkw1;
    protected static ZooKeeperWatcher zkw2;
    protected static ReplicationAdmin admin;
    protected static HTable htable1;
    protected static HTable htable2;
    protected static HBaseTestingUtility utility1;
    protected static HBaseTestingUtility utility2;
    protected static final int NB_ROWS_IN_BATCH = 100;
    protected static final int NB_ROWS_IN_BIG_BATCH = 1000;
    protected static final long SLEEP_TIME = 1000L;
    protected static final int NB_RETRIES = 15;
    protected static final int NB_RETRIES_FOR_BIG_BATCH = 30;
    protected static final byte[] tableName;
    protected static final byte[] famName;
    protected static final byte[] row;
    protected static final byte[] noRepfamName;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        conf1.set("zookeeper.znode.parent", "/1");
        conf1.setFloat("hbase.regionserver.logroll.multiplier", 3.0E-4f);
        conf1.setInt("replication.source.size.capacity", 1024);
        conf1.setLong("replication.source.sleepforretries", 100L);
        conf1.setInt("hbase.regionserver.maxlogs", 10);
        conf1.setLong("hbase.master.logcleaner.ttl", 10L);
        conf1.setInt("zookeeper.recovery.retry", 1);
        conf1.setInt("zookeeper.recovery.retry.intervalmill", 10);
        conf1.setBoolean("hbase.replication", true);
        conf1.setBoolean("dfs.support.append", true);
        conf1.setLong("hbase.server.thread.wakefrequency", 100L);
        conf1.setInt("replication.stats.thread.period.seconds", 5);
        utility1 = new HBaseTestingUtility(conf1);
        utility1.startMiniZKCluster();
        MiniZooKeeperCluster miniZK = utility1.getZkCluster();
        conf1 = utility1.getConfiguration();
        zkw1 = new ZooKeeperWatcher(conf1, "cluster1", null, true);
        admin = new ReplicationAdmin(conf1);
        LOG.info((Object)"Setup first Zk");
        conf2 = HBaseConfiguration.create((Configuration)conf1);
        conf2.set("zookeeper.znode.parent", "/2");
        conf2.setInt("hbase.client.retries.number", 6);
        conf2.setBoolean("hbase.replication", true);
        conf2.setBoolean("dfs.support.append", true);
        utility2 = new HBaseTestingUtility(conf2);
        utility2.setZkCluster(miniZK);
        zkw2 = new ZooKeeperWatcher(conf2, "cluster2", null, true);
        admin.addPeer("2", utility2.getClusterKey());
        TestReplicationBase.setIsReplication(true);
        LOG.info((Object)"Setup second Zk");
        CONF_WITH_LOCALFS = HBaseConfiguration.create((Configuration)conf1);
        utility1.startMiniCluster(2);
        utility2.startMiniCluster(2);
        HTableDescriptor table = new HTableDescriptor(tableName);
        HColumnDescriptor fam = new HColumnDescriptor(famName);
        fam.setScope(1);
        table.addFamily(fam);
        fam = new HColumnDescriptor(noRepfamName);
        table.addFamily(fam);
        HBaseAdmin admin1 = new HBaseAdmin(conf1);
        HBaseAdmin admin2 = new HBaseAdmin(conf2);
        admin1.createTable(table, HBaseTestingUtility.KEYS_FOR_HBA_CREATE_TABLE);
        admin2.createTable(table);
        htable1 = new HTable(conf1, tableName);
        htable1.setWriteBufferSize(1024L);
        htable2 = new HTable(conf2, tableName);
    }

    protected static void setIsReplication(boolean rep) throws Exception {
        LOG.info((Object)("Set rep " + rep));
        admin.setReplicating(rep);
        Thread.sleep(1000L);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        utility2.shutdownMiniCluster();
        utility1.shutdownMiniCluster();
    }

    static {
        tableName = Bytes.toBytes((String)"test");
        famName = Bytes.toBytes((String)"f");
        row = Bytes.toBytes((String)"row");
        noRepfamName = Bytes.toBytes((String)"norep");
    }
}

