/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.LargeTests;
import org.apache.hadoop.hbase.UnknownScannerException;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.replication.TestReplicationBase;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestReplicationQueueFailover
extends TestReplicationBase {
    private static final Log LOG = LogFactory.getLog(TestReplicationQueueFailover.class);

    @Test(timeout=300000L)
    public void queueFailover() throws Exception {
        Result[] res;
        int rsToKill1 = utility1.getHBaseCluster().getServerWithMeta() == 0 ? 1 : 0;
        int rsToKill2 = utility2.getHBaseCluster().getServerWithMeta() == 0 ? 1 : 0;
        Thread killer1 = TestReplicationQueueFailover.killARegionServer(utility1, 7500L, rsToKill1);
        Thread killer2 = TestReplicationQueueFailover.killARegionServer(utility2, 10000L, rsToKill2);
        LOG.info((Object)"Start loading table");
        int initialCount = utility1.loadTable(htable1, famName);
        LOG.info((Object)"Done loading table");
        killer1.join(5000L);
        killer2.join(5000L);
        LOG.info((Object)"Done waiting for threads");
        while (true) {
            try {
                Scan scan = new Scan();
                ResultScanner scanner = htable1.getScanner(scan);
                res = scanner.next(initialCount);
                scanner.close();
            }
            catch (UnknownScannerException ex) {
                LOG.info((Object)"Cluster wasn't ready yet, restarting scanner");
                continue;
            }
            break;
        }
        if (res.length != initialCount) {
            LOG.warn((Object)"We lost some rows on the master cluster!");
            initialCount = res.length;
        }
        int lastCount = 0;
        long start = System.currentTimeMillis();
        int i = 0;
        while (true) {
            if (i == 14) {
                Assert.fail((String)("Waited too much time for queueFailover replication. Waited " + (System.currentTimeMillis() - start) + "ms."));
            }
            Scan scan2 = new Scan();
            ResultScanner scanner2 = htable2.getScanner(scan2);
            Result[] res2 = scanner2.next(initialCount * 2);
            scanner2.close();
            if (res2.length >= initialCount) break;
            i = lastCount < res2.length ? --i : ++i;
            lastCount = res2.length;
            LOG.info((Object)("Only got " + lastCount + " rows instead of " + initialCount + " current i=" + i));
            Thread.sleep(2000L);
        }
    }

    private static Thread killARegionServer(final HBaseTestingUtility utility, final long timeout, final int rs) {
        Thread killer = new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(timeout);
                    utility.expireRegionServerSession(rs);
                }
                catch (Exception e) {
                    LOG.error((Object)"Couldn't kill a region server", (Throwable)e);
                }
            }
        };
        killer.setDaemon(true);
        killer.start();
        return killer;
    }
}

