/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.LargeTests;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.mapreduce.replication.VerifyReplication;
import org.apache.hadoop.hbase.replication.TestReplicationBase;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.mapreduce.Job;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestReplicationSmallTests
extends TestReplicationBase {
    private static final Log LOG = LogFactory.getLog(TestReplicationSmallTests.class);

    @Before
    public void setUp() throws Exception {
        htable1.setAutoFlush(true);
        for (JVMClusterUtil.RegionServerThread r : utility1.getHBaseCluster().getRegionServerThreads()) {
            r.getRegionServer().getWAL().rollWriter();
        }
        utility1.truncateTable(tableName);
        Scan scan = new Scan();
        int lastCount = 0;
        for (int i = 0; i < 15; ++i) {
            if (i == 14) {
                Assert.fail((String)"Waited too much time for truncate");
            }
            ResultScanner scanner = htable2.getScanner(scan);
            Result[] res = scanner.next(1000);
            scanner.close();
            if (res.length == 0) break;
            if (res.length < lastCount) {
                --i;
            }
            lastCount = res.length;
            LOG.info((Object)("Still got " + res.length + " rows"));
            Thread.sleep(1000L);
        }
    }

    @Test(timeout=300000L)
    public void testDeleteTypes() throws Exception {
        Result res;
        int i;
        LOG.info((Object)"testDeleteTypes");
        byte[] v1 = Bytes.toBytes((String)"v1");
        byte[] v2 = Bytes.toBytes((String)"v2");
        byte[] v3 = Bytes.toBytes((String)"v3");
        htable1 = new HTable(conf1, tableName);
        long t = EnvironmentEdgeManager.currentTimeMillis();
        Put put = new Put(row);
        put.add(famName, row, t, v1);
        htable1.put(put);
        put = new Put(row);
        put.add(famName, row, t + 1L, v2);
        htable1.put(put);
        put = new Put(row);
        put.add(famName, row, t + 2L, v3);
        htable1.put(put);
        Get get = new Get(row);
        get.setMaxVersions();
        for (int i2 = 0; i2 < 15; ++i2) {
            Result res2;
            if (i2 == 14) {
                Assert.fail((String)"Waited too much time for put replication");
            }
            if ((res2 = htable2.get(get)).size() >= 3) {
                Assert.assertArrayEquals((byte[])res2.raw()[0].getValue(), (byte[])v3);
                Assert.assertArrayEquals((byte[])res2.raw()[1].getValue(), (byte[])v2);
                Assert.assertArrayEquals((byte[])res2.raw()[2].getValue(), (byte[])v1);
                break;
            }
            LOG.info((Object)"Rows not available");
            Thread.sleep(1000L);
        }
        Delete d = new Delete(row);
        d.deleteColumn(famName, row, t);
        htable1.delete(d);
        get = new Get(row);
        get.setMaxVersions();
        for (i = 0; i < 15; ++i) {
            if (i == 14) {
                Assert.fail((String)"Waited too much time for put replication");
            }
            if ((res = htable2.get(get)).size() <= 2) {
                Assert.assertArrayEquals((byte[])res.raw()[0].getValue(), (byte[])v3);
                Assert.assertArrayEquals((byte[])res.raw()[1].getValue(), (byte[])v2);
                break;
            }
            LOG.info((Object)"Version not deleted");
            Thread.sleep(1000L);
        }
        d = new Delete(row);
        d.deleteColumns(famName, row, t + 2L);
        htable1.delete(d);
        get = new Get(row);
        for (i = 0; i < 15; ++i) {
            if (i == 14) {
                Assert.fail((String)"Waited too much time for del replication");
            }
            if ((res = htable2.get(get)).size() < 1) break;
            LOG.info((Object)"Rows not deleted");
            Thread.sleep(1000L);
        }
    }

    @Test(timeout=300000L)
    public void testSimplePutDelete() throws Exception {
        LOG.info((Object)"testSimplePutDelete");
        Put put = new Put(row);
        put.add(famName, row, row);
        htable1 = new HTable(conf1, tableName);
        htable1.put(put);
        Get get = new Get(row);
        for (int i = 0; i < 15; ++i) {
            Result res;
            if (i == 14) {
                Assert.fail((String)"Waited too much time for put replication");
            }
            if ((res = htable2.get(get)).size() != 0) {
                Assert.assertArrayEquals((byte[])res.value(), (byte[])row);
                break;
            }
            LOG.info((Object)"Row not available");
            Thread.sleep(1000L);
        }
        Delete del = new Delete(row);
        htable1.delete(del);
        get = new Get(row);
        for (int i = 0; i < 15; ++i) {
            Result res;
            if (i == 14) {
                Assert.fail((String)"Waited too much time for del replication");
            }
            if ((res = htable2.get(get)).size() < 1) break;
            LOG.info((Object)"Row not deleted");
            Thread.sleep(1000L);
        }
    }

    @Test(timeout=300000L)
    public void testSmallBatch() throws Exception {
        LOG.info((Object)"testSmallBatch");
        htable1.setAutoFlush(false);
        for (int i = 0; i < 100; ++i) {
            Put put = new Put(Bytes.toBytes((int)i));
            put.add(famName, row, row);
            htable1.put(put);
        }
        htable1.flushCommits();
        Scan scan = new Scan();
        ResultScanner scanner1 = htable1.getScanner(scan);
        Result[] res1 = scanner1.next(100);
        scanner1.close();
        Assert.assertEquals((long)100L, (long)res1.length);
        for (int i = 0; i < 15; ++i) {
            if (i == 14) {
                Assert.fail((String)"Waited too much time for normal batch replication");
            }
            ResultScanner scanner = htable2.getScanner(scan);
            Result[] res = scanner.next(100);
            scanner.close();
            if (res.length == 100) break;
            LOG.info((Object)("Only got " + res.length + " rows"));
            Thread.sleep(1000L);
        }
    }

    @Test(timeout=300000L)
    public void testStartStop() throws Exception {
        Result res;
        int i;
        TestReplicationSmallTests.setIsReplication(false);
        Put put = new Put(Bytes.toBytes((String)"stop start"));
        put.add(famName, row, row);
        htable1.put(put);
        Get get = new Get(Bytes.toBytes((String)"stop start"));
        for (i = 0; i < 15 && i != 14; ++i) {
            res = htable2.get(get);
            if (res.size() >= 1) {
                Assert.fail((String)"Replication wasn't stopped");
                continue;
            }
            LOG.info((Object)"Row not replicated, let's wait a bit more...");
            Thread.sleep(1000L);
        }
        TestReplicationSmallTests.setIsReplication(true);
        htable1.put(put);
        for (i = 0; i < 15; ++i) {
            if (i == 14) {
                Assert.fail((String)"Waited too much time for put replication");
            }
            if ((res = htable2.get(get)).size() != 0) {
                Assert.assertArrayEquals((byte[])res.value(), (byte[])row);
                break;
            }
            LOG.info((Object)"Row not available");
            Thread.sleep(1000L);
        }
        put = new Put(Bytes.toBytes((String)"do not rep"));
        put.add(noRepfamName, row, row);
        htable1.put(put);
        get = new Get(Bytes.toBytes((String)"do not rep"));
        for (i = 0; i < 15 && i != 14; ++i) {
            res = htable2.get(get);
            if (res.size() >= 1) {
                Assert.fail((String)"Not supposed to be replicated");
                continue;
            }
            LOG.info((Object)"Row not replicated, let's wait a bit more...");
            Thread.sleep(1000L);
        }
    }

    @Test(timeout=300000L)
    public void testDisableEnable() throws Exception {
        Result res;
        int i;
        admin.disablePeer("2");
        byte[] rowkey = Bytes.toBytes((String)"disable enable");
        Put put = new Put(rowkey);
        put.add(famName, row, row);
        htable1.put(put);
        Get get = new Get(rowkey);
        for (i = 0; i < 15; ++i) {
            res = htable2.get(get);
            if (res.size() >= 1) {
                Assert.fail((String)"Replication wasn't disabled");
                continue;
            }
            LOG.info((Object)"Row not replicated, let's wait a bit more...");
            Thread.sleep(1000L);
        }
        admin.enablePeer("2");
        for (i = 0; i < 15; ++i) {
            res = htable2.get(get);
            if (res.size() != 0) {
                Assert.assertArrayEquals((byte[])res.value(), (byte[])row);
                return;
            }
            LOG.info((Object)"Row not available");
            Thread.sleep(1000L);
        }
        Assert.fail((String)"Waited too much time for put replication");
    }

    @Test(timeout=300000L)
    public void testAddAndRemoveClusters() throws Exception {
        Result res;
        int i;
        LOG.info((Object)"testAddAndRemoveClusters");
        admin.removePeer("2");
        Thread.sleep(1000L);
        byte[] rowKey = Bytes.toBytes((String)"Won't be replicated");
        Put put = new Put(rowKey);
        put.add(famName, row, row);
        htable1.put(put);
        Get get = new Get(rowKey);
        for (i = 0; i < 15 && i != 14; ++i) {
            res = htable2.get(get);
            if (res.size() >= 1) {
                Assert.fail((String)"Not supposed to be replicated");
                continue;
            }
            LOG.info((Object)"Row not replicated, let's wait a bit more...");
            Thread.sleep(1000L);
        }
        admin.addPeer("2", utility2.getClusterKey());
        Thread.sleep(1000L);
        rowKey = Bytes.toBytes((String)"do rep");
        put = new Put(rowKey);
        put.add(famName, row, row);
        LOG.info((Object)"Adding new row");
        htable1.put(put);
        get = new Get(rowKey);
        for (i = 0; i < 15; ++i) {
            if (i == 14) {
                Assert.fail((String)"Waited too much time for put replication");
            }
            if ((res = htable2.get(get)).size() != 0) {
                Assert.assertArrayEquals((byte[])res.value(), (byte[])row);
                break;
            }
            LOG.info((Object)"Row not available");
            Thread.sleep(1000L * (long)i);
        }
    }

    @Test(timeout=300000L)
    public void loadTesting() throws Exception {
        htable1.setWriteBufferSize(1024L);
        htable1.setAutoFlush(false);
        for (int i = 0; i < 1000; ++i) {
            Put put = new Put(Bytes.toBytes((int)i));
            put.add(famName, row, row);
            htable1.put(put);
        }
        htable1.flushCommits();
        Scan scan = new Scan();
        ResultScanner scanner = htable1.getScanner(scan);
        Result[] res = scanner.next(1000);
        scanner.close();
        Assert.assertEquals((long)1000L, (long)res.length);
        scan = new Scan();
        for (int i = 0; i < 30; ++i) {
            scanner = htable2.getScanner(scan);
            res = scanner.next(1000);
            scanner.close();
            if (res.length == 1000) break;
            if (i == 29) {
                int lastRow = -1;
                for (Result result : res) {
                    int currentRow = Bytes.toInt((byte[])result.getRow());
                    for (int row = lastRow + 1; row < currentRow; ++row) {
                        LOG.error((Object)("Row missing: " + row));
                    }
                    lastRow = currentRow;
                }
                LOG.error((Object)("Last row: " + lastRow));
                Assert.fail((String)("Waited too much time for normal batch replication, " + res.length + " instead of " + 1000));
                continue;
            }
            LOG.info((Object)("Only got " + res.length + " rows"));
            Thread.sleep(1000L);
        }
    }

    @Test(timeout=300000L)
    public void testVerifyRepJob() throws Exception {
        this.testSmallBatch();
        String[] args = new String[]{"2", Bytes.toString((byte[])tableName)};
        Job job = VerifyReplication.createSubmittableJob((Configuration)CONF_WITH_LOCALFS, (String[])args);
        if (job == null) {
            Assert.fail((String)"Job wasn't created, see the log");
        }
        if (!job.waitForCompletion(true)) {
            Assert.fail((String)"Job failed, see the log");
        }
        Assert.assertEquals((long)100L, (long)job.getCounters().findCounter((Enum)VerifyReplication.Verifier.Counters.GOODROWS).getValue());
        Assert.assertEquals((long)0L, (long)job.getCounters().findCounter((Enum)VerifyReplication.Verifier.Counters.BADROWS).getValue());
        Scan scan = new Scan();
        ResultScanner rs = htable2.getScanner(scan);
        Put put = null;
        for (Result result : rs) {
            put = new Put(result.getRow());
            KeyValue firstVal = result.raw()[0];
            put.add(firstVal.getFamily(), firstVal.getQualifier(), Bytes.toBytes((String)"diff data"));
            htable2.put(put);
        }
        Delete delete = new Delete(put.getRow());
        htable2.delete(delete);
        job = VerifyReplication.createSubmittableJob((Configuration)CONF_WITH_LOCALFS, (String[])args);
        if (job == null) {
            Assert.fail((String)"Job wasn't created, see the log");
        }
        if (!job.waitForCompletion(true)) {
            Assert.fail((String)"Job failed, see the log");
        }
        Assert.assertEquals((long)0L, (long)job.getCounters().findCounter((Enum)VerifyReplication.Verifier.Counters.GOODROWS).getValue());
        Assert.assertEquals((long)100L, (long)job.getCounters().findCounter((Enum)VerifyReplication.Verifier.Counters.BADROWS).getValue());
    }
}

