/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.catalog.CatalogTracker;
import org.apache.hadoop.hbase.replication.ReplicationZookeeper;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestReplicationZookeeper {
    private static Configuration conf;
    private static HBaseTestingUtility utility;
    private static ZooKeeperWatcher zkw;
    private static ReplicationZookeeper repZk;
    private static String slaveClusterKey;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        utility = new HBaseTestingUtility();
        utility.startMiniZKCluster();
        conf = utility.getConfiguration();
        zkw = HBaseTestingUtility.getZooKeeperWatcher(utility);
        DummyServer server = new DummyServer();
        repZk = new ReplicationZookeeper((Server)server, new AtomicBoolean());
        slaveClusterKey = conf.get("hbase.zookeeper.quorum") + ":" + conf.get("hbase.zookeeper.property.clientPort") + ":/1";
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        utility.shutdownMiniZKCluster();
    }

    @Test
    public void testGetAddressesMissingSlave() throws IOException, KeeperException {
        repZk.addPeer("1", slaveClusterKey);
        Assert.assertEquals((long)0L, (long)repZk.getSlavesAddresses("1").size());
    }

    static class DummyServer
    implements Server {
        DummyServer() {
        }

        public Configuration getConfiguration() {
            return conf;
        }

        public ZooKeeperWatcher getZooKeeper() {
            return zkw;
        }

        public CatalogTracker getCatalogTracker() {
            return null;
        }

        public ServerName getServerName() {
            return new ServerName("hostname.example.org", 1234, -1L);
        }

        public void abort(String why, Throwable e) {
        }

        public boolean isAborted() {
            return false;
        }

        public void stop(String why) {
        }

        public boolean isStopped() {
            return false;
        }
    }
}

