/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest.client;

import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.rest.HBaseRESTTestingUtility;
import org.apache.hadoop.hbase.rest.client.Client;
import org.apache.hadoop.hbase.rest.client.Cluster;
import org.apache.hadoop.hbase.rest.client.RemoteAdmin;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestRemoteAdmin {
    private static final String TABLE_1 = "TestRemoteAdmin_Table_1";
    private static final byte[] COLUMN_1 = Bytes.toBytes((String)"a");
    static final HTableDescriptor DESC_1 = new HTableDescriptor("TestRemoteAdmin_Table_1");
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final HBaseRESTTestingUtility REST_TEST_UTIL = new HBaseRESTTestingUtility();
    private static RemoteAdmin remoteAdmin;
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        DESC_1.addFamily(new HColumnDescriptor(COLUMN_1));
        TEST_UTIL.startMiniCluster();
        REST_TEST_UTIL.startServletContainer(TEST_UTIL.getConfiguration());
        remoteAdmin = new RemoteAdmin(new Client(new Cluster().add("localhost", REST_TEST_UTIL.getServletPort())), TEST_UTIL.getConfiguration());
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        REST_TEST_UTIL.shutdownServletContainer();
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testCreateAnDeleteTable() throws Exception {
        Assert.assertFalse((boolean)remoteAdmin.isTableAvailable(TABLE_1));
        remoteAdmin.createTable(DESC_1);
        Assert.assertTrue((boolean)remoteAdmin.isTableAvailable(TABLE_1));
        remoteAdmin.deleteTable(TABLE_1);
        Assert.assertFalse((boolean)remoteAdmin.isTableAvailable(TABLE_1));
    }
}

