/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest.model;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import junit.framework.TestCase;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.rest.model.ScannerModel;
import org.apache.hadoop.hbase.util.Base64;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Rule;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestScannerModel
extends TestCase {
    private static final byte[] START_ROW = Bytes.toBytes((String)"abracadabra");
    private static final byte[] END_ROW = Bytes.toBytes((String)"zzyzx");
    private static final byte[] COLUMN1 = Bytes.toBytes((String)"column1");
    private static final byte[] COLUMN2 = Bytes.toBytes((String)"column2:foo");
    private static final long START_TIME = 1245219839331L;
    private static final long END_TIME = 1245393318192L;
    private static final int BATCH = 100;
    private static final String AS_XML = "<Scanner startTime=\"1245219839331\" startRow=\"YWJyYWNhZGFicmE=\" endTime=\"1245393318192\" endRow=\"enp5eng=\" batch=\"100\"><column>Y29sdW1uMQ==</column><column>Y29sdW1uMjpmb28=</column></Scanner>";
    private static final String AS_PB = "CgthYnJhY2FkYWJyYRIFenp5engaB2NvbHVtbjEaC2NvbHVtbjI6Zm9vIGQo47qL554kMLDi57mfJA==";
    private JAXBContext context;
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    public TestScannerModel() throws JAXBException {
        this.context = JAXBContext.newInstance((Class[])new Class[]{ScannerModel.class});
    }

    private ScannerModel buildTestModel() {
        ScannerModel model = new ScannerModel();
        model.setStartRow(START_ROW);
        model.setEndRow(END_ROW);
        model.addColumn(COLUMN1);
        model.addColumn(COLUMN2);
        model.setStartTime(1245219839331L);
        model.setEndTime(1245393318192L);
        model.setBatch(100);
        return model;
    }

    private String toXML(ScannerModel model) throws JAXBException {
        StringWriter writer = new StringWriter();
        this.context.createMarshaller().marshal((Object)model, (Writer)writer);
        return writer.toString();
    }

    private ScannerModel fromXML(String xml) throws JAXBException {
        return (ScannerModel)this.context.createUnmarshaller().unmarshal((Reader)new StringReader(xml));
    }

    private byte[] toPB(ScannerModel model) {
        return model.createProtobufOutput();
    }

    private ScannerModel fromPB(String pb) throws IOException {
        return (ScannerModel)new ScannerModel().getObjectFromMessage(Base64.decode((String)AS_PB));
    }

    private void checkModel(ScannerModel model) {
        TestScannerModel.assertTrue((boolean)Bytes.equals((byte[])model.getStartRow(), (byte[])START_ROW));
        TestScannerModel.assertTrue((boolean)Bytes.equals((byte[])model.getEndRow(), (byte[])END_ROW));
        boolean foundCol1 = false;
        boolean foundCol2 = false;
        for (byte[] column : model.getColumns()) {
            if (Bytes.equals((byte[])column, (byte[])COLUMN1)) {
                foundCol1 = true;
                continue;
            }
            if (!Bytes.equals((byte[])column, (byte[])COLUMN2)) continue;
            foundCol2 = true;
        }
        TestScannerModel.assertTrue((boolean)foundCol1);
        TestScannerModel.assertTrue((boolean)foundCol2);
        TestScannerModel.assertEquals((long)model.getStartTime(), (long)1245219839331L);
        TestScannerModel.assertEquals((long)model.getEndTime(), (long)1245393318192L);
        TestScannerModel.assertEquals((int)model.getBatch(), (int)100);
    }

    public void testBuildModel() throws Exception {
        this.checkModel(this.buildTestModel());
    }

    public void testFromXML() throws Exception {
        this.checkModel(this.fromXML(AS_XML));
    }

    public void testFromPB() throws Exception {
        this.checkModel(this.fromPB(AS_PB));
    }
}

