/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.snapshot;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.snapshot.ExportSnapshot;
import org.apache.hadoop.hbase.snapshot.SnapshotReferenceUtil;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.Pair;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestExportSnapshot {
    private final Log LOG = LogFactory.getLog(this.getClass());
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final byte[] FAMILY = Bytes.toBytes((String)"cf");
    private byte[] snapshotName;
    private byte[] tableName;
    private HBaseAdmin admin;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setBoolean("hbase.snapshot.enabled", true);
        TEST_UTIL.getConfiguration().setInt("hbase.regionserver.msginterval", 100);
        TEST_UTIL.getConfiguration().setInt("hbase.client.pause", 250);
        TEST_UTIL.getConfiguration().setInt("hbase.client.retries.number", 6);
        TEST_UTIL.getConfiguration().setBoolean("hbase.master.enabletable.roundrobin", true);
        TEST_UTIL.startMiniCluster(3);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() throws Exception {
        this.admin = TEST_UTIL.getHBaseAdmin();
        long tid = System.currentTimeMillis();
        this.tableName = Bytes.toBytes((String)("testtb-" + tid));
        this.snapshotName = Bytes.toBytes((String)("snaptb0-" + tid));
        HTableDescriptor htd = new HTableDescriptor(this.tableName);
        htd.addFamily(new HColumnDescriptor(FAMILY));
        this.admin.createTable(htd, (byte[][])null);
        HTable table = new HTable(TEST_UTIL.getConfiguration(), this.tableName);
        TEST_UTIL.loadTable(table, FAMILY);
        this.admin.disableTable(this.tableName);
        this.admin.snapshot(this.snapshotName, this.tableName);
        this.admin.enableTable(this.tableName);
    }

    @After
    public void tearDown() throws Exception {
        this.admin.close();
    }

    @Test
    public void testBalanceSplit() throws Exception {
        ArrayList<Pair> files = new ArrayList<Pair>();
        for (long i = 0L; i <= 20L; ++i) {
            files.add(new Pair((Object)new Path("file-" + i), (Object)i));
        }
        List splits = ExportSnapshot.getBalancedSplits(files, (int)5);
        Assert.assertEquals((long)5L, (long)splits.size());
        Assert.assertEquals(Arrays.asList(new Path("file-20"), new Path("file-11"), new Path("file-10"), new Path("file-1"), new Path("file-0")), splits.get(0));
        Assert.assertEquals(Arrays.asList(new Path("file-19"), new Path("file-12"), new Path("file-9"), new Path("file-2")), splits.get(1));
        Assert.assertEquals(Arrays.asList(new Path("file-18"), new Path("file-13"), new Path("file-8"), new Path("file-3")), splits.get(2));
        Assert.assertEquals(Arrays.asList(new Path("file-17"), new Path("file-14"), new Path("file-7"), new Path("file-4")), splits.get(3));
        Assert.assertEquals(Arrays.asList(new Path("file-16"), new Path("file-15"), new Path("file-6"), new Path("file-5")), splits.get(4));
    }

    @Test
    public void testExportFileSystemState() throws Exception {
        Path copyDir = TEST_UTIL.getDataTestDir("export-" + System.currentTimeMillis());
        URI hdfsUri = FileSystem.get((Configuration)TEST_UTIL.getConfiguration()).getUri();
        FileSystem fs = FileSystem.get((URI)copyDir.toUri(), (Configuration)new Configuration());
        copyDir = copyDir.makeQualified(fs);
        int res = ExportSnapshot.innerMain((Configuration)TEST_UTIL.getConfiguration(), (String[])new String[]{"-snapshot", Bytes.toString((byte[])this.snapshotName), "-copy-to", copyDir.toString()});
        Assert.assertEquals((long)0L, (long)res);
        FileStatus[] rootFiles = fs.listStatus(copyDir);
        Assert.assertEquals((long)2L, (long)rootFiles.length);
        for (FileStatus fileStatus : rootFiles) {
            String name = fileStatus.getPath().getName();
            Assert.assertTrue((boolean)fileStatus.isDir());
            Assert.assertTrue((name.equals(".snapshot") || name.equals(".archive") ? 1 : 0) != 0);
        }
        FileSystem hdfs = FileSystem.get((URI)hdfsUri, (Configuration)TEST_UTIL.getConfiguration());
        Path snapshotDir = new Path(".snapshot", Bytes.toString((byte[])this.snapshotName));
        this.verifySnapshot(hdfs, new Path(TEST_UTIL.getDefaultRootDirPath(), snapshotDir), fs, new Path(copyDir, snapshotDir));
        this.verifyArchive(fs, copyDir, Bytes.toString((byte[])this.snapshotName));
        fs.delete(copyDir, true);
    }

    private void verifySnapshot(FileSystem fs1, Path root1, FileSystem fs2, Path root2) throws IOException {
        HashSet s = new HashSet();
        Assert.assertEquals(this.listFiles(fs1, root1, root1), this.listFiles(fs2, root2, root2));
    }

    private void verifyArchive(final FileSystem fs, Path rootDir, String snapshotName) throws IOException {
        final Path exportedSnapshot = new Path(rootDir, new Path(".snapshot", snapshotName));
        final Path exportedArchive = new Path(rootDir, ".archive");
        this.LOG.debug(this.listFiles(fs, exportedArchive, exportedArchive));
        SnapshotReferenceUtil.visitReferencedFiles((FileSystem)fs, (Path)exportedSnapshot, (SnapshotReferenceUtil.FileVisitor)new SnapshotReferenceUtil.FileVisitor(){

            public void storeFile(String region, String family, String hfile) throws IOException {
                this.verifyNonEmptyFile(new Path(exportedArchive, new Path(Bytes.toString((byte[])TestExportSnapshot.this.tableName), new Path(region, new Path(family, hfile)))));
            }

            public void recoveredEdits(String region, String logfile) throws IOException {
                this.verifyNonEmptyFile(new Path(exportedSnapshot, new Path(Bytes.toString((byte[])TestExportSnapshot.this.tableName), new Path(region, logfile))));
            }

            public void logFile(String server, String logfile) throws IOException {
                this.verifyNonEmptyFile(new Path(exportedSnapshot, new Path(server, logfile)));
            }

            private void verifyNonEmptyFile(Path path) throws IOException {
                TestExportSnapshot.this.LOG.debug((Object)path);
                Assert.assertTrue((boolean)fs.exists(path));
                Assert.assertTrue((fs.getFileStatus(path).getLen() > 0L ? 1 : 0) != 0);
            }
        });
    }

    private Set<String> listFiles(FileSystem fs, Path root, Path dir) throws IOException {
        HashSet<String> files = new HashSet<String>();
        int rootPrefix = root.toString().length();
        FileStatus[] list = FSUtils.listStatus((FileSystem)fs, (Path)dir);
        if (list != null) {
            for (FileStatus fstat : list) {
                this.LOG.debug((Object)fstat.getPath());
                if (fstat.isDir()) {
                    files.addAll(this.listFiles(fs, root, fstat.getPath()));
                    continue;
                }
                files.add(fstat.getPath().toString().substring(rootPrefix));
            }
        }
        return files;
    }
}

