/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.snapshot;

import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.regionserver.wal.HLogKey;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.snapshot.SnapshotLogSplitter;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestSnapshotLogSplitter {
    final Log LOG = LogFactory.getLog(this.getClass());
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private byte[] TEST_QUALIFIER = Bytes.toBytes((String)"q");
    private byte[] TEST_FAMILY = Bytes.toBytes((String)"f");
    private Configuration conf;
    private FileSystem fs;
    private Path logFile;

    @Before
    public void setup() throws Exception {
        this.conf = TEST_UTIL.getConfiguration();
        this.fs = FileSystem.get((Configuration)this.conf);
        this.logFile = new Path(TEST_UTIL.getDataTestDir(), "test.log");
        this.writeTestLog(this.logFile);
    }

    @After
    public void tearDown() throws Exception {
        this.fs.delete(this.logFile, false);
    }

    @Test
    public void testSplitLogs() throws IOException {
        TreeMap<byte[], byte[]> regionsMap = new TreeMap<byte[], byte[]>(Bytes.BYTES_COMPARATOR);
        this.splitTestLogs(this.getTableName(5), regionsMap);
    }

    @Test
    public void testSplitLogsOnDifferentTable() throws IOException {
        byte[] tableName = this.getTableName(1);
        TreeMap<byte[], byte[]> regionsMap = new TreeMap<byte[], byte[]>(Bytes.BYTES_COMPARATOR);
        for (int j = 0; j < 10; ++j) {
            byte[] regionName = this.getRegionName(tableName, j);
            byte[] newRegionName = this.getNewRegionName(tableName, j);
            regionsMap.put(regionName, newRegionName);
        }
        this.splitTestLogs(tableName, regionsMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void splitTestLogs(byte[] tableName, Map<byte[], byte[]> regionsMap) throws IOException {
        Path tableDir = new Path(TEST_UTIL.getDataTestDir(), Bytes.toString((byte[])tableName));
        SnapshotLogSplitter logSplitter = new SnapshotLogSplitter(this.conf, this.fs, tableDir, tableName, regionsMap);
        try {
            logSplitter.splitLog(this.logFile);
        }
        finally {
            logSplitter.close();
        }
        this.verifyRecoverEdits(tableDir, tableName, regionsMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyRecoverEdits(Path tableDir, byte[] tableName, Map<byte[], byte[]> regionsMap) throws IOException {
        for (FileStatus regionStatus : FSUtils.listStatus((FileSystem)this.fs, (Path)tableDir)) {
            Assert.assertTrue((boolean)regionStatus.getPath().getName().startsWith(Bytes.toString((byte[])tableName)));
            Path regionEdits = HLog.getRegionDirRecoveredEditsDir((Path)regionStatus.getPath());
            byte[] regionName = Bytes.toBytes((String)regionStatus.getPath().getName());
            Assert.assertFalse((boolean)regionsMap.containsKey(regionName));
            for (FileStatus logStatus : FSUtils.listStatus((FileSystem)this.fs, (Path)regionEdits)) {
                HLog.Reader reader = HLog.getReader((FileSystem)this.fs, (Path)logStatus.getPath(), (Configuration)this.conf);
                try {
                    HLog.Entry entry;
                    while ((entry = reader.next()) != null) {
                        HLogKey key = entry.getKey();
                        Assert.assertArrayEquals((byte[])tableName, (byte[])key.getTablename());
                        Assert.assertArrayEquals((byte[])regionName, (byte[])key.getEncodedRegionName());
                    }
                }
                finally {
                    reader.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeTestLog(Path logFile) throws IOException {
        this.fs.mkdirs(logFile.getParent());
        HLog.Writer writer = HLog.createWriter((FileSystem)this.fs, (Path)logFile, (Configuration)this.conf);
        try {
            for (int i = 0; i < 7; ++i) {
                byte[] tableName = this.getTableName(i);
                for (int j = 0; j < 10; ++j) {
                    byte[] regionName = this.getRegionName(tableName, j);
                    for (int k = 0; k < 50; ++k) {
                        byte[] rowkey = Bytes.toBytes((String)("row-" + k));
                        HLogKey key = new HLogKey(regionName, tableName, (long)k, System.currentTimeMillis(), HConstants.DEFAULT_CLUSTER_ID);
                        WALEdit edit = new WALEdit();
                        edit.add(new KeyValue(rowkey, this.TEST_FAMILY, this.TEST_QUALIFIER, rowkey));
                        writer.append(new HLog.Entry(key, edit));
                    }
                }
            }
        }
        finally {
            writer.close();
        }
    }

    private byte[] getTableName(int tableId) {
        return Bytes.toBytes((String)("testtb-" + tableId));
    }

    private byte[] getRegionName(byte[] tableName, int regionId) {
        return Bytes.toBytes((String)(Bytes.toString((byte[])tableName) + "-region-" + regionId));
    }

    private byte[] getNewRegionName(byte[] tableName, int regionId) {
        return Bytes.toBytes((String)(Bytes.toString((byte[])tableName) + "-new-region-" + regionId));
    }
}

