/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.thrift;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.filter.ParseFilter;
import org.apache.hadoop.hbase.thrift.HbaseHandlerMetricsProxy;
import org.apache.hadoop.hbase.thrift.ThriftMetrics;
import org.apache.hadoop.hbase.thrift.ThriftServerRunner;
import org.apache.hadoop.hbase.thrift.generated.BatchMutation;
import org.apache.hadoop.hbase.thrift.generated.ColumnDescriptor;
import org.apache.hadoop.hbase.thrift.generated.Hbase;
import org.apache.hadoop.hbase.thrift.generated.Mutation;
import org.apache.hadoop.hbase.thrift.generated.TCell;
import org.apache.hadoop.hbase.thrift.generated.TIncrement;
import org.apache.hadoop.hbase.thrift.generated.TRowResult;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.metrics.ContextFactory;
import org.apache.hadoop.metrics.MetricsContext;
import org.apache.hadoop.metrics.MetricsUtil;
import org.apache.hadoop.metrics.spi.NoEmitMetricsContext;
import org.apache.hadoop.metrics.spi.OutputRecord;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestThriftServer {
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static final Log LOG = LogFactory.getLog(TestThriftServer.class);
    protected static final int MAXVERSIONS = 3;
    private static ByteBuffer tableAname = TestThriftServer.asByteBuffer("tableA");
    private static ByteBuffer tableBname = TestThriftServer.asByteBuffer("tableB");
    private static ByteBuffer columnAname = TestThriftServer.asByteBuffer("columnA:");
    private static ByteBuffer columnAAname = TestThriftServer.asByteBuffer("columnA:A");
    private static ByteBuffer columnBname = TestThriftServer.asByteBuffer("columnB:");
    private static ByteBuffer rowAname = TestThriftServer.asByteBuffer("rowA");
    private static ByteBuffer rowBname = TestThriftServer.asByteBuffer("rowB");
    private static ByteBuffer valueAname = TestThriftServer.asByteBuffer("valueA");
    private static ByteBuffer valueBname = TestThriftServer.asByteBuffer("valueB");
    private static ByteBuffer valueCname = TestThriftServer.asByteBuffer("valueC");
    private static ByteBuffer valueDname = TestThriftServer.asByteBuffer("valueD");
    private static ByteBuffer valueEname = TestThriftServer.asByteBuffer(100L);
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    private static ByteBuffer asByteBuffer(String i) {
        return ByteBuffer.wrap(Bytes.toBytes((String)i));
    }

    private static ByteBuffer asByteBuffer(long l) {
        return ByteBuffer.wrap(Bytes.toBytes((long)l));
    }

    @BeforeClass
    public static void beforeClass() throws Exception {
        UTIL.getConfiguration().setBoolean("hbase.regionserver.thrift.coalesceIncrement", true);
        UTIL.startMiniCluster();
    }

    @AfterClass
    public static void afterClass() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void testAll() throws Exception {
        this.doTestTableCreateDrop();
        this.doTestThriftMetrics();
        this.doTestTableMutations();
        this.doTestTableTimestampsAndColumns();
        this.doTestTableScanners();
        this.doTestGetTableRegions();
        this.doTestFilterRegistration();
    }

    public void doTestTableCreateDrop() throws Exception {
        ThriftServerRunner.HBaseHandler handler = new ThriftServerRunner.HBaseHandler(UTIL.getConfiguration());
        TestThriftServer.doTestTableCreateDrop((Hbase.Iface)handler);
    }

    public static void doTestTableCreateDrop(Hbase.Iface handler) throws Exception {
        TestThriftServer.createTestTables(handler);
        TestThriftServer.dropTestTables(handler);
    }

    public void doTestThriftMetrics() throws Exception {
        Configuration conf = UTIL.getConfiguration();
        ThriftMetrics metrics = TestThriftServer.getMetrics(conf);
        Hbase.Iface handler = TestThriftServer.getHandler(metrics, conf);
        TestThriftServer.createTestTables(handler);
        TestThriftServer.dropTestTables(handler);
        TestThriftServer.verifyMetrics(metrics, "createTable_num_ops", 2);
        TestThriftServer.verifyMetrics(metrics, "deleteTable_num_ops", 2);
        TestThriftServer.verifyMetrics(metrics, "disableTable_num_ops", 2);
    }

    private static Hbase.Iface getHandler(ThriftMetrics metrics, Configuration conf) throws Exception {
        ThriftServerRunner.HBaseHandler handler = new ThriftServerRunner.HBaseHandler(conf);
        return HbaseHandlerMetricsProxy.newInstance((Hbase.Iface)handler, (ThriftMetrics)metrics, (Configuration)conf);
    }

    private static ThriftMetrics getMetrics(Configuration conf) throws Exception {
        TestThriftServer.setupMetricsContext();
        return new ThriftMetrics(9090, conf, Hbase.Iface.class);
    }

    private static void setupMetricsContext() throws IOException {
        ContextFactory factory = ContextFactory.getFactory();
        factory.setAttribute("thriftserver.class", (Object)NoEmitMetricsContext.class.getName());
        MetricsUtil.getContext((String)"thriftserver").createRecord("thriftserver").remove();
    }

    private static void verifyMetrics(ThriftMetrics metrics, String name, int expectValue) throws Exception {
        MetricsContext context = MetricsUtil.getContext((String)"thriftserver");
        metrics.doUpdates(context);
        OutputRecord record = (OutputRecord)((Collection)context.getAllRecords().get("thriftserver")).iterator().next();
        Assert.assertEquals((long)expectValue, (long)record.getMetric(name).intValue());
    }

    public static void createTestTables(Hbase.Iface handler) throws Exception {
        Assert.assertEquals((long)handler.getTableNames().size(), (long)0L);
        handler.createTable(tableAname, TestThriftServer.getColumnDescriptors());
        Assert.assertEquals((long)handler.getTableNames().size(), (long)1L);
        Assert.assertEquals((long)handler.getColumnDescriptors(tableAname).size(), (long)2L);
        Assert.assertTrue((boolean)handler.isTableEnabled(tableAname));
        handler.createTable(tableBname, new ArrayList());
        Assert.assertEquals((long)handler.getTableNames().size(), (long)2L);
    }

    public static void dropTestTables(Hbase.Iface handler) throws Exception {
        handler.disableTable(tableBname);
        Assert.assertFalse((boolean)handler.isTableEnabled(tableBname));
        handler.deleteTable(tableBname);
        Assert.assertEquals((long)handler.getTableNames().size(), (long)1L);
        handler.disableTable(tableAname);
        handler.deleteTable(tableAname);
    }

    public void doTestIncrements() throws Exception {
        ThriftServerRunner.HBaseHandler handler = new ThriftServerRunner.HBaseHandler(UTIL.getConfiguration());
        TestThriftServer.createTestTables((Hbase.Iface)handler);
        TestThriftServer.doTestIncrements(handler);
        TestThriftServer.dropTestTables((Hbase.Iface)handler);
    }

    public static void doTestIncrements(ThriftServerRunner.HBaseHandler handler) throws Exception {
        ArrayList<Mutation> mutations = new ArrayList<Mutation>(1);
        mutations.add(new Mutation(false, columnAAname, valueEname, true));
        mutations.add(new Mutation(false, columnAname, valueEname, true));
        handler.mutateRow(tableAname, rowAname, mutations, null);
        handler.mutateRow(tableAname, rowBname, mutations, null);
        ArrayList<TIncrement> increments = new ArrayList<TIncrement>();
        increments.add(new TIncrement(tableAname, rowBname, columnAAname, 7L));
        increments.add(new TIncrement(tableAname, rowBname, columnAAname, 7L));
        increments.add(new TIncrement(tableAname, rowBname, columnAAname, 7L));
        int numIncrements = 60000;
        for (int i = 0; i < numIncrements; ++i) {
            handler.increment(new TIncrement(tableAname, rowAname, columnAname, 2L));
            handler.incrementRows(increments);
        }
        Thread.sleep(1000L);
        long lv = ((TCell)handler.get((ByteBuffer)TestThriftServer.tableAname, (ByteBuffer)TestThriftServer.rowAname, (ByteBuffer)TestThriftServer.columnAname, null).get((int)0)).value.getLong();
        Assert.assertEquals((long)(100 + 2 * numIncrements), (long)lv);
        lv = ((TCell)handler.get((ByteBuffer)TestThriftServer.tableAname, (ByteBuffer)TestThriftServer.rowBname, (ByteBuffer)TestThriftServer.columnAAname, null).get((int)0)).value.getLong();
        Assert.assertEquals((long)(100 + 21 * numIncrements), (long)lv);
        Assert.assertTrue((handler.coalescer.getSuccessfulCoalescings() > 0L ? 1 : 0) != 0);
    }

    public void doTestTableMutations() throws Exception {
        ThriftServerRunner.HBaseHandler handler = new ThriftServerRunner.HBaseHandler(UTIL.getConfiguration());
        TestThriftServer.doTestTableMutations((Hbase.Iface)handler);
    }

    public static void doTestTableMutations(Hbase.Iface handler) throws Exception {
        handler.createTable(tableAname, TestThriftServer.getColumnDescriptors());
        handler.mutateRow(tableAname, rowAname, TestThriftServer.getMutations(), null);
        Assert.assertEquals((Object)valueAname, (Object)((TCell)handler.get((ByteBuffer)TestThriftServer.tableAname, (ByteBuffer)TestThriftServer.rowAname, (ByteBuffer)TestThriftServer.columnAname, null).get((int)0)).value);
        TRowResult rowResult1 = (TRowResult)handler.getRow(tableAname, rowAname, null).get(0);
        Assert.assertEquals((Object)rowAname, (Object)rowResult1.row);
        Assert.assertEquals((Object)valueBname, (Object)((TCell)rowResult1.columns.get((Object)TestThriftServer.columnBname)).value);
        handler.mutateRows(tableAname, TestThriftServer.getBatchMutations(), null);
        List cells = handler.get(tableAname, rowAname, columnAname, null);
        Assert.assertFalse((cells.size() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)valueCname, (Object)((TCell)handler.get((ByteBuffer)TestThriftServer.tableAname, (ByteBuffer)TestThriftServer.rowAname, (ByteBuffer)TestThriftServer.columnBname, null).get((int)0)).value);
        List versions = handler.getVer(tableAname, rowAname, columnBname, 3, null);
        Assert.assertEquals((Object)valueCname, (Object)((TCell)versions.get((int)0)).value);
        Assert.assertEquals((Object)valueBname, (Object)((TCell)versions.get((int)1)).value);
        TRowResult rowResult2 = (TRowResult)handler.getRow(tableAname, rowBname, null).get(0);
        Assert.assertEquals((Object)rowBname, (Object)rowResult2.row);
        Assert.assertEquals((Object)valueCname, (Object)((TCell)rowResult2.columns.get((Object)TestThriftServer.columnAname)).value);
        Assert.assertEquals((Object)valueDname, (Object)((TCell)rowResult2.columns.get((Object)TestThriftServer.columnBname)).value);
        handler.deleteAll(tableAname, rowAname, columnBname, null);
        handler.deleteAllRow(tableAname, rowBname, null);
        int size = handler.get(tableAname, rowAname, columnBname, null).size();
        Assert.assertEquals((long)0L, (long)size);
        size = handler.getRow(tableAname, rowBname, null).size();
        Assert.assertEquals((long)0L, (long)size);
        ArrayList<Mutation> mutations = new ArrayList<Mutation>();
        mutations.add(new Mutation(false, columnAname, null, true));
        handler.mutateRow(tableAname, rowAname, mutations, null);
        TRowResult rowResult3 = (TRowResult)handler.getRow(tableAname, rowAname, null).get(0);
        Assert.assertEquals((Object)rowAname, (Object)rowResult3.row);
        Assert.assertEquals((long)0L, (long)((TCell)rowResult3.columns.get((Object)TestThriftServer.columnAname)).value.remaining());
        handler.disableTable(tableAname);
        handler.deleteTable(tableAname);
    }

    public void doTestTableTimestampsAndColumns() throws Exception {
        ThriftServerRunner.HBaseHandler handler = new ThriftServerRunner.HBaseHandler(UTIL.getConfiguration());
        handler.createTable(tableAname, TestThriftServer.getColumnDescriptors());
        long time1 = System.currentTimeMillis();
        handler.mutateRowTs(tableAname, rowAname, TestThriftServer.getMutations(), time1, null);
        Thread.sleep(1000L);
        long time2 = System.currentTimeMillis();
        handler.mutateRowsTs(tableAname, TestThriftServer.getBatchMutations(), time2, null);
        handler.mutateRowTs(tableAname, rowBname, TestThriftServer.getMutations(), time2, null);
        Assert.assertEquals((long)2L, (long)handler.getVerTs(tableAname, rowAname, columnBname, time2 += 2L, 3, null).size());
        Assert.assertEquals((long)1L, (long)handler.getVerTs(tableAname, rowAname, columnBname, ++time1, 3, null).size());
        TRowResult rowResult1 = (TRowResult)handler.getRowTs(tableAname, rowAname, time1, null).get(0);
        TRowResult rowResult2 = (TRowResult)handler.getRowTs(tableAname, rowAname, time2, null).get(0);
        Assert.assertEquals((Object)((TCell)rowResult1.columns.get((Object)TestThriftServer.columnBname)).value, (Object)valueBname);
        Assert.assertEquals((Object)((TCell)rowResult2.columns.get((Object)TestThriftServer.columnBname)).value, (Object)valueCname);
        Assert.assertFalse((boolean)rowResult2.columns.containsKey(columnAname));
        ArrayList<ByteBuffer> columns = new ArrayList<ByteBuffer>();
        columns.add(columnBname);
        rowResult1 = (TRowResult)handler.getRowWithColumns(tableAname, rowAname, columns, null).get(0);
        Assert.assertEquals((Object)((TCell)rowResult1.columns.get((Object)TestThriftServer.columnBname)).value, (Object)valueCname);
        Assert.assertFalse((boolean)rowResult1.columns.containsKey(columnAname));
        rowResult1 = (TRowResult)handler.getRowWithColumnsTs(tableAname, rowAname, columns, time1, null).get(0);
        Assert.assertEquals((Object)((TCell)rowResult1.columns.get((Object)TestThriftServer.columnBname)).value, (Object)valueBname);
        Assert.assertFalse((boolean)rowResult1.columns.containsKey(columnAname));
        handler.deleteAllTs(tableAname, rowAname, columnBname, time1, null);
        handler.deleteAllRowTs(tableAname, rowBname, time2, null);
        int size = handler.getVerTs(tableAname, rowAname, columnBname, time1, 3, null).size();
        Assert.assertEquals((long)0L, (long)size);
        size = handler.getVerTs(tableAname, rowAname, columnBname, time2, 3, null).size();
        Assert.assertEquals((long)1L, (long)size);
        Assert.assertEquals((Object)((TCell)handler.get((ByteBuffer)TestThriftServer.tableAname, (ByteBuffer)TestThriftServer.rowAname, (ByteBuffer)TestThriftServer.columnBname, null).get((int)0)).value, (Object)valueCname);
        Assert.assertEquals((long)0L, (long)handler.getRow(tableAname, rowBname, null).size());
        handler.disableTable(tableAname);
        handler.deleteTable(tableAname);
    }

    public void doTestTableScanners() throws Exception {
        ThriftServerRunner.HBaseHandler handler = new ThriftServerRunner.HBaseHandler(UTIL.getConfiguration());
        handler.createTable(tableAname, TestThriftServer.getColumnDescriptors());
        long time1 = System.currentTimeMillis();
        handler.mutateRowTs(tableAname, rowAname, TestThriftServer.getMutations(), time1, null);
        Thread.sleep(1000L);
        long time2 = System.currentTimeMillis();
        handler.mutateRowsTs(tableAname, TestThriftServer.getBatchMutations(), time2, null);
        ++time1;
        int scanner1 = handler.scannerOpen(tableAname, rowAname, this.getColumnList(true, true), null);
        TRowResult rowResult1a = (TRowResult)handler.scannerGet(scanner1).get(0);
        Assert.assertEquals((Object)rowResult1a.row, (Object)rowAname);
        Assert.assertEquals((long)rowResult1a.columns.size(), (long)1L);
        Assert.assertEquals((Object)((TCell)rowResult1a.columns.get((Object)TestThriftServer.columnBname)).value, (Object)valueCname);
        TRowResult rowResult1b = (TRowResult)handler.scannerGet(scanner1).get(0);
        Assert.assertEquals((Object)rowResult1b.row, (Object)rowBname);
        Assert.assertEquals((long)rowResult1b.columns.size(), (long)2L);
        Assert.assertEquals((Object)((TCell)rowResult1b.columns.get((Object)TestThriftServer.columnAname)).value, (Object)valueCname);
        Assert.assertEquals((Object)((TCell)rowResult1b.columns.get((Object)TestThriftServer.columnBname)).value, (Object)valueDname);
        this.closeScanner(scanner1, handler);
        int scanner2 = handler.scannerOpenTs(tableAname, rowAname, this.getColumnList(true, true), time1, null);
        TRowResult rowResult2a = (TRowResult)handler.scannerGet(scanner2).get(0);
        Assert.assertEquals((long)rowResult2a.columns.size(), (long)1L);
        Assert.assertEquals((Object)((TCell)rowResult2a.columns.get((Object)TestThriftServer.columnBname)).value, (Object)valueBname);
        this.closeScanner(scanner2, handler);
        int scanner3 = handler.scannerOpenWithStop(tableAname, rowAname, rowBname, this.getColumnList(true, false), null);
        this.closeScanner(scanner3, handler);
        int scanner4 = handler.scannerOpenWithStopTs(tableAname, rowAname, rowBname, this.getColumnList(false, true), time1, null);
        TRowResult rowResult4a = (TRowResult)handler.scannerGet(scanner4).get(0);
        Assert.assertEquals((long)rowResult4a.columns.size(), (long)1L);
        Assert.assertEquals((Object)((TCell)rowResult4a.columns.get((Object)TestThriftServer.columnBname)).value, (Object)valueBname);
        handler.disableTable(tableAname);
        handler.deleteTable(tableAname);
    }

    public void doTestGetTableRegions() throws Exception {
        ThriftServerRunner.HBaseHandler handler = new ThriftServerRunner.HBaseHandler(UTIL.getConfiguration());
        TestThriftServer.doTestGetTableRegions((Hbase.Iface)handler);
    }

    public static void doTestGetTableRegions(Hbase.Iface handler) throws Exception {
        Assert.assertEquals((long)handler.getTableNames().size(), (long)0L);
        handler.createTable(tableAname, TestThriftServer.getColumnDescriptors());
        Assert.assertEquals((long)handler.getTableNames().size(), (long)1L);
        List regions = handler.getTableRegions(tableAname);
        int regionCount = regions.size();
        Assert.assertEquals((String)("empty table should have only 1 region, but found " + regionCount), (long)regionCount, (long)1L);
        LOG.info((Object)("Region found:" + regions.get(0)));
        handler.disableTable(tableAname);
        handler.deleteTable(tableAname);
        regionCount = handler.getTableRegions(tableAname).size();
        Assert.assertEquals((String)("non-existing table should have 0 region, but found " + regionCount), (long)regionCount, (long)0L);
    }

    public void doTestFilterRegistration() throws Exception {
        Configuration conf = UTIL.getConfiguration();
        conf.set("hbase.thrift.filters", "MyFilter:filterclass");
        ThriftServerRunner.registerFilters((Configuration)conf);
        Map registeredFilters = ParseFilter.getAllFilters();
        Assert.assertEquals((Object)"filterclass", registeredFilters.get("MyFilter"));
    }

    private static List<ColumnDescriptor> getColumnDescriptors() {
        ArrayList<ColumnDescriptor> cDescriptors = new ArrayList<ColumnDescriptor>();
        ColumnDescriptor cDescA = new ColumnDescriptor();
        cDescA.name = columnAname;
        cDescriptors.add(cDescA);
        ColumnDescriptor cDescB = new ColumnDescriptor(columnBname, 2, "NONE", false, "NONE", 0, 0, false, -1);
        cDescriptors.add(cDescB);
        return cDescriptors;
    }

    private List<ByteBuffer> getColumnList(boolean includeA, boolean includeB) {
        ArrayList<ByteBuffer> columnList = new ArrayList<ByteBuffer>();
        if (includeA) {
            columnList.add(columnAname);
        }
        if (includeB) {
            columnList.add(columnBname);
        }
        return columnList;
    }

    private static List<Mutation> getMutations() {
        ArrayList<Mutation> mutations = new ArrayList<Mutation>();
        mutations.add(new Mutation(false, columnAname, valueAname, true));
        mutations.add(new Mutation(false, columnBname, valueBname, true));
        return mutations;
    }

    private static List<BatchMutation> getBatchMutations() {
        ArrayList<BatchMutation> batchMutations = new ArrayList<BatchMutation>();
        ArrayList<Mutation> rowAmutations = new ArrayList<Mutation>();
        rowAmutations.add(new Mutation(true, columnAname, null, true));
        batchMutations.add(new BatchMutation(rowAname, rowAmutations));
        rowAmutations = new ArrayList();
        rowAmutations.add(new Mutation(false, columnBname, valueCname, true));
        batchMutations.add(new BatchMutation(rowAname, rowAmutations));
        ArrayList<Mutation> rowBmutations = new ArrayList<Mutation>();
        rowBmutations.add(new Mutation(false, columnAname, valueCname, true));
        rowBmutations.add(new Mutation(false, columnBname, valueDname, true));
        batchMutations.add(new BatchMutation(rowBname, rowBmutations));
        return batchMutations;
    }

    private void closeScanner(int scannerId, ThriftServerRunner.HBaseHandler handler) throws Exception {
        handler.scannerGet(scannerId);
        handler.scannerClose(scannerId);
    }
}

