/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.util.Random;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.MD5Hash;

public class LoadTestKVGenerator {
    private Random randomForValueSize = new Random();
    private final int minValueSize;
    private final int maxValueSize;

    public LoadTestKVGenerator(int minValueSize, int maxValueSize) {
        if (minValueSize <= 0 || maxValueSize <= 0) {
            throw new IllegalArgumentException("Invalid min/max value sizes: " + minValueSize + ", " + maxValueSize);
        }
        this.minValueSize = minValueSize;
        this.maxValueSize = maxValueSize;
    }

    public static boolean verify(String rowKey, String qual, byte[] value) {
        byte[] expectedData = LoadTestKVGenerator.getValueForRowColumn(rowKey, qual, value.length);
        return Bytes.equals((byte[])expectedData, (byte[])value);
    }

    public static String md5PrefixedKey(long key) {
        String stringKey = Long.toString(key);
        String md5hash = MD5Hash.getMD5AsHex((byte[])Bytes.toBytes((String)stringKey));
        return md5hash + "-" + stringKey;
    }

    public byte[] generateRandomSizeValue(long key, String qual) {
        String rowKey = LoadTestKVGenerator.md5PrefixedKey(key);
        int dataSize = this.minValueSize + this.randomForValueSize.nextInt(Math.abs(this.maxValueSize - this.minValueSize));
        return LoadTestKVGenerator.getValueForRowColumn(rowKey, qual, dataSize);
    }

    private static byte[] getValueForRowColumn(String rowKey, String qual, int dataSize) {
        Random seededRandom = new Random(rowKey.hashCode() + qual.hashCode() + dataSize);
        byte[] randomBytes = new byte[dataSize];
        seededRandom.nextBytes(randomBytes);
        return randomBytes;
    }
}

