/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.hfile.Compression;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.util.AbstractHBaseTool;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.MultiThreadedReader;
import org.apache.hadoop.hbase.util.MultiThreadedWriter;

public class LoadTestTool
extends AbstractHBaseTool {
    private static final Log LOG = LogFactory.getLog(LoadTestTool.class);
    private byte[] tableName;
    private static final String DEFAULT_TABLE_NAME = "cluster_test";
    static byte[] COLUMN_FAMILY = Bytes.toBytes((String)"test_cf");
    static final byte[][] COLUMN_FAMILIES = new byte[][]{COLUMN_FAMILY};
    private static final int DEFAULT_NUM_THREADS = 20;
    private static final String OPT_USAGE_LOAD = "<avg_cols_per_key>:<avg_data_size>[:<#threads=20>]";
    private static final String OPT_USAGE_READ = "<verify_percent>[:<#threads=20>]";
    private static final String OPT_USAGE_BLOOM = "Bloom filter type, one of " + Arrays.toString(StoreFile.BloomType.values());
    private static final String OPT_USAGE_COMPRESSION = "Compression type, one of " + Arrays.toString(Compression.Algorithm.values());
    public static final String OPT_DATA_BLOCK_ENCODING_USAGE = "Encoding algorithm (e.g. prefix compression) to use for data blocks in the test column family, one of " + Arrays.toString(DataBlockEncoding.values()) + ".";
    private static final String OPT_BLOOM = "bloom";
    private static final String OPT_COMPRESSION = "compression";
    public static final String OPT_DATA_BLOCK_ENCODING = "DATA_BLOCK_ENCODING".toLowerCase();
    public static final String OPT_ENCODE_IN_CACHE_ONLY = "encode_in_cache_only";
    public static final String OPT_ENCODE_IN_CACHE_ONLY_USAGE = "If this is specified, data blocks will only be encoded in block cache but not on disk";
    private static final String OPT_KEY_WINDOW = "key_window";
    private static final String OPT_WRITE = "write";
    private static final String OPT_MAX_READ_ERRORS = "max_read_errors";
    private static final String OPT_MULTIPUT = "multiput";
    private static final String OPT_NUM_KEYS = "num_keys";
    private static final String OPT_READ = "read";
    private static final String OPT_START_KEY = "start_key";
    private static final String OPT_TABLE_NAME = "tn";
    private static final String OPT_ZK_QUORUM = "zk";
    private static final String OPT_SKIP_INIT = "skip_init";
    private static final String OPT_INIT_ONLY = "init_only";
    private static final long DEFAULT_START_KEY = 0L;
    private CommandLine cmd;
    private MultiThreadedWriter writerThreads = null;
    private MultiThreadedReader readerThreads = null;
    private long startKey;
    private long endKey;
    private boolean isWrite;
    private boolean isRead;
    private DataBlockEncoding dataBlockEncodingAlgo;
    private boolean encodeInCacheOnly;
    private Compression.Algorithm compressAlgo;
    private StoreFile.BloomType bloomType;
    private int numWriterThreads = 20;
    private long minColsPerKey;
    private long maxColsPerKey;
    private int minColDataSize;
    private int maxColDataSize;
    private boolean isMultiPut;
    private int numReaderThreads = 20;
    private int keyWindow = 0;
    private int maxReadErrors = 10;
    private int verifyPercent;
    private boolean isSkipInit = false;
    private boolean isInitOnly = false;

    private String[] splitColonSeparated(String option, int minNumCols, int maxNumCols) {
        String optVal = this.cmd.getOptionValue(option);
        String[] cols = optVal.split(":");
        if (cols.length < minNumCols || cols.length > maxNumCols) {
            throw new IllegalArgumentException("Expected at least " + minNumCols + " columns but no more than " + maxNumCols + " in the colon-separated value '" + optVal + "' of the " + "-" + option + " option");
        }
        return cols;
    }

    private int getNumThreads(String numThreadsStr) {
        return LoadTestTool.parseInt((String)numThreadsStr, (int)1, (int)Short.MAX_VALUE);
    }

    private void applyColumnFamilyOptions(byte[] tableName, byte[][] columnFamilies) throws IOException {
        HBaseAdmin admin = new HBaseAdmin(this.conf);
        HTableDescriptor tableDesc = admin.getTableDescriptor(tableName);
        LOG.info((Object)("Disabling table " + Bytes.toString((byte[])tableName)));
        admin.disableTable(tableName);
        for (byte[] cf : columnFamilies) {
            boolean isNewCf;
            HColumnDescriptor columnDesc = tableDesc.getFamily(cf);
            boolean bl = isNewCf = columnDesc == null;
            if (isNewCf) {
                columnDesc = new HColumnDescriptor(cf);
            }
            if (this.bloomType != null) {
                columnDesc.setBloomFilterType(this.bloomType);
            }
            if (this.compressAlgo != null) {
                columnDesc.setCompressionType(this.compressAlgo);
            }
            if (this.dataBlockEncodingAlgo != null) {
                columnDesc.setDataBlockEncoding(this.dataBlockEncodingAlgo);
                columnDesc.setEncodeOnDisk(!this.encodeInCacheOnly);
            }
            if (isNewCf) {
                admin.addColumn(tableName, columnDesc);
                continue;
            }
            admin.modifyColumn(tableName, columnDesc);
        }
        LOG.info((Object)("Enabling table " + Bytes.toString((byte[])tableName)));
        admin.enableTable(tableName);
    }

    protected void addOptions() {
        this.addOptWithArg(OPT_ZK_QUORUM, "ZK quorum as comma-separated host names without port numbers");
        this.addOptWithArg(OPT_TABLE_NAME, "The name of the table to read or write");
        this.addOptWithArg(OPT_WRITE, OPT_USAGE_LOAD);
        this.addOptWithArg(OPT_READ, OPT_USAGE_READ);
        this.addOptNoArg(OPT_INIT_ONLY, "Initialize the test table only, don't do any loading");
        this.addOptWithArg(OPT_BLOOM, OPT_USAGE_BLOOM);
        this.addOptWithArg(OPT_COMPRESSION, OPT_USAGE_COMPRESSION);
        this.addOptWithArg(OPT_DATA_BLOCK_ENCODING, OPT_DATA_BLOCK_ENCODING_USAGE);
        this.addOptWithArg(OPT_MAX_READ_ERRORS, "The maximum number of read errors to tolerate before terminating all reader threads. The default is 10.");
        this.addOptWithArg(OPT_KEY_WINDOW, "The 'key window' to maintain between reads and writes for concurrent write/read workload. The default is 0.");
        this.addOptNoArg(OPT_MULTIPUT, "Whether to use multi-puts as opposed to separate puts for every column in a row");
        this.addOptNoArg(OPT_ENCODE_IN_CACHE_ONLY, OPT_ENCODE_IN_CACHE_ONLY_USAGE);
        this.addOptWithArg(OPT_NUM_KEYS, "The number of keys to read/write");
        this.addOptWithArg(OPT_START_KEY, "The first key to read/write (a 0-based index). The default value is 0.");
        this.addOptNoArg(OPT_SKIP_INIT, "Skip the initialization; assume test table already exists");
    }

    protected void processOptions(CommandLine cmd) {
        int colIndex;
        this.cmd = cmd;
        this.tableName = Bytes.toBytes((String)cmd.getOptionValue(OPT_TABLE_NAME, DEFAULT_TABLE_NAME));
        this.isWrite = cmd.hasOption(OPT_WRITE);
        this.isRead = cmd.hasOption(OPT_READ);
        this.isInitOnly = cmd.hasOption(OPT_INIT_ONLY);
        if (!(this.isWrite || this.isRead || this.isInitOnly)) {
            throw new IllegalArgumentException("Either -write or -read has to be specified");
        }
        if (this.isInitOnly && (this.isRead || this.isWrite)) {
            throw new IllegalArgumentException("init_only cannot be specified with either -write or -read");
        }
        if (!this.isInitOnly) {
            if (!cmd.hasOption(OPT_NUM_KEYS)) {
                throw new IllegalArgumentException("num_keys must be specified in read or write mode");
            }
            this.startKey = LoadTestTool.parseLong((String)cmd.getOptionValue(OPT_START_KEY, String.valueOf(0L)), (long)0L, (long)Long.MAX_VALUE);
            long numKeys = LoadTestTool.parseLong((String)cmd.getOptionValue(OPT_NUM_KEYS), (long)1L, (long)(Long.MAX_VALUE - this.startKey));
            this.endKey = this.startKey + numKeys;
            this.isSkipInit = cmd.hasOption(OPT_SKIP_INIT);
            System.out.println("Key range: [" + this.startKey + ".." + (this.endKey - 1L) + "]");
        }
        this.encodeInCacheOnly = cmd.hasOption(OPT_ENCODE_IN_CACHE_ONLY);
        this.parseColumnFamilyOptions(cmd);
        if (this.isWrite) {
            String[] writeOpts = this.splitColonSeparated(OPT_WRITE, 2, 3);
            colIndex = 0;
            this.minColsPerKey = 1L;
            this.maxColsPerKey = 2L * Long.parseLong(writeOpts[colIndex++]);
            int avgColDataSize = LoadTestTool.parseInt((String)writeOpts[colIndex++], (int)1, (int)Integer.MAX_VALUE);
            this.minColDataSize = avgColDataSize / 2;
            this.maxColDataSize = avgColDataSize * 3 / 2;
            if (colIndex < writeOpts.length) {
                this.numWriterThreads = this.getNumThreads(writeOpts[colIndex++]);
            }
            this.isMultiPut = cmd.hasOption(OPT_MULTIPUT);
            System.out.println("Multi-puts: " + this.isMultiPut);
            System.out.println("Columns per key: " + this.minColsPerKey + ".." + this.maxColsPerKey);
            System.out.println("Data size per column: " + this.minColDataSize + ".." + this.maxColDataSize);
        }
        if (this.isRead) {
            String[] readOpts = this.splitColonSeparated(OPT_READ, 1, 2);
            colIndex = 0;
            this.verifyPercent = LoadTestTool.parseInt((String)readOpts[colIndex++], (int)0, (int)100);
            if (colIndex < readOpts.length) {
                this.numReaderThreads = this.getNumThreads(readOpts[colIndex++]);
            }
            if (cmd.hasOption(OPT_MAX_READ_ERRORS)) {
                this.maxReadErrors = LoadTestTool.parseInt((String)cmd.getOptionValue(OPT_MAX_READ_ERRORS), (int)0, (int)Integer.MAX_VALUE);
            }
            if (cmd.hasOption(OPT_KEY_WINDOW)) {
                this.keyWindow = LoadTestTool.parseInt((String)cmd.getOptionValue(OPT_KEY_WINDOW), (int)0, (int)Integer.MAX_VALUE);
            }
            System.out.println("Percent of keys to verify: " + this.verifyPercent);
            System.out.println("Reader threads: " + this.numReaderThreads);
        }
    }

    private void parseColumnFamilyOptions(CommandLine cmd) {
        String dataBlockEncodingStr = cmd.getOptionValue(OPT_DATA_BLOCK_ENCODING);
        DataBlockEncoding dataBlockEncoding = this.dataBlockEncodingAlgo = dataBlockEncodingStr == null ? null : DataBlockEncoding.valueOf((String)dataBlockEncodingStr);
        if (this.dataBlockEncodingAlgo == DataBlockEncoding.NONE && this.encodeInCacheOnly) {
            throw new IllegalArgumentException("-encode_in_cache_only does not make sense when data block encoding is not used");
        }
        String compressStr = cmd.getOptionValue(OPT_COMPRESSION);
        this.compressAlgo = compressStr == null ? Compression.Algorithm.NONE : Compression.Algorithm.valueOf((String)compressStr);
        String bloomStr = cmd.getOptionValue(OPT_BLOOM);
        this.bloomType = bloomStr == null ? null : StoreFile.BloomType.valueOf((String)bloomStr);
    }

    public void initTestTable() throws IOException {
        HBaseTestingUtility.createPreSplitLoadTestTable(this.conf, this.tableName, COLUMN_FAMILY, this.compressAlgo, this.dataBlockEncodingAlgo);
        this.applyColumnFamilyOptions(this.tableName, COLUMN_FAMILIES);
    }

    protected int doWork() throws IOException {
        if (this.cmd.hasOption(OPT_ZK_QUORUM)) {
            this.conf.set("hbase.zookeeper.quorum", this.cmd.getOptionValue(OPT_ZK_QUORUM));
        }
        if (this.isInitOnly) {
            LOG.info((Object)"Initializing only; no reads or writes");
            this.initTestTable();
            return 0;
        }
        if (!this.isSkipInit) {
            this.initTestTable();
        }
        if (this.isWrite) {
            this.writerThreads = new MultiThreadedWriter(this.conf, this.tableName, COLUMN_FAMILY);
            this.writerThreads.setMultiPut(this.isMultiPut);
            this.writerThreads.setColumnsPerKey(this.minColsPerKey, this.maxColsPerKey);
            this.writerThreads.setDataSize(this.minColDataSize, this.maxColDataSize);
        }
        if (this.isRead) {
            this.readerThreads = new MultiThreadedReader(this.conf, this.tableName, COLUMN_FAMILY, this.verifyPercent);
            this.readerThreads.setMaxErrors(this.maxReadErrors);
            this.readerThreads.setKeyWindow(this.keyWindow);
        }
        if (this.isRead && this.isWrite) {
            LOG.info((Object)"Concurrent read/write workload: making readers aware of the write point");
            this.readerThreads.linkToWriter(this.writerThreads);
        }
        if (this.isWrite) {
            System.out.println("Starting to write data...");
            this.writerThreads.start(this.startKey, this.endKey, this.numWriterThreads);
        }
        if (this.isRead) {
            System.out.println("Starting to read data...");
            this.readerThreads.start(this.startKey, this.endKey, this.numReaderThreads);
        }
        if (this.isWrite) {
            this.writerThreads.waitForFinish();
        }
        if (this.isRead) {
            this.readerThreads.waitForFinish();
        }
        boolean success = true;
        if (this.isWrite) {
            boolean bl = success = success && this.writerThreads.getNumWriteFailures() == 0;
        }
        if (this.isRead) {
            success = success && this.readerThreads.getNumReadErrors() == 0L && this.readerThreads.getNumReadFailures() == 0L;
        }
        return success ? 0 : 1;
    }

    public static void main(String[] args) {
        new LoadTestTool().doStaticMain(args);
    }
}

