/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.LoadTestKVGenerator;
import org.apache.hadoop.hbase.util.MultiThreadedAction;
import org.apache.hadoop.hbase.util.MultiThreadedWriter;
import org.apache.hadoop.hbase.util.Threads;

public class MultiThreadedReader
extends MultiThreadedAction {
    private static final Log LOG = LogFactory.getLog(MultiThreadedReader.class);
    private Set<HBaseReaderThread> readers = new HashSet<HBaseReaderThread>();
    private final double verifyPercent;
    private volatile boolean aborted;
    private MultiThreadedWriter writer = null;
    private final AtomicLong numUniqueKeysVerified = new AtomicLong();
    public static final int DEFAULT_MAX_ERRORS = 10;
    public static final int DEFAULT_KEY_WINDOW = 0;
    protected AtomicLong numKeysVerified = new AtomicLong(0L);
    private AtomicLong numReadErrors = new AtomicLong(0L);
    private AtomicLong numReadFailures = new AtomicLong(0L);
    private int maxErrors = 10;
    private int keyWindow = 0;

    public MultiThreadedReader(Configuration conf, byte[] tableName, byte[] columnFamily, double verifyPercent) {
        super(conf, tableName, columnFamily, "R");
        this.verifyPercent = verifyPercent;
    }

    public void linkToWriter(MultiThreadedWriter writer) {
        this.writer = writer;
        writer.setTrackInsertedKeys(true);
    }

    public void setMaxErrors(int maxErrors) {
        this.maxErrors = maxErrors;
    }

    public void setKeyWindow(int keyWindow) {
        this.keyWindow = keyWindow;
    }

    @Override
    public void start(long startKey, long endKey, int numThreads) throws IOException {
        super.start(startKey, endKey, numThreads);
        if (this.verbose) {
            LOG.debug((Object)("Reading keys [" + startKey + ", " + endKey + ")"));
        }
        for (int i = 0; i < numThreads; ++i) {
            HBaseReaderThread reader = new HBaseReaderThread(i);
            this.readers.add(reader);
        }
        this.startThreads(this.readers);
    }

    public long getNumReadFailures() {
        return this.numReadFailures.get();
    }

    public long getNumReadErrors() {
        return this.numReadErrors.get();
    }

    public long getNumKeysVerified() {
        return this.numKeysVerified.get();
    }

    public long getNumUniqueKeysVerified() {
        return this.numUniqueKeysVerified.get();
    }

    @Override
    protected String progressInfo() {
        StringBuilder sb = new StringBuilder();
        MultiThreadedReader.appendToStatus(sb, "verified", this.numKeysVerified.get());
        MultiThreadedReader.appendToStatus(sb, "READ FAILURES", this.numReadFailures.get());
        MultiThreadedReader.appendToStatus(sb, "READ ERRORS", this.numReadErrors.get());
        return sb.toString();
    }

    public class HBaseReaderThread
    extends Thread {
        private final int readerId;
        private final HTable table;
        private final Random random = new Random();
        private long curKey;
        private long startTimeMs;
        private boolean readingRandomKey;

        public HBaseReaderThread(int readerId) throws IOException {
            this.readerId = readerId;
            this.table = new HTable(MultiThreadedReader.this.conf, MultiThreadedReader.this.tableName);
            this.setName(this.getClass().getSimpleName() + "_" + readerId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.runReader();
            }
            finally {
                try {
                    this.table.close();
                }
                catch (IOException e) {
                    LOG.error((Object)"Error closing table", (Throwable)e);
                }
                MultiThreadedReader.this.numThreadsWorking.decrementAndGet();
            }
        }

        private void runReader() {
            if (MultiThreadedReader.this.verbose) {
                LOG.info((Object)("Started thread #" + this.readerId + " for reads..."));
            }
            this.startTimeMs = System.currentTimeMillis();
            this.curKey = MultiThreadedReader.this.startKey;
            while (this.curKey < MultiThreadedReader.this.endKey && !MultiThreadedReader.this.aborted) {
                long k = this.getNextKeyToRead();
                if (k < MultiThreadedReader.this.startKey || k >= MultiThreadedReader.this.endKey) {
                    MultiThreadedReader.this.numReadErrors.incrementAndGet();
                    throw new AssertionError((Object)("Load tester logic error: proposed key to read " + k + " is out of range (startKey=" + MultiThreadedReader.this.startKey + ", endKey=" + MultiThreadedReader.this.endKey + ")"));
                }
                if (k % (long)MultiThreadedReader.this.numThreads != (long)this.readerId || MultiThreadedReader.this.writer != null && MultiThreadedReader.this.writer.failedToWriteKey(k)) continue;
                this.readKey(k);
                if (k != this.curKey - 1L || this.readingRandomKey) continue;
                MultiThreadedReader.this.numUniqueKeysVerified.incrementAndGet();
            }
        }

        private long maxKeyWeCanRead() {
            long insertedUpToKey = MultiThreadedReader.this.writer.insertedUpToKey();
            if (insertedUpToKey >= MultiThreadedReader.this.endKey - 1L) {
                return MultiThreadedReader.this.endKey - 1L;
            }
            return Math.min(MultiThreadedReader.this.endKey - 1L, MultiThreadedReader.this.writer.insertedUpToKey() - (long)MultiThreadedReader.this.keyWindow);
        }

        private long getNextKeyToRead() {
            long maxKeyToRead;
            this.readingRandomKey = false;
            if (MultiThreadedReader.this.writer == null || this.curKey <= this.maxKeyWeCanRead()) {
                return this.curKey++;
            }
            while ((maxKeyToRead = this.maxKeyWeCanRead()) < MultiThreadedReader.this.startKey) {
                Threads.sleepWithoutInterrupt((long)50L);
            }
            if (this.curKey <= maxKeyToRead) {
                return this.curKey++;
            }
            this.readingRandomKey = true;
            return MultiThreadedReader.this.startKey + Math.abs(this.random.nextLong()) % (maxKeyToRead - MultiThreadedReader.this.startKey + 1L);
        }

        private Get readKey(long keyToRead) {
            Get get = new Get(LoadTestKVGenerator.md5PrefixedKey(keyToRead).getBytes());
            get.addFamily(MultiThreadedReader.this.columnFamily);
            try {
                if (MultiThreadedReader.this.verbose) {
                    LOG.info((Object)("[" + this.readerId + "] " + "Querying key " + keyToRead + ", cf " + Bytes.toStringBinary((byte[])MultiThreadedReader.this.columnFamily)));
                }
                this.queryKey(get, (double)this.random.nextInt(100) < MultiThreadedReader.this.verifyPercent);
            }
            catch (IOException e) {
                MultiThreadedReader.this.numReadFailures.addAndGet(1L);
                LOG.debug((Object)("[" + this.readerId + "] FAILED read, key = " + keyToRead + "" + ", time from start: " + (System.currentTimeMillis() - this.startTimeMs) + " ms"));
            }
            return get;
        }

        public void queryKey(Get get, boolean verify) throws IOException {
            String rowKey = Bytes.toString((byte[])get.getRow());
            long start = System.currentTimeMillis();
            Result result = this.table.get(get);
            MultiThreadedReader.this.totalOpTimeMs.addAndGet(System.currentTimeMillis() - start);
            MultiThreadedReader.this.numKeys.addAndGet(1L);
            if (result.isEmpty()) {
                HRegionLocation hloc = this.table.getRegionLocation(Bytes.toBytes((String)rowKey));
                LOG.info((Object)("Key = " + rowKey + ", RegionServer: " + hloc.getHostname()));
                MultiThreadedReader.this.numReadErrors.addAndGet(1L);
                LOG.error((Object)("No data returned, tried to get actions for key = " + rowKey + (MultiThreadedReader.this.writer == null ? "" : ", keys inserted by writer: " + ((MultiThreadedReader)MultiThreadedReader.this).writer.numKeys.get() + ")")));
                if (MultiThreadedReader.this.numReadErrors.get() > (long)MultiThreadedReader.this.maxErrors) {
                    LOG.error((Object)("Aborting readers -- found more than " + MultiThreadedReader.this.maxErrors + " errors\n"));
                    MultiThreadedReader.this.aborted = true;
                }
            }
            if (result.getFamilyMap(MultiThreadedReader.this.columnFamily) != null) {
                MultiThreadedReader.this.numCols.addAndGet(result.getFamilyMap(MultiThreadedReader.this.columnFamily).size());
                if (verify) {
                    List keyValues = result.list();
                    for (KeyValue kv : keyValues) {
                        String qual = new String(kv.getQualifier());
                        if (LoadTestKVGenerator.verify(rowKey, qual, kv.getValue())) continue;
                        MultiThreadedReader.this.numReadErrors.addAndGet(1L);
                        LOG.error((Object)("Error checking data for key = " + rowKey + ", actionId = " + qual));
                    }
                    MultiThreadedReader.this.numKeysVerified.addAndGet(1L);
                }
            }
        }
    }
}

