/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.util.DefaultEnvironmentEdge;
import org.apache.hadoop.hbase.util.EnvironmentEdge;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.IncrementingEnvironmentEdge;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={MediumTests.class})
public class TestEnvironmentEdgeManager {
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    @Test
    public void testManageSingleton() {
        EnvironmentEdge edge = EnvironmentEdgeManager.getDelegate();
        Assert.assertNotNull((Object)edge);
        Assert.assertTrue((boolean)(edge instanceof DefaultEnvironmentEdge));
        EnvironmentEdgeManager.reset();
        EnvironmentEdge edge2 = EnvironmentEdgeManager.getDelegate();
        Assert.assertFalse((edge == edge2 ? 1 : 0) != 0);
        IncrementingEnvironmentEdge newEdge = new IncrementingEnvironmentEdge();
        EnvironmentEdgeManager.injectEdge((EnvironmentEdge)newEdge);
        Assert.assertEquals((Object)newEdge, (Object)EnvironmentEdgeManager.getDelegate());
        EnvironmentEdgeManager.injectEdge(null);
        EnvironmentEdge nullResult = EnvironmentEdgeManager.getDelegate();
        Assert.assertTrue((boolean)(nullResult instanceof DefaultEnvironmentEdge));
    }

    @Test
    public void testCurrentTimeInMillis() {
        EnvironmentEdge mock = (EnvironmentEdge)Mockito.mock(EnvironmentEdge.class);
        EnvironmentEdgeManager.injectEdge((EnvironmentEdge)mock);
        long expectation = 3456L;
        Mockito.when((Object)mock.currentTimeMillis()).thenReturn((Object)expectation);
        long result = EnvironmentEdgeManager.currentTimeMillis();
        ((EnvironmentEdge)Mockito.verify((Object)mock)).currentTimeMillis();
        Assert.assertEquals((long)expectation, (long)result);
    }
}

