/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.HFileArchiveUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={SmallTests.class})
public class TestHFileArchiveUtil {
    @Test
    public void testGetTableArchivePath() {
        Assert.assertNotNull((Object)HFileArchiveUtil.getTableArchivePath((Path)new Path("table")));
        Assert.assertNotNull((Object)HFileArchiveUtil.getTableArchivePath((Path)new Path("root", new Path("table"))));
    }

    @Test
    public void testGetArchivePath() throws Exception {
        Configuration conf = new Configuration();
        FSUtils.setRootDir((Configuration)conf, (Path)new Path("root"));
        Assert.assertNotNull((Object)HFileArchiveUtil.getArchivePath((Configuration)conf));
    }

    @Test
    public void testRegionArchiveDir() {
        Configuration conf = null;
        Path tableDir = new Path("table");
        Path regionDir = new Path("region");
        Assert.assertNotNull((Object)HFileArchiveUtil.getRegionArchiveDir(conf, (Path)tableDir, (Path)regionDir));
    }

    @Test
    public void testGetStoreArchivePath() {
        byte[] family = Bytes.toBytes((String)"Family");
        Path tabledir = new Path("table");
        HRegionInfo region = new HRegionInfo(Bytes.toBytes((String)"table"));
        Configuration conf = null;
        Assert.assertNotNull((Object)HFileArchiveUtil.getStoreArchivePath(conf, (HRegionInfo)region, (Path)tabledir, (byte[])family));
        conf = new Configuration();
        Assert.assertNotNull((Object)HFileArchiveUtil.getStoreArchivePath((Configuration)conf, (HRegionInfo)region, (Path)tabledir, (byte[])family));
        HRegion mockRegion = (HRegion)Mockito.mock(HRegion.class);
        Mockito.when((Object)mockRegion.getRegionInfo()).thenReturn((Object)region);
        Mockito.when((Object)mockRegion.getTableDir()).thenReturn((Object)tabledir);
        Assert.assertNotNull((Object)HFileArchiveUtil.getStoreArchivePath(null, (HRegion)mockRegion, (byte[])family));
        conf = new Configuration();
        Assert.assertNotNull((Object)HFileArchiveUtil.getStoreArchivePath((Configuration)conf, (HRegion)mockRegion, (byte[])family));
    }
}

