/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.ResourceCheckerJUnitRule;
import org.apache.hadoop.hbase.zookeeper.TestZooKeeperNodeTracker;
import org.apache.hadoop.hbase.zookeeper.ZKTable;
import org.apache.hadoop.hbase.zookeeper.ZKTableReadOnly;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestZKTableReadOnly {
    private static final Log LOG = LogFactory.getLog(TestZooKeeperNodeTracker.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    Abortable abortable = new Abortable(){

        public void abort(String why, Throwable e) {
            LOG.info((Object)why, e);
        }

        public boolean isAborted() {
            return false;
        }
    };
    @Rule
    public ResourceCheckerJUnitRule cu = new ResourceCheckerJUnitRule();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniZKCluster();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniZKCluster();
    }

    private boolean enableAndCheckEnabled(ZooKeeperWatcher zkw, String tableName) throws Exception {
        ZKTable zkt = new ZKTable(zkw);
        zkt.setEnabledTable(tableName);
        return ZKTableReadOnly.isEnabledTable((ZooKeeperWatcher)zkw, (String)tableName);
    }

    private void runClientCompatiblityWith92ZNodeTest(String tableName, Configuration conf) throws Exception {
        ZooKeeperWatcher zkw = new ZooKeeperWatcher(conf, tableName, this.abortable, true);
        Assert.assertTrue((boolean)this.enableAndCheckEnabled(zkw, tableName));
    }

    @Test
    public void testClientCompatibilityWith92ZNode() throws Exception {
        String tableName = "testClientCompatibilityWith92ZNode";
        Configuration conf = HBaseConfiguration.create((Configuration)TEST_UTIL.getConfiguration());
        String znode92 = conf.get("zookeeper.znode.masterTableEnableDisable92", "table92");
        conf.set("zookeeper.znode.clientTableEnableDisable", znode92);
        this.runClientCompatiblityWith92ZNodeTest(tableName, conf);
        tableName = "testClientCompatibilityWith92ZNodeUseMulti";
        conf.setBoolean("hbase.zookeeper.useMulti", true);
        this.runClientCompatiblityWith92ZNodeTest(tableName, conf);
    }

    private void runClientCompatibilityWith94ZNodeTest(String tableName, Configuration conf) throws Exception {
        ZooKeeperWatcher zkw = new ZooKeeperWatcher(TEST_UTIL.getConfiguration(), tableName, this.abortable, true);
        Assert.assertTrue((boolean)this.enableAndCheckEnabled(zkw, tableName));
    }

    @Test
    public void testClientCompatibilityWith94ZNode() throws Exception {
        String tableName = "testClientCompatibilityWith94ZNode";
        this.runClientCompatibilityWith94ZNodeTest(tableName, TEST_UTIL.getConfiguration());
        tableName = "testClientCompatiblityWith94ZNodeUseMulti";
        Configuration conf = HBaseConfiguration.create((Configuration)TEST_UTIL.getConfiguration());
        conf.setBoolean("hbase.zookeeper.useMulti", true);
        this.runClientCompatibilityWith94ZNodeTest(tableName, conf);
    }
}

