/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.qdox.model;

import com.thoughtworks.qdox.JavaClassContext;
import com.thoughtworks.qdox.model.AbstractBaseJavaEntity;
import com.thoughtworks.qdox.model.AbstractJavaEntity;
import com.thoughtworks.qdox.model.Annotation;
import com.thoughtworks.qdox.model.ClassLibrary;
import com.thoughtworks.qdox.model.DefaultDocletTagFactory;
import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.DocletTagFactory;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaClassParent;
import com.thoughtworks.qdox.model.JavaField;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaPackage;
import com.thoughtworks.qdox.model.JavaParameter;
import com.thoughtworks.qdox.model.JavaSource;
import com.thoughtworks.qdox.model.Type;
import com.thoughtworks.qdox.model.TypeVariable;
import com.thoughtworks.qdox.model.annotation.AnnotationFieldRef;
import com.thoughtworks.qdox.model.annotation.RecursiveAnnotationVisitor;
import com.thoughtworks.qdox.parser.Builder;
import com.thoughtworks.qdox.parser.structs.ClassDef;
import com.thoughtworks.qdox.parser.structs.FieldDef;
import com.thoughtworks.qdox.parser.structs.MethodDef;
import com.thoughtworks.qdox.parser.structs.PackageDef;
import com.thoughtworks.qdox.parser.structs.TagDef;
import com.thoughtworks.qdox.parser.structs.TypeDef;
import com.thoughtworks.qdox.parser.structs.TypeVariableDef;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public class ModelBuilder
implements Builder {
    private final JavaClassContext context;
    private final JavaSource source;
    private JavaClassParent currentParent;
    private JavaClass currentClass;
    private JavaMethod currentMethod;
    private List currentAnnoDefs;
    private String lastComment;
    private List lastTagSet;
    private DocletTagFactory docletTagFactory;
    private final Map allPackages;

    public ModelBuilder() {
        this(new JavaClassContext(new ClassLibrary()), new DefaultDocletTagFactory(), new HashMap());
    }

    public ModelBuilder(JavaClassContext context, DocletTagFactory docletTagFactory, Map allPackages) {
        this.context = context;
        this.docletTagFactory = docletTagFactory;
        this.allPackages = allPackages;
        this.source = new JavaSource(context);
        this.currentParent = this.source;
        this.currentAnnoDefs = new ArrayList();
    }

    public void addPackage(PackageDef packageDef) {
        JavaPackage jPackage = (JavaPackage)this.allPackages.get(packageDef.name);
        if (jPackage == null) {
            jPackage = new JavaPackage(packageDef.name, this.allPackages);
            this.allPackages.put(packageDef.name, jPackage);
        }
        jPackage.setLineNumber(packageDef.lineNumber);
        this.setAnnotations(jPackage);
        this.source.setPackage(jPackage);
    }

    public void addImport(String importName) {
        this.source.addImport(importName);
    }

    public void addJavaDoc(String text) {
        this.lastComment = text;
        this.lastTagSet = new LinkedList();
    }

    public void addJavaDocTag(TagDef tagDef) {
        this.lastTagSet.add(tagDef);
    }

    public void beginClass(ClassDef def) {
        this.currentClass = new JavaClass();
        this.currentClass.setLineNumber(def.lineNumber);
        this.currentClass.setName(def.name);
        this.currentClass.setInterface("interface".equals(def.type));
        this.currentClass.setEnum("enum".equals(def.type));
        this.currentClass.setAnnotation("@interface".equals(def.type));
        if (this.currentClass.isInterface()) {
            this.currentClass.setSuperClass(null);
        } else if (!this.currentClass.isEnum()) {
            this.currentClass.setSuperClass(def.extendz.size() > 0 ? this.createType((TypeDef)def.extendz.toArray()[0], 0) : null);
        }
        Set implementSet = this.currentClass.isInterface() ? def.extendz : def.implementz;
        Iterator implementIt = implementSet.iterator();
        Type[] implementz = new Type[implementSet.size()];
        for (int i = 0; i < implementz.length && implementIt.hasNext(); ++i) {
            implementz[i] = this.createType((TypeDef)implementIt.next(), 0);
        }
        this.currentClass.setImplementz(implementz);
        String[] modifiers = new String[def.modifiers.size()];
        def.modifiers.toArray(modifiers);
        this.currentClass.setModifiers(modifiers);
        this.addJavaDoc(this.currentClass);
        this.setAnnotations(this.currentClass);
        this.currentParent.addClass(this.currentClass);
        this.currentParent = this.currentClass;
        this.context.add(this.currentClass.getFullyQualifiedName());
    }

    public void endClass() {
        this.currentParent = this.currentClass.getParent();
        this.currentClass = this.currentParent instanceof JavaClass ? (JavaClass)this.currentParent : null;
    }

    public Type createType(String typeName, int dimensions) {
        if (typeName == null || typeName.equals("")) {
            return null;
        }
        return this.createType(new TypeDef(typeName), dimensions);
    }

    public Type createType(TypeDef typeDef) {
        return this.createType(typeDef, 0);
    }

    public Type createType(TypeDef typeDef, int dimensions) {
        if (typeDef == null) {
            return null;
        }
        return Type.createUnresolved(typeDef, dimensions, this.currentClass == null ? this.currentParent : this.currentClass);
    }

    private void addJavaDoc(AbstractJavaEntity entity) {
        if (this.lastComment == null) {
            return;
        }
        entity.setComment(this.lastComment);
        Iterator tagDefIterator = this.lastTagSet.iterator();
        ArrayList<DocletTag> tagList = new ArrayList<DocletTag>();
        while (tagDefIterator.hasNext()) {
            TagDef tagDef = (TagDef)tagDefIterator.next();
            tagList.add(this.docletTagFactory.createDocletTag(tagDef.name, tagDef.text, entity, tagDef.lineNumber));
        }
        entity.setTags(tagList);
        this.lastComment = null;
    }

    public void addMethod(MethodDef def) {
        this.beginMethod();
        this.endMethod(def);
    }

    public void beginMethod() {
        this.currentMethod = new JavaMethod();
        this.setAnnotations(this.currentMethod);
    }

    public void endMethod(MethodDef def) {
        int index;
        this.currentMethod.setParentClass(this.currentClass);
        this.currentMethod.setLineNumber(def.lineNumber);
        this.currentMethod.setName(def.name);
        this.currentMethod.setReturns(this.createType(def.returnType, def.dimensions));
        this.currentMethod.setConstructor(def.constructor);
        if (def.typeParams != null) {
            TypeVariable[] typeParams = new TypeVariable[def.typeParams.size()];
            index = 0;
            Iterator iterator = def.typeParams.iterator();
            while (iterator.hasNext()) {
                TypeVariableDef typeVariableDef = (TypeVariableDef)iterator.next();
                typeParams[index++] = this.createTypeVariable(typeVariableDef);
            }
            this.currentMethod.setTypeParameters(typeParams);
        }
        Type[] exceptions = new Type[def.exceptions.size()];
        index = 0;
        Iterator iter = def.exceptions.iterator();
        while (iter.hasNext()) {
            exceptions[index++] = this.createType((String)iter.next(), 0);
        }
        this.currentMethod.setExceptions(exceptions);
        String[] modifiers = new String[def.modifiers.size()];
        def.modifiers.toArray(modifiers);
        this.currentMethod.setModifiers(modifiers);
        this.currentMethod.setSourceCode(def.body);
        this.addJavaDoc(this.currentMethod);
        this.currentClass.addMethod(this.currentMethod);
    }

    public TypeVariable createTypeVariable(TypeVariableDef typeVariableDef) {
        if (typeVariableDef == null) {
            return null;
        }
        return TypeVariable.createUnresolved(typeVariableDef, this.currentClass == null ? this.currentParent : this.currentClass);
    }

    public TypeVariable createTypeVariable(String name, List typeParams) {
        if (name == null || name.equals("")) {
            return null;
        }
        return this.createTypeVariable(new TypeVariableDef(name, typeParams));
    }

    public void addField(FieldDef def) {
        JavaField currentField = new JavaField();
        currentField.setParentClass(this.currentClass);
        currentField.setLineNumber(def.lineNumber);
        currentField.setName(def.name);
        currentField.setType(this.createType(def.type, def.dimensions));
        String[] modifiers = new String[def.modifiers.size()];
        def.modifiers.toArray(modifiers);
        currentField.setModifiers(modifiers);
        currentField.setInitializationExpression(def.body);
        this.addJavaDoc(currentField);
        this.setAnnotations(currentField);
        this.currentClass.addField(currentField);
    }

    public void addParameter(FieldDef fieldDef) {
        JavaParameter jParam = new JavaParameter(this.createType(fieldDef.type, fieldDef.dimensions), fieldDef.name, fieldDef.isVarArgs);
        this.setAnnotations(jParam);
        this.currentMethod.addParameter(jParam);
    }

    private void setAnnotations(final AbstractBaseJavaEntity entity) {
        if (!this.currentAnnoDefs.isEmpty()) {
            RecursiveAnnotationVisitor visitor = new RecursiveAnnotationVisitor(){

                public Object visitAnnotation(Annotation annotation) {
                    annotation.setContext(entity);
                    return super.visitAnnotation(annotation);
                }

                public Object visitAnnotationFieldRef(AnnotationFieldRef fieldRef) {
                    fieldRef.setContext(entity);
                    return super.visitAnnotationFieldRef(fieldRef);
                }
            };
            Annotation[] annotations = new Annotation[this.currentAnnoDefs.size()];
            ListIterator iter = this.currentAnnoDefs.listIterator();
            while (iter.hasNext()) {
                Annotation annotation = (Annotation)iter.next();
                annotation.accept(visitor);
                annotations[iter.previousIndex()] = annotation;
            }
            entity.setAnnotations(annotations);
            this.currentAnnoDefs.clear();
        }
    }

    public void addAnnotation(Annotation annotation) {
        this.currentAnnoDefs.add(annotation);
    }

    public JavaSource getSource() {
        return this.source;
    }
}

