/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hcatalog.hbase;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.mapred.TableOutputFormat;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobContext;
import org.apache.hadoop.mapred.OutputCommitter;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.TaskAttemptContext;
import org.apache.hadoop.util.Progressable;
import org.apache.hcatalog.hbase.HBaseBaseOutputFormat;
import org.apache.hcatalog.hbase.HBaseRevisionManagerUtil;
import org.apache.hcatalog.hbase.HBaseUtil;
import org.apache.hcatalog.hbase.snapshot.RevisionManager;
import org.apache.hcatalog.hbase.snapshot.Transaction;

class HBaseDirectOutputFormat
extends HBaseBaseOutputFormat {
    private TableOutputFormat outputFormat = new TableOutputFormat();

    @Override
    public RecordWriter<WritableComparable<?>, Put> getRecordWriter(FileSystem ignored, JobConf job, String name, Progressable progress) throws IOException {
        long version = HBaseRevisionManagerUtil.getOutputRevision((Configuration)job);
        return new HBaseDirectRecordWriter(this.outputFormat.getRecordWriter(ignored, job, name, progress), version);
    }

    @Override
    public void checkOutputSpecs(FileSystem ignored, JobConf job) throws IOException {
        this.outputFormat.checkOutputSpecs(ignored, job);
        HBaseUtil.addHBaseDelegationToken(job);
    }

    public static class HBaseDirectOutputCommitter
    extends OutputCommitter {
        public void abortTask(TaskAttemptContext taskContext) throws IOException {
        }

        public void commitTask(TaskAttemptContext taskContext) throws IOException {
        }

        public boolean needsTaskCommit(TaskAttemptContext taskContext) throws IOException {
            return false;
        }

        public void setupJob(JobContext jobContext) throws IOException {
        }

        public void setupTask(TaskAttemptContext taskContext) throws IOException {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void abortJob(JobContext jobContext, int status) throws IOException {
            super.abortJob(jobContext, status);
            RevisionManager rm = null;
            try {
                rm = HBaseRevisionManagerUtil.getOpenedRevisionManager(jobContext.getConfiguration());
                Transaction writeTransaction = HBaseRevisionManagerUtil.getWriteTransaction(jobContext.getConfiguration());
                rm.abortWriteTransaction(writeTransaction);
            }
            finally {
                if (rm != null) {
                    rm.close();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void commitJob(JobContext jobContext) throws IOException {
            RevisionManager rm = null;
            try {
                rm = HBaseRevisionManagerUtil.getOpenedRevisionManager(jobContext.getConfiguration());
                rm.commitWriteTransaction(HBaseRevisionManagerUtil.getWriteTransaction(jobContext.getConfiguration()));
            }
            finally {
                if (rm != null) {
                    rm.close();
                }
            }
        }
    }

    private static class HBaseDirectRecordWriter
    implements RecordWriter<WritableComparable<?>, Put> {
        private RecordWriter<WritableComparable<?>, Put> baseWriter;
        private final Long outputVersion;

        public HBaseDirectRecordWriter(RecordWriter<WritableComparable<?>, Put> baseWriter, Long outputVersion) {
            this.baseWriter = baseWriter;
            this.outputVersion = outputVersion;
        }

        public void write(WritableComparable<?> key, Put value) throws IOException {
            Put put = value;
            if (this.outputVersion != null) {
                put = new Put(value.getRow(), this.outputVersion.longValue());
                for (List row : value.getFamilyMap().values()) {
                    for (KeyValue el : row) {
                        put.add(el.getFamily(), el.getQualifier(), el.getValue());
                    }
                }
            }
            this.baseWriter.write(key, (Object)put);
        }

        public void close(Reporter reporter) throws IOException {
            this.baseWriter.close(reporter);
        }
    }
}

