/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hcatalog.hbase;

import java.io.IOException;
import java.net.URI;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.HFileOutputFormat;
import org.apache.hadoop.hbase.mapreduce.LoadIncrementalHFiles;
import org.apache.hadoop.hbase.mapreduce.PutSortReducer;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hive.hcatalog.mapreduce.HCatMapRedUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ImportSequenceFile {
    private static final Logger LOG = LoggerFactory.getLogger(ImportSequenceFile.class);
    private static final String NAME = "HCatImportSequenceFile";
    private static final String IMPORTER_WORK_DIR = "_IMPORTER_MR_WORK_DIR";

    ImportSequenceFile() {
    }

    private static Job createSubmittableJob(Configuration conf, String tableName, Path inputDir, Path scratchDir, boolean localMode) throws IOException {
        Job job = new Job(conf, "HCatImportSequenceFile_" + tableName);
        job.setJarByClass(SequenceFileImporter.class);
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{inputDir});
        job.setInputFormatClass(SequenceFileInputFormat.class);
        job.setMapperClass(SequenceFileImporter.class);
        HTable table = new HTable(conf, tableName);
        job.setReducerClass(PutSortReducer.class);
        FileOutputFormat.setOutputPath((Job)job, (Path)scratchDir);
        job.setMapOutputKeyClass(ImmutableBytesWritable.class);
        job.setMapOutputValueClass(Put.class);
        HFileOutputFormat.configureIncrementalLoad((Job)job, (HTable)table);
        job.setOutputFormatClass(ImporterOutputFormat.class);
        if (localMode) {
            String partitionFile = null;
            for (URI uri : DistributedCache.getCacheFiles((Configuration)job.getConfiguration())) {
                if (!"_partition.lst".equals(uri.getFragment())) continue;
                partitionFile = uri.toString();
                break;
            }
            partitionFile = partitionFile.substring(0, partitionFile.lastIndexOf("#"));
            job.getConfiguration().set("mapreduce.totalorderpartitioner.path", partitionFile.toString());
        }
        return job;
    }

    static boolean runJob(JobContext parentContext, String tableName, Path InputDir, Path scratchDir) {
        Configuration parentConf = parentContext.getConfiguration();
        Configuration conf = new Configuration();
        for (Map.Entry el : parentConf) {
            if (((String)el.getKey()).startsWith("hbase.")) {
                conf.set((String)el.getKey(), (String)el.getValue());
            }
            if (!((String)el.getKey()).startsWith("mapred.cache.archives")) continue;
            conf.set((String)el.getKey(), (String)el.getValue());
        }
        conf.set("mapred.job.classpath.archives", parentConf.get("mapred.job.classpath.archives", ""));
        conf.set("mapreduce.job.cache.archives.visibilities", parentConf.get("mapreduce.job.cache.archives.visibilities", ""));
        if (parentConf.getBoolean("hadoop.security.authorization", false)) {
            FsPermission.setUMask((Configuration)conf, (FsPermission)FsPermission.valueOf((String)"----------"));
        }
        conf.set("hcat.hbase.mapreduce.outputTableName", tableName);
        conf.setBoolean("mapreduce.job.complete.cancel.delegation.tokens", false);
        boolean localMode = "local".equals(conf.get("mapred.job.tracker"));
        boolean success = false;
        try {
            FileSystem fs = FileSystem.get((Configuration)parentConf);
            Path workDir = new Path(new Job(parentConf).getWorkingDirectory(), IMPORTER_WORK_DIR);
            if (!fs.mkdirs(workDir)) {
                throw new IOException("Importer work directory already exists: " + workDir);
            }
            Job job = ImportSequenceFile.createSubmittableJob(conf, tableName, InputDir, scratchDir, localMode);
            job.setWorkingDirectory(workDir);
            job.getCredentials().addAll(parentContext.getCredentials());
            success = job.waitForCompletion(true);
            fs.delete(workDir, true);
            if (localMode && success) {
                new ImporterOutputFormat().getOutputCommitter(HCatMapRedUtil.createTaskAttemptContext((Configuration)conf, (TaskAttemptID)new TaskAttemptID())).commitJob((JobContext)job);
            }
        }
        catch (InterruptedException e) {
            LOG.error("ImportSequenceFile Failed", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            LOG.error("ImportSequenceFile Failed", (Throwable)e);
        }
        catch (IOException e) {
            LOG.error("ImportSequenceFile Failed", (Throwable)e);
        }
        return success;
    }

    private static class ImporterOutputFormat
    extends HFileOutputFormat {
        private ImporterOutputFormat() {
        }

        public OutputCommitter getOutputCommitter(TaskAttemptContext context) throws IOException {
            final OutputCommitter baseOutputCommitter = super.getOutputCommitter(context);
            return new OutputCommitter(){

                public void setupJob(JobContext jobContext) throws IOException {
                    baseOutputCommitter.setupJob(jobContext);
                }

                public void setupTask(TaskAttemptContext taskContext) throws IOException {
                    baseOutputCommitter.setupTask(taskContext);
                }

                public boolean needsTaskCommit(TaskAttemptContext taskContext) throws IOException {
                    return baseOutputCommitter.needsTaskCommit(taskContext);
                }

                public void commitTask(TaskAttemptContext taskContext) throws IOException {
                    baseOutputCommitter.commitTask(taskContext);
                }

                public void abortTask(TaskAttemptContext taskContext) throws IOException {
                    baseOutputCommitter.abortTask(taskContext);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void abortJob(JobContext jobContext, JobStatus.State state) throws IOException {
                    try {
                        baseOutputCommitter.abortJob(jobContext, state);
                    }
                    finally {
                        this.cleanupScratch(jobContext);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void commitJob(JobContext jobContext) throws IOException {
                    try {
                        baseOutputCommitter.commitJob(jobContext);
                        Configuration conf = jobContext.getConfiguration();
                        try {
                            new LoadIncrementalHFiles(conf).doBulkLoad(HFileOutputFormat.getOutputPath((JobContext)jobContext), new HTable(conf, conf.get("hcat.hbase.mapreduce.outputTableName")));
                        }
                        catch (Exception e) {
                            throw new IOException("BulkLoad failed.", e);
                        }
                    }
                    finally {
                        this.cleanupScratch(jobContext);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void cleanupJob(JobContext context) throws IOException {
                    try {
                        baseOutputCommitter.cleanupJob(context);
                    }
                    finally {
                        this.cleanupScratch(context);
                    }
                }

                private void cleanupScratch(JobContext context) throws IOException {
                    FileSystem fs = FileSystem.get((Configuration)context.getConfiguration());
                    fs.delete(HFileOutputFormat.getOutputPath((JobContext)context), true);
                }
            };
        }
    }

    private static class SequenceFileImporter
    extends Mapper<ImmutableBytesWritable, Put, ImmutableBytesWritable, Put> {
        private SequenceFileImporter() {
        }

        public void map(ImmutableBytesWritable rowKey, Put value, Mapper.Context context) throws IOException {
            try {
                context.write((Object)new ImmutableBytesWritable(value.getRow()), (Object)value);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

