/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hcatalog.hbase.snapshot;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class TableSnapshot
implements Serializable {
    private String name;
    private Map<String, Long> cfRevisionMap;
    private long latestRevision;

    public TableSnapshot(String name, Map<String, Long> cfRevMap, long latestRevision) {
        this.name = name;
        if (cfRevMap == null) {
            throw new IllegalArgumentException("revision map cannot be null");
        }
        this.cfRevisionMap = cfRevMap;
        this.latestRevision = latestRevision;
    }

    public String getTableName() {
        return this.name;
    }

    public List<String> getColumnFamilies() {
        return new ArrayList<String>(this.cfRevisionMap.keySet());
    }

    public long getRevision(String familyName) {
        if (this.cfRevisionMap.containsKey(familyName)) {
            return this.cfRevisionMap.get(familyName);
        }
        return this.latestRevision;
    }

    public long getLatestRevision() {
        return this.latestRevision;
    }

    public String toString() {
        String snapshot = "Table Name : " + this.name + " Latest Revision: " + this.latestRevision + " Column Familiy revision : " + this.cfRevisionMap.toString();
        return snapshot;
    }
}

