/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hcatalog.hbase.snapshot;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hcatalog.hbase.snapshot.FamilyRevision;
import org.apache.hcatalog.hbase.snapshot.IDGenerator;
import org.apache.hcatalog.hbase.snapshot.PathUtil;
import org.apache.hcatalog.hbase.snapshot.transaction.thrift.StoreFamilyRevision;
import org.apache.hcatalog.hbase.snapshot.transaction.thrift.StoreFamilyRevisionList;
import org.apache.thrift.TBase;
import org.apache.thrift.TDeserializer;
import org.apache.thrift.TSerializer;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ZKUtil {
    private int DEFAULT_SESSION_TIMEOUT = 1000000;
    private ZooKeeper zkSession;
    private String baseDir;
    private String connectString;
    private static final Logger LOG = LoggerFactory.getLogger(ZKUtil.class);

    ZKUtil(String connection, String baseDir) {
        this.connectString = connection;
        this.baseDir = baseDir;
    }

    void setUpZnodesForTable(String table, List<String> families) throws IOException {
        String transactionDataTablePath = PathUtil.getTxnDataPath(this.baseDir, table);
        this.ensurePathExists(transactionDataTablePath, null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        for (String cf : families) {
            String runningDataPath = PathUtil.getRunningTxnInfoPath(this.baseDir, table, cf);
            this.ensurePathExists(runningDataPath, null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            String abortDataPath = PathUtil.getAbortInformationPath(this.baseDir, table, cf);
            this.ensurePathExists(abortDataPath, null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
    }

    void ensurePathExists(String path, byte[] data, List<ACL> acl, CreateMode flags) throws IOException {
        String[] dirs = path.split("/");
        String parentPath = "";
        for (String subDir : dirs) {
            if (subDir.equals("")) continue;
            parentPath = parentPath + "/" + subDir;
            try {
                Stat stat = this.getSession().exists(parentPath, false);
                if (stat != null) continue;
                this.getSession().create(parentPath, data, acl, flags);
            }
            catch (Exception e) {
                throw new IOException("Exception while creating path " + parentPath, e);
            }
        }
    }

    List<String> getColumnFamiliesOfTable(String tableName) throws IOException {
        String path = PathUtil.getTxnDataPath(this.baseDir, tableName);
        List children = null;
        ArrayList<String> columnFamlies = new ArrayList<String>();
        try {
            children = this.getSession().getChildren(path, false);
        }
        catch (KeeperException e) {
            LOG.warn("Caught: ", (Throwable)e);
            throw new IOException("Exception while obtaining columns of table.", e);
        }
        catch (InterruptedException e) {
            LOG.warn("Caught: ", (Throwable)e);
            throw new IOException("Exception while obtaining columns of table.", e);
        }
        for (String child : children) {
            if (child.contains("idgen") || child.contains("_locknode_")) continue;
            columnFamlies.add(child);
        }
        return columnFamlies;
    }

    long getTimeStamp() throws IOException {
        Stat stat;
        String clockPath = PathUtil.getClockPath(this.baseDir);
        this.ensurePathExists(clockPath, null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        try {
            this.getSession().exists(clockPath, false);
            stat = this.getSession().setData(clockPath, null, -1);
        }
        catch (KeeperException e) {
            LOG.warn("Caught: ", (Throwable)e);
            throw new IOException("Exception while obtaining timestamp ", e);
        }
        catch (InterruptedException e) {
            LOG.warn("Caught: ", (Throwable)e);
            throw new IOException("Exception while obtaining timestamp ", e);
        }
        long timeStamp = stat.getMtime();
        return timeStamp;
    }

    long nextId(String tableName) throws IOException {
        String idNode = PathUtil.getRevisionIDNode(this.baseDir, tableName);
        this.ensurePathExists(idNode, Bytes.toBytes((String)"0"), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        String lockNode = PathUtil.getLockManagementNode(idNode);
        this.ensurePathExists(lockNode, null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        IDGenerator idf = new IDGenerator(this.getSession(), tableName, idNode);
        long id = idf.obtainID();
        return id;
    }

    long currentID(String tableName) throws IOException {
        String idNode = PathUtil.getRevisionIDNode(this.baseDir, tableName);
        this.ensurePathExists(idNode, Bytes.toBytes((String)"0"), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        String lockNode = PathUtil.getLockManagementNode(idNode);
        this.ensurePathExists(lockNode, null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        IDGenerator idf = new IDGenerator(this.getSession(), tableName, idNode);
        long id = idf.readID();
        return id;
    }

    List<FamilyRevision> getTransactionList(String path) throws IOException {
        byte[] data = this.getRawData(path, new Stat());
        ArrayList<FamilyRevision> wtxnList = new ArrayList<FamilyRevision>();
        if (data == null) {
            return wtxnList;
        }
        StoreFamilyRevisionList txnList = new StoreFamilyRevisionList();
        ZKUtil.deserialize(txnList, data);
        Iterator<StoreFamilyRevision> itr = txnList.getRevisionListIterator();
        while (itr.hasNext()) {
            StoreFamilyRevision wtxn = itr.next();
            wtxnList.add(new FamilyRevision(wtxn.getRevision(), wtxn.getTimestamp()));
        }
        return wtxnList;
    }

    byte[] getRawData(String path, Stat stat) throws IOException {
        byte[] data = null;
        try {
            data = this.getSession().getData(path, false, stat);
        }
        catch (Exception e) {
            throw new IOException("Exception while obtaining raw data from zookeeper path " + path, e);
        }
        return data;
    }

    void createRootZNodes() throws IOException {
        String txnBaseNode = PathUtil.getTransactionBasePath(this.baseDir);
        String clockNode = PathUtil.getClockPath(this.baseDir);
        this.ensurePathExists(txnBaseNode, null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        this.ensurePathExists(clockNode, null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
    }

    void closeZKConnection() {
        if (this.zkSession != null) {
            try {
                this.zkSession.close();
            }
            catch (InterruptedException e) {
                LOG.warn("Close failed: ", (Throwable)e);
            }
            this.zkSession = null;
            LOG.info("Disconnected to ZooKeeper");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ZooKeeper getSession() throws IOException {
        if (this.zkSession == null || this.zkSession.getState() == ZooKeeper.States.CLOSED) {
            ZKUtil zKUtil = this;
            synchronized (zKUtil) {
                if (this.zkSession == null || this.zkSession.getState() == ZooKeeper.States.CLOSED) {
                    this.zkSession = new ZooKeeper(this.connectString, this.DEFAULT_SESSION_TIMEOUT, (Watcher)new ZKWatcher());
                    while (this.zkSession.getState() == ZooKeeper.States.CONNECTING) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
        }
        return this.zkSession;
    }

    void updateData(String path, FamilyRevision updateTx, UpdateMode mode) throws IOException {
        if (updateTx == null) {
            throw new IOException("The transaction to be updated found to be null.");
        }
        List<FamilyRevision> currentData = this.getTransactionList(path);
        ArrayList<FamilyRevision> newData = new ArrayList<FamilyRevision>();
        boolean dataFound = false;
        long updateVersion = updateTx.getRevision();
        for (FamilyRevision tranx : currentData) {
            if (tranx.getRevision() != updateVersion) {
                newData.add(tranx);
                continue;
            }
            dataFound = true;
        }
        switch (mode) {
            case REMOVE: {
                if (!dataFound) {
                    throw new IOException("The transaction to be removed not found in the data.");
                }
                LOG.info("Removed trasaction : " + updateTx.toString());
                break;
            }
            case KEEP_ALIVE: {
                if (!dataFound) {
                    throw new IOException("The transaction to be kept alove not found in the data. It might have been expired.");
                }
                newData.add(updateTx);
                LOG.info("keep alive of transaction : " + updateTx.toString());
                break;
            }
            case APPEND: {
                if (dataFound) {
                    throw new IOException("The data to be appended already exists.");
                }
                newData.add(updateTx);
                LOG.info("Added transaction : " + updateTx.toString());
            }
        }
        ArrayList<StoreFamilyRevision> newTxnList = new ArrayList<StoreFamilyRevision>();
        for (FamilyRevision wtxn : newData) {
            StoreFamilyRevision newTxn = new StoreFamilyRevision(wtxn.getRevision(), wtxn.getExpireTimestamp());
            newTxnList.add(newTxn);
        }
        StoreFamilyRevisionList wtxnList = new StoreFamilyRevisionList(newTxnList);
        byte[] newByteData = ZKUtil.serialize(wtxnList);
        Stat stat = null;
        try {
            stat = this.zkSession.setData(path, newByteData, -1);
        }
        catch (KeeperException e) {
            throw new IOException("Exception while updating trasactional data. ", e);
        }
        catch (InterruptedException e) {
            throw new IOException("Exception while updating trasactional data. ", e);
        }
        if (stat != null) {
            LOG.info("Transaction list stored at " + path + ".");
        }
    }

    void refreshTransactions(String path) throws IOException {
        List<FamilyRevision> currentData = this.getTransactionList(path);
        ArrayList<FamilyRevision> newData = new ArrayList<FamilyRevision>();
        for (FamilyRevision tranx : currentData) {
            if (tranx.getExpireTimestamp() <= this.getTimeStamp()) continue;
            newData.add(tranx);
        }
        if (!newData.equals(currentData)) {
            ArrayList<StoreFamilyRevision> newTxnList = new ArrayList<StoreFamilyRevision>();
            for (FamilyRevision wtxn : newData) {
                StoreFamilyRevision newTxn = new StoreFamilyRevision(wtxn.getRevision(), wtxn.getExpireTimestamp());
                newTxnList.add(newTxn);
            }
            StoreFamilyRevisionList wtxnList = new StoreFamilyRevisionList(newTxnList);
            byte[] newByteData = ZKUtil.serialize(wtxnList);
            try {
                this.zkSession.setData(path, newByteData, -1);
            }
            catch (KeeperException e) {
                throw new IOException("Exception while updating trasactional data. ", e);
            }
            catch (InterruptedException e) {
                throw new IOException("Exception while updating trasactional data. ", e);
            }
        }
    }

    void deleteZNodes(String tableName) throws IOException {
        String transactionDataTablePath = PathUtil.getTxnDataPath(this.baseDir, tableName);
        this.deleteRecursively(transactionDataTablePath);
    }

    void deleteRecursively(String path) throws IOException {
        try {
            List children = this.getSession().getChildren(path, false);
            if (children.size() != 0) {
                for (String child : children) {
                    this.deleteRecursively(path + "/" + child);
                }
            }
            this.getSession().delete(path, -1);
        }
        catch (KeeperException e) {
            throw new IOException("Exception while deleting path " + path + ".", e);
        }
        catch (InterruptedException e) {
            throw new IOException("Exception while deleting path " + path + ".", e);
        }
    }

    static byte[] serialize(TBase obj) throws IOException {
        if (obj == null) {
            return new byte[0];
        }
        try {
            TSerializer serializer = new TSerializer((TProtocolFactory)new TBinaryProtocol.Factory());
            byte[] bytes = serializer.serialize(obj);
            return bytes;
        }
        catch (Exception e) {
            throw new IOException("Serialization error: ", e);
        }
    }

    static void deserialize(TBase obj, byte[] data) throws IOException {
        if (data == null || data.length == 0) {
            return;
        }
        try {
            TDeserializer deserializer = new TDeserializer((TProtocolFactory)new TBinaryProtocol.Factory());
            deserializer.deserialize(obj, data);
        }
        catch (Exception e) {
            throw new IOException("Deserialization error: " + e.getMessage(), e);
        }
    }

    private class ZKWatcher
    implements Watcher {
        private ZKWatcher() {
        }

        public void process(WatchedEvent event) {
            switch (event.getState()) {
                case Expired: {
                    LOG.info("The client session has expired. Try opening a new session and connecting again.");
                    ZKUtil.this.zkSession = null;
                    break;
                }
            }
        }
    }

    static enum UpdateMode {
        APPEND,
        REMOVE,
        KEEP_ALIVE;

    }
}

