/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.ipc.stats;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.avro.Protocol;
import org.apache.avro.ipc.RPCContext;
import org.apache.avro.ipc.RPCPlugin;
import org.apache.avro.ipc.stats.FloatHistogram;
import org.apache.avro.ipc.stats.Histogram;
import org.apache.avro.ipc.stats.Stopwatch;

public class StatsPlugin
extends RPCPlugin {
    static final Histogram.Segmenter<String, Float> DEFAULT_SEGMENTER = new Histogram.TreeMapSegmenter<Float>(new TreeSet<Float>(Arrays.asList(Float.valueOf(0.0f), Float.valueOf(25.0f), Float.valueOf(50.0f), Float.valueOf(75.0f), Float.valueOf(100.0f), Float.valueOf(200.0f), Float.valueOf(300.0f), Float.valueOf(500.0f), Float.valueOf(750.0f), Float.valueOf(1000.0f), Float.valueOf(2000.0f), Float.valueOf(5000.0f), Float.valueOf(10000.0f), Float.valueOf(60000.0f), Float.valueOf(600000.0f))));
    Map<Protocol.Message, FloatHistogram<?>> methodTimings = new HashMap();
    ConcurrentMap<RPCContext, Stopwatch> activeRpcs = new ConcurrentHashMap<RPCContext, Stopwatch>();
    private Stopwatch.Ticks ticks;
    private Histogram.Segmenter<?, Float> segmenter;

    StatsPlugin(Stopwatch.Ticks ticks, Histogram.Segmenter<?, Float> segmenter) {
        this.segmenter = segmenter;
        this.ticks = ticks;
    }

    public StatsPlugin() {
        this(Stopwatch.SYSTEM_TICKS, DEFAULT_SEGMENTER);
    }

    @Override
    public void serverReceiveRequest(RPCContext context) {
        Stopwatch t = new Stopwatch(this.ticks);
        t.start();
        this.activeRpcs.put(context, t);
    }

    @Override
    public void serverSendResponse(RPCContext context) {
        Stopwatch t = (Stopwatch)this.activeRpcs.remove(context);
        t.stop();
        this.publish(context, t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publish(RPCContext context, Stopwatch t) {
        Protocol.Message message = context.getMessage();
        if (message == null) {
            throw new IllegalArgumentException();
        }
        Map<Protocol.Message, FloatHistogram<?>> map = this.methodTimings;
        synchronized (map) {
            FloatHistogram<?> h = this.methodTimings.get(context.getMessage());
            if (h == null) {
                h = this.createNewHistogram();
                this.methodTimings.put(context.getMessage(), h);
            }
            h.add(Float.valueOf(StatsPlugin.nanosToMillis(t.elapsedNanos())));
        }
    }

    private FloatHistogram<?> createNewHistogram() {
        return new FloatHistogram(this.segmenter);
    }

    static float nanosToMillis(long elapsedNanos) {
        return (float)elapsedNanos / 1000000.0f;
    }
}

