/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.avro.generated;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.avro.AvroRemoteException;
import org.apache.avro.Protocol;
import org.apache.hadoop.hbase.avro.generated.AClusterStatus;
import org.apache.hadoop.hbase.avro.generated.ADelete;
import org.apache.hadoop.hbase.avro.generated.AFamilyDescriptor;
import org.apache.hadoop.hbase.avro.generated.AGet;
import org.apache.hadoop.hbase.avro.generated.AIOError;
import org.apache.hadoop.hbase.avro.generated.AIllegalArgument;
import org.apache.hadoop.hbase.avro.generated.AMasterNotRunning;
import org.apache.hadoop.hbase.avro.generated.APut;
import org.apache.hadoop.hbase.avro.generated.AResult;
import org.apache.hadoop.hbase.avro.generated.AScan;
import org.apache.hadoop.hbase.avro.generated.ATableDescriptor;
import org.apache.hadoop.hbase.avro.generated.ATableExists;

public interface HBase {
    public static final Protocol PROTOCOL = Protocol.parse((String)"{\"protocol\":\"HBase\",\"namespace\":\"org.apache.hadoop.hbase.avro.generated\",\"types\":[{\"type\":\"record\",\"name\":\"AServerAddress\",\"fields\":[{\"name\":\"hostname\",\"type\":\"string\"},{\"name\":\"inetSocketAddress\",\"type\":\"string\"},{\"name\":\"port\",\"type\":\"int\"}]},{\"type\":\"record\",\"name\":\"ARegionLoad\",\"fields\":[{\"name\":\"memStoreSizeMB\",\"type\":\"int\"},{\"name\":\"name\",\"type\":\"bytes\"},{\"name\":\"storefileIndexSizeMB\",\"type\":\"int\"},{\"name\":\"storefiles\",\"type\":\"int\"},{\"name\":\"storefileSizeMB\",\"type\":\"int\"},{\"name\":\"stores\",\"type\":\"int\"}]},{\"type\":\"record\",\"name\":\"AServerLoad\",\"fields\":[{\"name\":\"load\",\"type\":\"int\"},{\"name\":\"maxHeapMB\",\"type\":\"int\"},{\"name\":\"memStoreSizeInMB\",\"type\":\"int\"},{\"name\":\"numberOfRegions\",\"type\":\"int\"},{\"name\":\"numberOfRequests\",\"type\":\"int\"},{\"name\":\"regionsLoad\",\"type\":{\"type\":\"array\",\"items\":\"ARegionLoad\"}},{\"name\":\"storefileIndexSizeInMB\",\"type\":\"int\"},{\"name\":\"storefiles\",\"type\":\"int\"},{\"name\":\"storefileSizeInMB\",\"type\":\"int\"},{\"name\":\"usedHeapMB\",\"type\":\"int\"}]},{\"type\":\"record\",\"name\":\"AServerInfo\",\"fields\":[{\"name\":\"infoPort\",\"type\":\"int\"},{\"name\":\"load\",\"type\":\"AServerLoad\"},{\"name\":\"serverAddress\",\"type\":\"AServerAddress\"},{\"name\":\"serverName\",\"type\":\"string\"},{\"name\":\"startCode\",\"type\":\"long\"}]},{\"type\":\"record\",\"name\":\"AClusterStatus\",\"fields\":[{\"name\":\"averageLoad\",\"type\":\"double\"},{\"name\":\"deadServerNames\",\"type\":{\"type\":\"array\",\"items\":\"string\"}},{\"name\":\"deadServers\",\"type\":\"int\"},{\"name\":\"hbaseVersion\",\"type\":\"string\"},{\"name\":\"regionsCount\",\"type\":\"int\"},{\"name\":\"requestsCount\",\"type\":\"int\"},{\"name\":\"serverInfos\",\"type\":{\"type\":\"array\",\"items\":\"AServerInfo\"}},{\"name\":\"servers\",\"type\":\"int\"}]},{\"type\":\"enum\",\"name\":\"ACompressionAlgorithm\",\"symbols\":[\"LZO\",\"GZ\",\"NONE\"]},{\"type\":\"record\",\"name\":\"AFamilyDescriptor\",\"fields\":[{\"name\":\"name\",\"type\":\"bytes\"},{\"name\":\"compression\",\"type\":[\"ACompressionAlgorithm\",\"null\"]},{\"name\":\"maxVersions\",\"type\":[\"int\",\"null\"]},{\"name\":\"blocksize\",\"type\":[\"int\",\"null\"]},{\"name\":\"inMemory\",\"type\":[\"boolean\",\"null\"]},{\"name\":\"timeToLive\",\"type\":[\"int\",\"null\"]},{\"name\":\"blockCacheEnabled\",\"type\":[\"boolean\",\"null\"]}]},{\"type\":\"record\",\"name\":\"ATableDescriptor\",\"fields\":[{\"name\":\"name\",\"type\":\"bytes\"},{\"name\":\"families\",\"type\":[{\"type\":\"array\",\"items\":\"AFamilyDescriptor\"},\"null\"]},{\"name\":\"maxFileSize\",\"type\":[\"long\",\"null\"]},{\"name\":\"memStoreFlushSize\",\"type\":[\"long\",\"null\"]},{\"name\":\"rootRegion\",\"type\":[\"boolean\",\"null\"]},{\"name\":\"metaRegion\",\"type\":[\"boolean\",\"null\"]},{\"name\":\"metaTable\",\"type\":[\"boolean\",\"null\"]},{\"name\":\"readOnly\",\"type\":[\"boolean\",\"null\"]},{\"name\":\"deferredLogFlush\",\"type\":[\"boolean\",\"null\"]}]},{\"type\":\"record\",\"name\":\"AColumn\",\"fields\":[{\"name\":\"family\",\"type\":\"bytes\"},{\"name\":\"qualifier\",\"type\":[\"bytes\",\"null\"]}]},{\"type\":\"record\",\"name\":\"ATimeRange\",\"fields\":[{\"name\":\"minStamp\",\"type\":\"long\"},{\"name\":\"maxStamp\",\"type\":\"long\"}]},{\"type\":\"record\",\"name\":\"AGet\",\"fields\":[{\"name\":\"row\",\"type\":\"bytes\"},{\"name\":\"columns\",\"type\":[{\"type\":\"array\",\"items\":\"AColumn\"},\"null\"]},{\"name\":\"timestamp\",\"type\":[\"long\",\"null\"]},{\"name\":\"timerange\",\"type\":[\"ATimeRange\",\"null\"]},{\"name\":\"maxVersions\",\"type\":[\"int\",\"null\"]}]},{\"type\":\"record\",\"name\":\"AResultEntry\",\"fields\":[{\"name\":\"family\",\"type\":\"bytes\"},{\"name\":\"qualifier\",\"type\":\"bytes\"},{\"name\":\"value\",\"type\":\"bytes\"},{\"name\":\"timestamp\",\"type\":\"long\"}]},{\"type\":\"record\",\"name\":\"AResult\",\"fields\":[{\"name\":\"row\",\"type\":\"bytes\"},{\"name\":\"entries\",\"type\":{\"type\":\"array\",\"items\":\"AResultEntry\"}}]},{\"type\":\"record\",\"name\":\"AColumnValue\",\"fields\":[{\"name\":\"family\",\"type\":\"bytes\"},{\"name\":\"qualifier\",\"type\":\"bytes\"},{\"name\":\"value\",\"type\":\"bytes\"},{\"name\":\"timestamp\",\"type\":[\"long\",\"null\"]}]},{\"type\":\"record\",\"name\":\"APut\",\"fields\":[{\"name\":\"row\",\"type\":\"bytes\"},{\"name\":\"columnValues\",\"type\":{\"type\":\"array\",\"items\":\"AColumnValue\"}}]},{\"type\":\"record\",\"name\":\"ADelete\",\"fields\":[{\"name\":\"row\",\"type\":\"bytes\"},{\"name\":\"columns\",\"type\":[{\"type\":\"array\",\"items\":\"AColumn\"},\"null\"]}]},{\"type\":\"record\",\"name\":\"AScan\",\"fields\":[{\"name\":\"startRow\",\"type\":[\"bytes\",\"null\"]},{\"name\":\"stopRow\",\"type\":[\"bytes\",\"null\"]},{\"name\":\"columns\",\"type\":[{\"type\":\"array\",\"items\":\"AColumn\"},\"null\"]},{\"name\":\"timestamp\",\"type\":[\"long\",\"null\"]},{\"name\":\"timerange\",\"type\":[\"ATimeRange\",\"null\"]},{\"name\":\"maxVersions\",\"type\":[\"int\",\"null\"]}]},{\"type\":\"error\",\"name\":\"AIOError\",\"fields\":[{\"name\":\"message\",\"type\":\"string\"}]},{\"type\":\"error\",\"name\":\"AIllegalArgument\",\"fields\":[{\"name\":\"message\",\"type\":\"string\"}]},{\"type\":\"error\",\"name\":\"ATableExists\",\"fields\":[{\"name\":\"message\",\"type\":\"string\"}]},{\"type\":\"error\",\"name\":\"AMasterNotRunning\",\"fields\":[{\"name\":\"message\",\"type\":\"string\"}]}],\"messages\":{\"getHBaseVersion\":{\"request\":[],\"response\":\"string\",\"errors\":[\"AIOError\"]},\"getClusterStatus\":{\"request\":[],\"response\":\"AClusterStatus\",\"errors\":[\"AIOError\"]},\"listTables\":{\"request\":[],\"response\":{\"type\":\"array\",\"items\":\"ATableDescriptor\"},\"errors\":[\"AIOError\"]},\"describeTable\":{\"request\":[{\"name\":\"table\",\"type\":\"bytes\"}],\"response\":\"ATableDescriptor\",\"errors\":[\"AIOError\"]},\"isTableEnabled\":{\"request\":[{\"name\":\"table\",\"type\":\"bytes\"}],\"response\":\"boolean\",\"errors\":[\"AIOError\"]},\"tableExists\":{\"request\":[{\"name\":\"table\",\"type\":\"bytes\"}],\"response\":\"boolean\",\"errors\":[\"AIOError\"]},\"describeFamily\":{\"request\":[{\"name\":\"table\",\"type\":\"bytes\"},{\"name\":\"family\",\"type\":\"bytes\"}],\"response\":\"AFamilyDescriptor\",\"errors\":[\"AIOError\"]},\"createTable\":{\"request\":[{\"name\":\"table\",\"type\":\"ATableDescriptor\"}],\"response\":\"null\",\"errors\":[\"AIOError\",\"AIllegalArgument\",\"ATableExists\",\"AMasterNotRunning\"]},\"deleteTable\":{\"request\":[{\"name\":\"table\",\"type\":\"bytes\"}],\"response\":\"null\",\"errors\":[\"AIOError\"]},\"modifyTable\":{\"request\":[{\"name\":\"table\",\"type\":\"bytes\"},{\"name\":\"tableDescriptor\",\"type\":\"ATableDescriptor\"}],\"response\":\"null\",\"errors\":[\"AIOError\"]},\"enableTable\":{\"request\":[{\"name\":\"table\",\"type\":\"bytes\"}],\"response\":\"null\",\"errors\":[\"AIOError\"]},\"disableTable\":{\"request\":[{\"name\":\"table\",\"type\":\"bytes\"}],\"response\":\"null\",\"errors\":[\"AIOError\"]},\"flush\":{\"request\":[{\"name\":\"table\",\"type\":\"bytes\"}],\"response\":\"null\",\"errors\":[\"AIOError\"]},\"split\":{\"request\":[{\"name\":\"table\",\"type\":\"bytes\"}],\"response\":\"null\",\"errors\":[\"AIOError\"]},\"addFamily\":{\"request\":[{\"name\":\"table\",\"type\":\"bytes\"},{\"name\":\"family\",\"type\":\"AFamilyDescriptor\"}],\"response\":\"null\",\"errors\":[\"AIOError\"]},\"deleteFamily\":{\"request\":[{\"name\":\"table\",\"type\":\"bytes\"},{\"name\":\"family\",\"type\":\"bytes\"}],\"response\":\"null\",\"errors\":[\"AIOError\"]},\"modifyFamily\":{\"request\":[{\"name\":\"table\",\"type\":\"bytes\"},{\"name\":\"familyName\",\"type\":\"bytes\"},{\"name\":\"familyDescriptor\",\"type\":\"AFamilyDescriptor\"}],\"response\":\"null\",\"errors\":[\"AIOError\"]},\"get\":{\"request\":[{\"name\":\"table\",\"type\":\"bytes\"},{\"name\":\"get\",\"type\":\"AGet\"}],\"response\":\"AResult\",\"errors\":[\"AIOError\"]},\"exists\":{\"request\":[{\"name\":\"table\",\"type\":\"bytes\"},{\"name\":\"get\",\"type\":\"AGet\"}],\"response\":\"boolean\",\"errors\":[\"AIOError\"]},\"put\":{\"request\":[{\"name\":\"table\",\"type\":\"bytes\"},{\"name\":\"put\",\"type\":\"APut\"}],\"response\":\"null\",\"errors\":[\"AIOError\"]},\"delete\":{\"request\":[{\"name\":\"table\",\"type\":\"bytes\"},{\"name\":\"delete\",\"type\":\"ADelete\"}],\"response\":\"null\",\"errors\":[\"AIOError\"]},\"incrementColumnValue\":{\"request\":[{\"name\":\"table\",\"type\":\"bytes\"},{\"name\":\"row\",\"type\":\"bytes\"},{\"name\":\"family\",\"type\":\"bytes\"},{\"name\":\"qualifier\",\"type\":\"bytes\"},{\"name\":\"amount\",\"type\":\"long\"},{\"name\":\"writeToWAL\",\"type\":\"boolean\"}],\"response\":\"long\",\"errors\":[\"AIOError\"]},\"scannerOpen\":{\"request\":[{\"name\":\"table\",\"type\":\"bytes\"},{\"name\":\"scan\",\"type\":\"AScan\"}],\"response\":\"int\",\"errors\":[\"AIOError\"]},\"scannerClose\":{\"request\":[{\"name\":\"scannerId\",\"type\":\"int\"}],\"response\":\"null\",\"errors\":[\"AIOError\",\"AIllegalArgument\"]},\"scannerGetRows\":{\"request\":[{\"name\":\"scannerId\",\"type\":\"int\"},{\"name\":\"numberOfRows\",\"type\":\"int\"}],\"response\":{\"type\":\"array\",\"items\":\"AResult\"},\"errors\":[\"AIOError\",\"AIllegalArgument\"]}}}");

    public CharSequence getHBaseVersion() throws AvroRemoteException, AIOError;

    public AClusterStatus getClusterStatus() throws AvroRemoteException, AIOError;

    public List<ATableDescriptor> listTables() throws AvroRemoteException, AIOError;

    public ATableDescriptor describeTable(ByteBuffer var1) throws AvroRemoteException, AIOError;

    public boolean isTableEnabled(ByteBuffer var1) throws AvroRemoteException, AIOError;

    public boolean tableExists(ByteBuffer var1) throws AvroRemoteException, AIOError;

    public AFamilyDescriptor describeFamily(ByteBuffer var1, ByteBuffer var2) throws AvroRemoteException, AIOError;

    public Void createTable(ATableDescriptor var1) throws AvroRemoteException, AIOError, AIllegalArgument, ATableExists, AMasterNotRunning;

    public Void deleteTable(ByteBuffer var1) throws AvroRemoteException, AIOError;

    public Void modifyTable(ByteBuffer var1, ATableDescriptor var2) throws AvroRemoteException, AIOError;

    public Void enableTable(ByteBuffer var1) throws AvroRemoteException, AIOError;

    public Void disableTable(ByteBuffer var1) throws AvroRemoteException, AIOError;

    public Void flush(ByteBuffer var1) throws AvroRemoteException, AIOError;

    public Void split(ByteBuffer var1) throws AvroRemoteException, AIOError;

    public Void addFamily(ByteBuffer var1, AFamilyDescriptor var2) throws AvroRemoteException, AIOError;

    public Void deleteFamily(ByteBuffer var1, ByteBuffer var2) throws AvroRemoteException, AIOError;

    public Void modifyFamily(ByteBuffer var1, ByteBuffer var2, AFamilyDescriptor var3) throws AvroRemoteException, AIOError;

    public AResult get(ByteBuffer var1, AGet var2) throws AvroRemoteException, AIOError;

    public boolean exists(ByteBuffer var1, AGet var2) throws AvroRemoteException, AIOError;

    public Void put(ByteBuffer var1, APut var2) throws AvroRemoteException, AIOError;

    public Void delete(ByteBuffer var1, ADelete var2) throws AvroRemoteException, AIOError;

    public long incrementColumnValue(ByteBuffer var1, ByteBuffer var2, ByteBuffer var3, ByteBuffer var4, long var5, boolean var7) throws AvroRemoteException, AIOError;

    public int scannerOpen(ByteBuffer var1, AScan var2) throws AvroRemoteException, AIOError;

    public Void scannerClose(int var1) throws AvroRemoteException, AIOError, AIllegalArgument;

    public List<AResult> scannerGetRows(int var1, int var2) throws AvroRemoteException, AIOError, AIllegalArgument;

    public static interface Callback
    extends HBase {
        public static final Protocol PROTOCOL = PROTOCOL;

        public void getHBaseVersion(org.apache.avro.ipc.Callback<CharSequence> var1) throws IOException;

        public void getClusterStatus(org.apache.avro.ipc.Callback<AClusterStatus> var1) throws IOException;

        public void listTables(org.apache.avro.ipc.Callback<List<ATableDescriptor>> var1) throws IOException;

        public void describeTable(ByteBuffer var1, org.apache.avro.ipc.Callback<ATableDescriptor> var2) throws IOException;

        public void isTableEnabled(ByteBuffer var1, org.apache.avro.ipc.Callback<Boolean> var2) throws IOException;

        public void tableExists(ByteBuffer var1, org.apache.avro.ipc.Callback<Boolean> var2) throws IOException;

        public void describeFamily(ByteBuffer var1, ByteBuffer var2, org.apache.avro.ipc.Callback<AFamilyDescriptor> var3) throws IOException;

        public void createTable(ATableDescriptor var1, org.apache.avro.ipc.Callback<Void> var2) throws IOException;

        public void deleteTable(ByteBuffer var1, org.apache.avro.ipc.Callback<Void> var2) throws IOException;

        public void modifyTable(ByteBuffer var1, ATableDescriptor var2, org.apache.avro.ipc.Callback<Void> var3) throws IOException;

        public void enableTable(ByteBuffer var1, org.apache.avro.ipc.Callback<Void> var2) throws IOException;

        public void disableTable(ByteBuffer var1, org.apache.avro.ipc.Callback<Void> var2) throws IOException;

        public void flush(ByteBuffer var1, org.apache.avro.ipc.Callback<Void> var2) throws IOException;

        public void split(ByteBuffer var1, org.apache.avro.ipc.Callback<Void> var2) throws IOException;

        public void addFamily(ByteBuffer var1, AFamilyDescriptor var2, org.apache.avro.ipc.Callback<Void> var3) throws IOException;

        public void deleteFamily(ByteBuffer var1, ByteBuffer var2, org.apache.avro.ipc.Callback<Void> var3) throws IOException;

        public void modifyFamily(ByteBuffer var1, ByteBuffer var2, AFamilyDescriptor var3, org.apache.avro.ipc.Callback<Void> var4) throws IOException;

        public void get(ByteBuffer var1, AGet var2, org.apache.avro.ipc.Callback<AResult> var3) throws IOException;

        public void exists(ByteBuffer var1, AGet var2, org.apache.avro.ipc.Callback<Boolean> var3) throws IOException;

        public void put(ByteBuffer var1, APut var2, org.apache.avro.ipc.Callback<Void> var3) throws IOException;

        public void delete(ByteBuffer var1, ADelete var2, org.apache.avro.ipc.Callback<Void> var3) throws IOException;

        public void incrementColumnValue(ByteBuffer var1, ByteBuffer var2, ByteBuffer var3, ByteBuffer var4, long var5, boolean var7, org.apache.avro.ipc.Callback<Long> var8) throws IOException;

        public void scannerOpen(ByteBuffer var1, AScan var2, org.apache.avro.ipc.Callback<Integer> var3) throws IOException;

        public void scannerClose(int var1, org.apache.avro.ipc.Callback<Void> var2) throws IOException;

        public void scannerGetRows(int var1, int var2, org.apache.avro.ipc.Callback<List<AResult>> var3) throws IOException;
    }
}

