/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import com.google.common.base.Joiner;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.MinMaxPriorityQueue;
import com.google.common.collect.Sets;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.HDFSBlocksDistribution;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.master.LoadBalancer;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.RegionPlan;
import org.apache.hadoop.hbase.master.ServerAndLoad;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.util.Bytes;

public class DefaultLoadBalancer
implements LoadBalancer {
    private static final Log LOG = LogFactory.getLog(LoadBalancer.class);
    private static final Random RANDOM = new Random(System.currentTimeMillis());
    private float slop;
    private Configuration config;
    private ClusterStatus status;
    private MasterServices services;
    RegionInfoComparator riComparator = new RegionInfoComparator();
    RegionPlanComparator rpComparator = new RegionPlanComparator();

    @Override
    public void setClusterStatus(ClusterStatus st) {
        this.status = st;
    }

    @Override
    public void setMasterServices(MasterServices masterServices) {
        this.services = masterServices;
    }

    public void setConf(Configuration conf) {
        this.slop = conf.getFloat("hbase.regions.slop", 0.2f);
        if (this.slop < 0.0f) {
            this.slop = 0.0f;
        } else if (this.slop > 1.0f) {
            this.slop = 1.0f;
        }
        this.config = conf;
    }

    public Configuration getConf() {
        return this.config;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<RegionPlan> balanceCluster(Map<ServerName, List<HRegionInfo>> clusterState) {
        Map.Entry entry;
        int regionCount;
        int max;
        boolean emptyRegionServerPresent = false;
        long startTime = System.currentTimeMillis();
        int numServers = clusterState.size();
        if (numServers == 0) {
            LOG.debug((Object)"numServers=0 so skipping load balancing");
            return null;
        }
        TreeMap<ServerAndLoad, List<HRegionInfo>> serversByLoad = new TreeMap<ServerAndLoad, List<HRegionInfo>>();
        int numRegions = 0;
        int maxRegionCountPerServer = 0;
        for (Map.Entry<ServerName, List<HRegionInfo>> server2 : clusterState.entrySet()) {
            List<HRegionInfo> regions = server2.getValue();
            int sz = regions.size();
            if (sz == 0) {
                emptyRegionServerPresent = true;
            }
            numRegions += sz;
            if (maxRegionCountPerServer < sz) {
                maxRegionCountPerServer = sz;
            }
            serversByLoad.put(new ServerAndLoad(server2.getKey(), sz), regions);
        }
        float average = (float)numRegions / (float)numServers;
        int floor = (int)Math.floor(average * (1.0f - this.slop));
        int ceiling = (int)Math.ceil(average * (1.0f + this.slop));
        if (((ServerAndLoad)serversByLoad.lastKey()).getLoad() <= ceiling && ((ServerAndLoad)serversByLoad.firstKey()).getLoad() >= floor) {
            LOG.info((Object)("Skipping load balancing because balanced cluster; servers=" + numServers + " " + "regions=" + numRegions + " average=" + average + " " + "mostloaded=" + ((ServerAndLoad)serversByLoad.lastKey()).getLoad() + " leastloaded=" + ((ServerAndLoad)serversByLoad.firstKey()).getLoad()));
            return null;
        }
        int min = numRegions / numServers;
        int n = max = numRegions % numServers == 0 ? min : min + 1;
        if (maxRegionCountPerServer == 1) {
            return null;
        }
        StringBuilder strBalanceParam = new StringBuilder();
        strBalanceParam.append("Balance parameter: numRegions=").append(numRegions).append(", numServers=").append(numServers).append(", max=").append(max).append(", min=").append(min);
        LOG.debug((Object)strBalanceParam.toString());
        MinMaxPriorityQueue regionsToMove = MinMaxPriorityQueue.orderedBy((Comparator)this.rpComparator).create();
        ArrayList<RegionPlan> regionsToReturn = new ArrayList<RegionPlan>();
        int serversOverloaded = 0;
        boolean fetchFromTail = false;
        TreeMap<ServerName, BalanceInfo> serverBalanceInfo = new TreeMap<ServerName, BalanceInfo>();
        for (Map.Entry server3 : serversByLoad.descendingMap().entrySet()) {
            ServerAndLoad sal = (ServerAndLoad)server3.getKey();
            int regionCount2 = sal.getLoad();
            if (regionCount2 <= max) {
                serverBalanceInfo.put(sal.getServerName(), new BalanceInfo(0, 0));
                break;
            }
            ++serversOverloaded;
            List regions = (List)server3.getValue();
            int numToOffload = Math.min(regionCount2 - max, regions.size());
            Collections.sort(regions, this.riComparator);
            int numTaken = 0;
            for (int i = 0; i <= numToOffload; ++i) {
                void var28_39;
                HRegionInfo hRegionInfo = (HRegionInfo)((Object)regions.get(i));
                if (!fetchFromTail) continue;
                HRegionInfo hRegionInfo2 = (HRegionInfo)((Object)regions.get(regions.size() - 1 - i));
                if (var28_39.isMetaRegion()) continue;
                regionsToMove.add((Object)new RegionPlan((HRegionInfo)var28_39, sal.getServerName(), null));
                if (++numTaken >= numToOffload) break;
                if (!emptyRegionServerPresent) continue;
                fetchFromTail = !fetchFromTail;
            }
            serverBalanceInfo.put(sal.getServerName(), new BalanceInfo(numToOffload, -1 * numTaken));
        }
        int totalNumMoved = regionsToMove.size();
        int neededRegions = 0;
        fetchFromTail = false;
        HashMap<ServerName, Integer> underloadedServers = new HashMap<ServerName, Integer>();
        int maxToTake = numRegions - (int)average;
        for (Map.Entry server4 : serversByLoad.entrySet()) {
            if (maxToTake == 0) break;
            int regionCount3 = ((ServerAndLoad)server4.getKey()).getLoad();
            if (regionCount3 >= min && regionCount3 > 0) continue;
            int regionsToPut = min - regionCount3;
            if (regionsToPut == 0) {
                regionsToPut = 1;
                --maxToTake;
            }
            underloadedServers.put(((ServerAndLoad)server4.getKey()).getServerName(), regionsToPut);
        }
        int serversUnderloaded = underloadedServers.size();
        int incr = 1;
        List<ServerName> sns = Arrays.asList(underloadedServers.keySet().toArray(new ServerName[serversUnderloaded]));
        Collections.shuffle(sns, RANDOM);
        while (regionsToMove.size() > 0) {
            int n2;
            int cnt = 0;
            int n3 = n2 = incr > 0 ? 0 : underloadedServers.size() - 1;
            while (n2 >= 0 && n2 < underloadedServers.size() && !regionsToMove.isEmpty()) {
                ServerName si = sns.get(n2);
                int numToTake = (Integer)underloadedServers.get(si);
                if (numToTake != 0) {
                    this.addRegionPlan((MinMaxPriorityQueue<RegionPlan>)regionsToMove, fetchFromTail, si, regionsToReturn);
                    if (emptyRegionServerPresent) {
                        fetchFromTail = !fetchFromTail;
                    }
                    underloadedServers.put(si, numToTake - 1);
                    ++cnt;
                    BalanceInfo bi = (BalanceInfo)serverBalanceInfo.get(si);
                    if (bi == null) {
                        bi = new BalanceInfo(0, 0);
                        serverBalanceInfo.put(si, bi);
                    }
                    bi.setNumRegionsAdded(bi.getNumRegionsAdded() + 1);
                }
                n2 += incr;
            }
            if (cnt == 0) break;
            incr = -incr;
        }
        for (Integer n4 : underloadedServers.values()) {
            neededRegions += n4.intValue();
        }
        if (neededRegions == 0 && regionsToMove.isEmpty()) {
            long endTime = System.currentTimeMillis();
            LOG.info((Object)("Calculated a load balance in " + (endTime - startTime) + "ms. " + "Moving " + totalNumMoved + " regions off of " + serversOverloaded + " overloaded servers onto " + serversUnderloaded + " less loaded servers"));
            return regionsToReturn;
        }
        if (neededRegions != 0) {
            for (Map.Entry entry2 : serversByLoad.descendingMap().entrySet()) {
                int idx;
                BalanceInfo balanceInfo = (BalanceInfo)serverBalanceInfo.get(((ServerAndLoad)entry2.getKey()).getServerName());
                int n5 = idx = balanceInfo == null ? 0 : balanceInfo.getNextRegionForUnload();
                if (idx >= ((List)entry2.getValue()).size()) break;
                HRegionInfo region = (HRegionInfo)((Object)((List)entry2.getValue()).get(idx));
                if (region.isMetaRegion()) continue;
                regionsToMove.add((Object)new RegionPlan(region, ((ServerAndLoad)entry2.getKey()).getServerName(), null));
                ++totalNumMoved;
                if (--neededRegions != 0) continue;
                break;
            }
        }
        Iterator<Object> i$ = serversByLoad.entrySet().iterator();
        while (i$.hasNext() && (regionCount = ((ServerAndLoad)(entry = (Map.Entry)i$.next()).getKey()).getLoad()) < min) {
            BalanceInfo balanceInfo = (BalanceInfo)serverBalanceInfo.get(((ServerAndLoad)entry.getKey()).getServerName());
            if (balanceInfo != null) {
                regionCount += balanceInfo.getNumRegionsAdded();
            }
            if (regionCount >= min) continue;
            int numToTake = min - regionCount;
            for (int numTaken = 0; numTaken < numToTake && 0 < regionsToMove.size(); ++numTaken) {
                this.addRegionPlan((MinMaxPriorityQueue<RegionPlan>)regionsToMove, fetchFromTail, ((ServerAndLoad)entry.getKey()).getServerName(), regionsToReturn);
                if (!emptyRegionServerPresent) continue;
                fetchFromTail = !fetchFromTail;
            }
        }
        if (0 < regionsToMove.size()) {
            Map.Entry entry3;
            i$ = serversByLoad.entrySet().iterator();
            while (i$.hasNext() && (regionCount = ((ServerAndLoad)(entry3 = (Map.Entry)i$.next()).getKey()).getLoad()) < max) {
                this.addRegionPlan((MinMaxPriorityQueue<RegionPlan>)regionsToMove, fetchFromTail, ((ServerAndLoad)entry3.getKey()).getServerName(), regionsToReturn);
                if (emptyRegionServerPresent) {
                    boolean bl = fetchFromTail = !fetchFromTail;
                }
                if (!regionsToMove.isEmpty()) continue;
                break;
            }
        }
        long endTime = System.currentTimeMillis();
        if (!regionsToMove.isEmpty() || neededRegions != 0) {
            LOG.warn((Object)("regionsToMove=" + totalNumMoved + ", numServers=" + numServers + ", serversOverloaded=" + serversOverloaded + ", serversUnderloaded=" + serversUnderloaded));
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<ServerName, List<HRegionInfo>> e : clusterState.entrySet()) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(e.getKey().toString());
                sb.append(" ");
                sb.append(e.getValue().size());
            }
            LOG.warn((Object)("Input " + sb.toString()));
        }
        LOG.info((Object)("Done. Calculated a load balance in " + (endTime - startTime) + "ms. " + "Moving " + totalNumMoved + " regions off of " + serversOverloaded + " overloaded servers onto " + serversUnderloaded + " less loaded servers"));
        return regionsToReturn;
    }

    void addRegionPlan(MinMaxPriorityQueue<RegionPlan> regionsToMove, boolean fetchFromTail, ServerName sn, List<RegionPlan> regionsToReturn) {
        RegionPlan rp = null;
        rp = !fetchFromTail ? (RegionPlan)regionsToMove.remove() : (RegionPlan)regionsToMove.removeLast();
        rp.setDestination(sn);
        regionsToReturn.add(rp);
    }

    @Override
    public Map<ServerName, List<HRegionInfo>> roundRobinAssignment(List<HRegionInfo> regions, List<ServerName> servers) {
        if (regions.isEmpty() || servers.isEmpty()) {
            return null;
        }
        TreeMap<ServerName, List<HRegionInfo>> assignments = new TreeMap<ServerName, List<HRegionInfo>>();
        int numRegions = regions.size();
        int numServers = servers.size();
        int max = (int)Math.ceil((float)numRegions / (float)numServers);
        int serverIdx = 0;
        if (numServers > 1) {
            serverIdx = RANDOM.nextInt(numServers);
        }
        int regionIdx = 0;
        for (int j = 0; j < numServers; ++j) {
            ServerName server = servers.get((j + serverIdx) % numServers);
            ArrayList<HRegionInfo> serverRegions = new ArrayList<HRegionInfo>(max);
            for (int i = regionIdx; i < numRegions; i += numServers) {
                serverRegions.add(regions.get(i % numRegions));
            }
            assignments.put(server, serverRegions);
            ++regionIdx;
        }
        return assignments;
    }

    @Override
    public Map<ServerName, List<HRegionInfo>> retainAssignment(Map<HRegionInfo, ServerName> regions, List<ServerName> servers) {
        ArrayListMultimap serversByHostname = ArrayListMultimap.create();
        for (ServerName server : servers) {
            serversByHostname.put((Object)server.getHostname(), (Object)server);
        }
        TreeMap<ServerName, List<HRegionInfo>> assignments = new TreeMap<ServerName, List<HRegionInfo>>();
        for (ServerName server : servers) {
            assignments.put(server, new ArrayList());
        }
        TreeSet oldHostsNoLongerPresent = Sets.newTreeSet();
        int numRandomAssignments = 0;
        int numRetainedAssigments = 0;
        for (Map.Entry<HRegionInfo, ServerName> entry : regions.entrySet()) {
            HRegionInfo region = entry.getKey();
            ServerName oldServerName = entry.getValue();
            List localServers = new ArrayList();
            if (oldServerName != null) {
                localServers = serversByHostname.get((Object)oldServerName.getHostname());
            }
            if (localServers.isEmpty()) {
                ServerName randomServer = servers.get(RANDOM.nextInt(servers.size()));
                ((List)assignments.get(randomServer)).add(region);
                ++numRandomAssignments;
                if (oldServerName == null) continue;
                oldHostsNoLongerPresent.add(oldServerName.getHostname());
                continue;
            }
            if (localServers.size() == 1) {
                ((List)assignments.get(localServers.get(0))).add(region);
                ++numRetainedAssigments;
                continue;
            }
            int size = localServers.size();
            ServerName target = (ServerName)localServers.get(RANDOM.nextInt(size));
            ((List)assignments.get(target)).add(region);
            ++numRetainedAssigments;
        }
        String randomAssignMsg = "";
        if (numRandomAssignments > 0) {
            randomAssignMsg = numRandomAssignments + " regions were assigned " + "to random hosts, since the old hosts for these regions are no " + "longer present in the cluster. These hosts were:\n  " + Joiner.on((String)"\n  ").join((Iterable)oldHostsNoLongerPresent);
        }
        LOG.info((Object)("Reassigned " + regions.size() + " regions. " + numRetainedAssigments + " retained the pre-restart assignment. " + randomAssignMsg));
        return assignments;
    }

    private List<ServerName> getTopBlockLocations(FileSystem fs, HRegionInfo region) {
        List<ServerName> topServerNames = null;
        try {
            HTableDescriptor tableDescriptor = this.getTableDescriptor(region.getTableName());
            if (tableDescriptor != null) {
                HDFSBlocksDistribution blocksDistribution = HRegion.computeHDFSBlocksDistribution(this.config, tableDescriptor, region.getEncodedName());
                List<String> topHosts = blocksDistribution.getTopHosts();
                topServerNames = this.mapHostNameToServerName(topHosts);
            }
        }
        catch (IOException ioe) {
            LOG.debug((Object)("IOException during HDFSBlocksDistribution computation. for region = " + region.getEncodedName()), (Throwable)ioe);
        }
        return topServerNames;
    }

    private HTableDescriptor getTableDescriptor(byte[] tableName) throws IOException {
        HTableDescriptor tableDescriptor = null;
        try {
            if (this.services != null) {
                tableDescriptor = this.services.getTableDescriptors().get(Bytes.toString(tableName));
            }
        }
        catch (FileNotFoundException fnfe) {
            LOG.debug((Object)("FileNotFoundException during getTableDescriptors. Current table name = " + tableName), (Throwable)fnfe);
        }
        return tableDescriptor;
    }

    private List<ServerName> mapHostNameToServerName(List<String> hosts) {
        if (hosts == null || this.status == null) {
            return null;
        }
        ArrayList<ServerName> topServerNames = new ArrayList<ServerName>();
        Collection<ServerName> regionServers = this.status.getServers();
        HashMap<String, ServerName> hostToServerName = new HashMap<String, ServerName>();
        for (ServerName sn : regionServers) {
            hostToServerName.put(sn.getHostname(), sn);
        }
        for (String host : hosts) {
            ServerName sn = (ServerName)hostToServerName.get(host);
            if (sn == null) continue;
            topServerNames.add(sn);
        }
        return topServerNames;
    }

    @Override
    public Map<HRegionInfo, ServerName> immediateAssignment(List<HRegionInfo> regions, List<ServerName> servers) {
        TreeMap<HRegionInfo, ServerName> assignments = new TreeMap<HRegionInfo, ServerName>();
        for (HRegionInfo region : regions) {
            assignments.put(region, servers.get(RANDOM.nextInt(servers.size())));
        }
        return assignments;
    }

    @Override
    public ServerName randomAssignment(List<ServerName> servers) {
        if (servers == null || servers.isEmpty()) {
            LOG.warn((Object)"Wanted to do random assignment but no servers to assign to");
            return null;
        }
        return servers.get(RANDOM.nextInt(servers.size()));
    }

    private static class BalanceInfo {
        private final int nextRegionForUnload;
        private int numRegionsAdded;

        public BalanceInfo(int nextRegionForUnload, int numRegionsAdded) {
            this.nextRegionForUnload = nextRegionForUnload;
            this.numRegionsAdded = numRegionsAdded;
        }

        public int getNextRegionForUnload() {
            return this.nextRegionForUnload;
        }

        public int getNumRegionsAdded() {
            return this.numRegionsAdded;
        }

        public void setNumRegionsAdded(int numAdded) {
            this.numRegionsAdded = numAdded;
        }
    }

    private class RegionPlanComparator
    implements Comparator<RegionPlan> {
        private RegionPlanComparator() {
        }

        @Override
        public int compare(RegionPlan l, RegionPlan r) {
            long diff = r.getRegionInfo().getRegionId() - l.getRegionInfo().getRegionId();
            if (diff < 0L) {
                return -1;
            }
            if (diff > 0L) {
                return 1;
            }
            return 0;
        }
    }

    private static class RegionInfoComparator
    implements Comparator<HRegionInfo> {
        private RegionInfoComparator() {
        }

        @Override
        public int compare(HRegionInfo l, HRegionInfo r) {
            long diff = r.getRegionId() - l.getRegionId();
            if (diff < 0L) {
                return -1;
            }
            if (diff > 0L) {
                return 1;
            }
            return 0;
        }
    }
}

