/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.cleaner;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.master.cleaner.BaseLogCleanerDelegate;

@InterfaceAudience.Private
public class TimeToLiveLogCleaner
extends BaseLogCleanerDelegate {
    static final Log LOG = LogFactory.getLog((String)TimeToLiveLogCleaner.class.getName());
    private long ttl;
    private boolean stopped = false;

    @Override
    public boolean isLogDeletable(Path filePath) {
        long time = 0L;
        long currentTime = System.currentTimeMillis();
        try {
            FileStatus fStat = filePath.getFileSystem(this.getConf()).getFileStatus(filePath);
            time = fStat.getModificationTime();
        }
        catch (IOException e) {
            LOG.error((Object)("Unable to get modification time of file " + filePath.getName() + ", not deleting it."), (Throwable)e);
            return false;
        }
        long life = currentTime - time;
        if (life < 0L) {
            LOG.warn((Object)"Found a log newer than current time, probably a clock skew");
            return false;
        }
        return life > this.ttl;
    }

    @Override
    public void setConf(Configuration conf) {
        super.setConf(conf);
        this.ttl = conf.getLong("hbase.master.logcleaner.ttl", 600000L);
    }

    @Override
    public void stop(String why) {
        this.stopped = true;
    }

    @Override
    public boolean isStopped() {
        return this.stopped;
    }
}

