/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure;

import com.google.common.collect.MapMaker;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hbase.DaemonThreadFactory;
import org.apache.hadoop.hbase.errorhandling.ForeignException;
import org.apache.hadoop.hbase.procedure.ProcedureMemberRpcs;
import org.apache.hadoop.hbase.procedure.Subprocedure;
import org.apache.hadoop.hbase.procedure.SubprocedureFactory;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class ProcedureMember
implements Closeable {
    private static final Log LOG = LogFactory.getLog(ProcedureMember.class);
    private final SubprocedureFactory builder;
    private final ProcedureMemberRpcs rpcs;
    private final ConcurrentMap<String, Subprocedure> subprocs = new MapMaker().concurrencyLevel(4).weakValues().makeMap();
    private final ExecutorService pool;

    public ProcedureMember(ProcedureMemberRpcs rpcs, ThreadPoolExecutor pool, SubprocedureFactory factory) {
        this.pool = pool;
        this.rpcs = rpcs;
        this.builder = factory;
    }

    public static ThreadPoolExecutor defaultPool(long wakeFrequency, long keepAlive, int procThreads, String memberName) {
        return new ThreadPoolExecutor(1, procThreads, keepAlive, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new DaemonThreadFactory("member: '" + memberName + "' subprocedure-pool"));
    }

    ProcedureMemberRpcs getRpcs() {
        return this.rpcs;
    }

    public Subprocedure createSubprocedure(String opName, byte[] data) {
        return this.builder.buildSubprocedure(opName, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean submitSubprocedure(Subprocedure subproc) {
        Subprocedure rsub;
        if (subproc == null) {
            LOG.warn((Object)"Submitted null subprocedure, nothing to run here.");
            return false;
        }
        String procName = subproc.getName();
        if (procName == null || procName.length() == 0) {
            LOG.error((Object)"Subproc name cannot be null or the empty string");
            return false;
        }
        ConcurrentMap<String, Subprocedure> concurrentMap = this.subprocs;
        synchronized (concurrentMap) {
            rsub = (Subprocedure)this.subprocs.get(procName);
        }
        if (rsub != null) {
            if (!rsub.isComplete()) {
                LOG.error((Object)("Subproc '" + procName + "' is already running. Bailing out"));
                return false;
            }
            LOG.warn((Object)("A completed old subproc " + procName + " is still present, removing"));
            this.subprocs.remove(procName);
        }
        LOG.debug((Object)("Submitting new Subprocedure:" + procName));
        Future<Void> future = null;
        try {
            future = this.pool.submit(subproc);
            ConcurrentMap<String, Subprocedure> concurrentMap2 = this.subprocs;
            synchronized (concurrentMap2) {
                this.subprocs.put(procName, subproc);
            }
            return true;
        }
        catch (RejectedExecutionException e) {
            String msg = "Subprocedure pool is full!";
            subproc.cancel(msg, e.getCause());
            if (future != null) {
                future.cancel(true);
            }
            LOG.error((Object)("Failed to start subprocedure '" + procName + "'"));
            return false;
        }
    }

    public void receivedReachedGlobalBarrier(String procName) {
        Subprocedure subproc = (Subprocedure)this.subprocs.get(procName);
        if (subproc == null) {
            LOG.warn((Object)("Unexpected reached glabal barrier message for Sub-Procedure '" + procName + "'"));
            return;
        }
        subproc.receiveReachedGlobalBarrier();
    }

    @Override
    public void close() throws IOException {
        this.pool.shutdownNow();
    }

    boolean closeAndWait(long timeoutMs) throws InterruptedException {
        this.pool.shutdown();
        return this.pool.awaitTermination(timeoutMs, TimeUnit.MILLISECONDS);
    }

    public void controllerConnectionFailure(String message, IOException cause) {
        Collection toNotify = this.subprocs.values();
        LOG.error((Object)message, (Throwable)cause);
        for (Subprocedure sub : toNotify) {
            sub.cancel(message, cause);
        }
    }

    public void receiveAbortProcedure(String procName, ForeignException ee) {
        LOG.debug((Object)("Request received to abort procedure " + procName), (Throwable)ee);
        Subprocedure sub = (Subprocedure)this.subprocs.get(procName);
        if (sub == null) {
            LOG.info((Object)("Received abort on procedure with no local subprocedure " + procName + ", ignoring it."), (Throwable)ee);
            return;
        }
        LOG.error((Object)("Propagating foreign exception to subprocedure " + sub.getName()), (Throwable)ee);
        sub.monitor.receive(ee);
    }
}

