/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.metrics;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.mutable.MutableDouble;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.regionserver.metrics.RegionMetricsStorage;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;

public class SchemaMetrics {
    private static final Log LOG = LogFactory.getLog(SchemaMetrics.class);
    public static final String UNKNOWN = "__unknown";
    public static final String TABLE_PREFIX = "tbl.";
    public static final String CF_PREFIX = "cf.";
    public static final String BLOCK_TYPE_PREFIX = "bt.";
    public static final String REGION_PREFIX = "region.";
    public static final String CF_UNKNOWN_PREFIX = "cf.__unknown.";
    public static final String CF_BAD_FAMILY_PREFIX = "cf.__badfamily.";
    public static final boolean NO_COMPACTION = false;
    public static final String METRIC_GETSIZE = "getsize";
    public static final String METRIC_NEXTSIZE = "nextsize";
    public static final String TOTAL_KEY = "";
    private static final String META_BLOCK_CATEGORY_STR = "Meta";
    private static final int NUM_BLOCK_CATEGORIES = BlockType.BlockCategory.values().length;
    private static final int NUM_METRIC_TYPES = BlockMetricType.values().length;
    static final boolean[] BOOL_VALUES = new boolean[]{false, true};
    private static final int NUM_BLOCK_METRICS = NUM_BLOCK_CATEGORIES * BOOL_VALUES.length * NUM_METRIC_TYPES;
    private static final int NUM_STORE_METRIC_TYPES = StoreMetricType.values().length;
    private static final String SHOW_TABLE_NAME_CONF_KEY = "hbase.metrics.showTableName";
    private static final String MORE_CFS_OMITTED_STR = "__more";
    private static final int MAX_METRIC_PREFIX_LENGTH = 256 - "__more".length();
    private static final ConcurrentHashMap<String, SchemaMetrics> tableAndFamilyToMetrics = new ConcurrentHashMap();
    public static final SchemaMetrics ALL_SCHEMA_METRICS = SchemaMetrics.getInstance("", "");
    private static final long THRESHOLD_METRICS_FLUSH = 100L;
    private static volatile Boolean useTableNameGlobally;
    private static volatile boolean loggedConfInconsistency;
    private final String[] blockMetricNames = new String[NUM_BLOCK_METRICS];
    private final boolean[] blockMetricTimeVarying = new boolean[NUM_BLOCK_METRICS];
    private final String[] bloomMetricNames = new String[2];
    private final String[] storeMetricNames = new String[NUM_STORE_METRIC_TYPES];
    private final String[] storeMetricNamesMax = new String[NUM_STORE_METRIC_TYPES];
    private final AtomicLongArray onHitCacheMetrics = new AtomicLongArray(NUM_BLOCK_CATEGORIES * BOOL_VALUES.length);
    private static final String WORD_AND_DOT_RE_STR;
    private static final String TABLE_NAME_RE_STR;
    private static final String CF_NAME_RE_STR;
    private static final Pattern CF_NAME_RE;
    private static final Pattern TABLE_AND_CF_NAME_RE;
    private static final Pattern BLOCK_CATEGORY_RE;
    private static String NUM_OPS_SUFFIX;
    private static String TOTAL_SUFFIX;
    private static final Pattern TIME_VARYING_SUFFIX_RE;

    private SchemaMetrics(String tableName, String cfName) {
        String metricPrefix = SchemaMetrics.generateSchemaMetricsPrefix(tableName, cfName);
        for (BlockType.BlockCategory blockCategory : BlockType.BlockCategory.values()) {
            for (boolean isCompaction : BOOL_VALUES) {
                this.onHitCacheMetrics.set(SchemaMetrics.getCacheHitMetricIndex(blockCategory, isCompaction), 0L);
                for (BlockMetricType metricType : BlockMetricType.values()) {
                    if (!metricType.compactionAware && isCompaction) continue;
                    StringBuilder sb = new StringBuilder(metricPrefix);
                    if (blockCategory != BlockType.BlockCategory.ALL_CATEGORIES && blockCategory != BlockType.BlockCategory.META) {
                        String categoryStr = blockCategory.toString();
                        categoryStr = categoryStr.charAt(0) + categoryStr.substring(1).toLowerCase();
                        sb.append(BLOCK_TYPE_PREFIX + categoryStr + ".");
                    }
                    if (metricType.compactionAware) {
                        sb.append(isCompaction ? "compaction" : "fs");
                    }
                    if (blockCategory == BlockType.BlockCategory.META) {
                        sb.append(META_BLOCK_CATEGORY_STR);
                    }
                    sb.append((Object)metricType);
                    int i = SchemaMetrics.getBlockMetricIndex(blockCategory, isCompaction, metricType);
                    this.blockMetricNames[i] = sb.toString().intern();
                    this.blockMetricTimeVarying[i] = metricType.timeVarying;
                }
            }
        }
        boolean[] blArray = BOOL_VALUES;
        int len$ = blArray.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            boolean bl;
            this.bloomMetricNames[(bl = blArray[i$]) ? 1 : 0] = metricPrefix + (bl ? "keyMaybeInBloomCnt" : "keyNotInBloomCnt");
        }
        for (StoreMetricType storeMetricType : StoreMetricType.values()) {
            String coreName;
            this.storeMetricNames[storeMetricType.ordinal()] = coreName = metricPrefix + storeMetricType.toString();
            this.storeMetricNamesMax[storeMetricType.ordinal()] = coreName + ".max";
        }
    }

    public static SchemaMetrics getInstance(String tableName, String cfName) {
        String instanceKey;
        SchemaMetrics schemaMetrics;
        if (tableName == null) {
            tableName = UNKNOWN;
        }
        if (cfName == null) {
            cfName = UNKNOWN;
        }
        if ((schemaMetrics = tableAndFamilyToMetrics.get(instanceKey = (tableName = SchemaMetrics.getEffectiveTableName(tableName)) + "\t" + cfName)) != null) {
            return schemaMetrics;
        }
        schemaMetrics = new SchemaMetrics(tableName, cfName);
        SchemaMetrics existingMetrics = tableAndFamilyToMetrics.putIfAbsent(instanceKey, schemaMetrics);
        return existingMetrics != null ? existingMetrics : schemaMetrics;
    }

    private static final int getCacheHitMetricIndex(BlockType.BlockCategory blockCategory, boolean isCompaction) {
        return blockCategory.ordinal() * BOOL_VALUES.length + (isCompaction ? 1 : 0);
    }

    private static final int getBlockMetricIndex(BlockType.BlockCategory blockCategory, boolean isCompaction, BlockMetricType metricType) {
        int i = 0;
        i = i * NUM_BLOCK_CATEGORIES + blockCategory.ordinal();
        i = i * BOOL_VALUES.length + (isCompaction ? 1 : 0);
        i = i * NUM_METRIC_TYPES + metricType.ordinal();
        return i;
    }

    public String getBlockMetricName(BlockType.BlockCategory blockCategory, boolean isCompaction, BlockMetricType metricType) {
        if (isCompaction && !metricType.compactionAware) {
            throw new IllegalArgumentException("isCompaction cannot be true for " + (Object)((Object)metricType));
        }
        return this.blockMetricNames[SchemaMetrics.getBlockMetricIndex(blockCategory, isCompaction, metricType)];
    }

    public String getBloomMetricName(boolean isInBloom) {
        return this.bloomMetricNames[isInBloom ? 1 : 0];
    }

    private void incrNumericMetric(BlockType.BlockCategory blockCategory, boolean isCompaction, BlockMetricType metricType) {
        this.incrNumericMetric(blockCategory, isCompaction, metricType, 1L);
    }

    private void incrNumericMetric(BlockType.BlockCategory blockCategory, boolean isCompaction, BlockMetricType metricType, long amount) {
        if (blockCategory == null) {
            blockCategory = BlockType.BlockCategory.UNKNOWN;
        }
        RegionMetricsStorage.incrNumericMetric(this.getBlockMetricName(blockCategory, isCompaction, metricType), amount);
        if (blockCategory != BlockType.BlockCategory.ALL_CATEGORIES) {
            this.incrNumericMetric(BlockType.BlockCategory.ALL_CATEGORIES, isCompaction, metricType, amount);
        }
    }

    private void addToReadTime(BlockType.BlockCategory blockCategory, boolean isCompaction, long timeMs) {
        RegionMetricsStorage.incrTimeVaryingMetric(this.getBlockMetricName(blockCategory, isCompaction, BlockMetricType.READ_TIME), timeMs);
        if (blockCategory != BlockType.BlockCategory.ALL_CATEGORIES) {
            this.addToReadTime(BlockType.BlockCategory.ALL_CATEGORIES, isCompaction, timeMs);
        }
    }

    public void accumulateStoreMetric(Map<String, MutableDouble> tmpMap, StoreMetricType storeMetricType, double val) {
        String key = this.getStoreMetricName(storeMetricType);
        if (tmpMap.get(key) == null) {
            tmpMap.put(key, new MutableDouble(val));
        } else {
            tmpMap.get(key).add(val);
        }
        if (this == ALL_SCHEMA_METRICS) {
            String maxKey = this.getStoreMetricNameMax(storeMetricType);
            MutableDouble cur = tmpMap.get(maxKey);
            if (cur == null) {
                tmpMap.put(maxKey, new MutableDouble(val));
            } else if (cur.doubleValue() < val) {
                cur.setValue(val);
            }
        } else {
            ALL_SCHEMA_METRICS.accumulateStoreMetric(tmpMap, storeMetricType, val);
        }
    }

    public String getStoreMetricName(StoreMetricType storeMetricType) {
        return this.storeMetricNames[storeMetricType.ordinal()];
    }

    public String getStoreMetricNameMax(StoreMetricType storeMetricType) {
        return this.storeMetricNamesMax[storeMetricType.ordinal()];
    }

    public void updatePersistentStoreMetric(StoreMetricType storeMetricType, long value) {
        RegionMetricsStorage.incrNumericPersistentMetric(this.storeMetricNames[storeMetricType.ordinal()], value);
    }

    public void updateOnCacheHit(BlockType.BlockCategory blockCategory, boolean isCompaction) {
        this.updateOnCacheHit(blockCategory, isCompaction, 1L);
    }

    public void updateOnCacheHit(BlockType.BlockCategory blockCategory, boolean isCompaction, long count) {
        blockCategory.expectSpecific();
        int idx = SchemaMetrics.getCacheHitMetricIndex(blockCategory, isCompaction);
        if (this.onHitCacheMetrics.addAndGet(idx, count) > 100L) {
            this.flushCertainOnCacheHitMetrics(blockCategory, isCompaction);
        }
        if (this != ALL_SCHEMA_METRICS) {
            ALL_SCHEMA_METRICS.updateOnCacheHit(blockCategory, isCompaction, count);
        }
    }

    private void flushCertainOnCacheHitMetrics(BlockType.BlockCategory blockCategory, boolean isCompaction) {
        int idx = SchemaMetrics.getCacheHitMetricIndex(blockCategory, isCompaction);
        long tempCount = this.onHitCacheMetrics.getAndSet(idx, 0L);
        if (tempCount > 0L) {
            this.incrNumericMetric(blockCategory, isCompaction, BlockMetricType.CACHE_HIT, tempCount);
            this.incrNumericMetric(blockCategory, isCompaction, BlockMetricType.READ_COUNT, tempCount);
        }
    }

    private void flushOnCacheHitMetrics() {
        for (BlockType.BlockCategory blockCategory : BlockType.BlockCategory.values()) {
            for (boolean isCompaction : BOOL_VALUES) {
                this.flushCertainOnCacheHitMetrics(blockCategory, isCompaction);
            }
        }
        if (this != ALL_SCHEMA_METRICS) {
            ALL_SCHEMA_METRICS.flushOnCacheHitMetrics();
        }
    }

    public void flushMetrics() {
        this.flushOnCacheHitMetrics();
    }

    public void updateOnCacheMiss(BlockType.BlockCategory blockCategory, boolean isCompaction, long timeMs) {
        blockCategory.expectSpecific();
        this.addToReadTime(blockCategory, isCompaction, timeMs);
        this.incrNumericMetric(blockCategory, isCompaction, BlockMetricType.CACHE_MISS);
        this.incrNumericMetric(blockCategory, isCompaction, BlockMetricType.READ_COUNT);
        if (this != ALL_SCHEMA_METRICS) {
            ALL_SCHEMA_METRICS.updateOnCacheMiss(blockCategory, isCompaction, timeMs);
        }
    }

    public void addToCacheSize(BlockType.BlockCategory category, long cacheSizeDelta) {
        if (category == null) {
            category = BlockType.BlockCategory.ALL_CATEGORIES;
        }
        RegionMetricsStorage.incrNumericPersistentMetric(this.getBlockMetricName(category, false, BlockMetricType.CACHE_SIZE), cacheSizeDelta);
        if (category != BlockType.BlockCategory.ALL_CATEGORIES) {
            this.addToCacheSize(BlockType.BlockCategory.ALL_CATEGORIES, cacheSizeDelta);
        }
    }

    public void updateOnCachePutOrEvict(BlockType.BlockCategory blockCategory, long cacheSizeDelta, boolean isEviction) {
        this.addToCacheSize(blockCategory, cacheSizeDelta);
        this.incrNumericMetric(blockCategory, false, isEviction ? BlockMetricType.EVICTED : BlockMetricType.CACHED);
        if (this != ALL_SCHEMA_METRICS) {
            ALL_SCHEMA_METRICS.updateOnCachePutOrEvict(blockCategory, cacheSizeDelta, isEviction);
        }
    }

    public void updateBloomMetrics(boolean isInBloom) {
        RegionMetricsStorage.incrNumericMetric(this.getBloomMetricName(isInBloom), 1L);
        if (this != ALL_SCHEMA_METRICS) {
            ALL_SCHEMA_METRICS.updateBloomMetrics(isInBloom);
        }
    }

    public static void configureGlobally(Configuration conf) {
        if (conf != null) {
            boolean useTableNameNew = conf.getBoolean(SHOW_TABLE_NAME_CONF_KEY, false);
            SchemaMetrics.setUseTableName(useTableNameNew);
        } else {
            SchemaMetrics.setUseTableName(false);
        }
    }

    private static String getEffectiveTableName(String tableName) {
        if (!tableName.equals(TOTAL_KEY)) {
            if (useTableNameGlobally == null) {
                throw new IllegalStateException("The value of the hbase.metrics.showTableName conf option has not been specified in SchemaMetrics");
            }
            boolean useTableName = useTableNameGlobally;
            if (!useTableName) {
                tableName = TOTAL_KEY;
            }
        }
        return tableName;
    }

    public static String generateSchemaMetricsPrefix(String tableName, String cfName) {
        String schemaMetricPrefix = (tableName = SchemaMetrics.getEffectiveTableName(tableName)).equals(TOTAL_KEY) ? TOTAL_KEY : TABLE_PREFIX + tableName + ".";
        schemaMetricPrefix = schemaMetricPrefix + (cfName.equals(TOTAL_KEY) ? TOTAL_KEY : CF_PREFIX + cfName + ".");
        return schemaMetricPrefix;
    }

    public static String generateSchemaMetricsPrefix(byte[] tableName, byte[] cfName) {
        return SchemaMetrics.generateSchemaMetricsPrefix(Bytes.toString(tableName), Bytes.toString(cfName));
    }

    public static String generateSchemaMetricsPrefix(String tableName, Set<byte[]> families) {
        if (families == null || families.isEmpty() || tableName == null || tableName.isEmpty()) {
            return TOTAL_KEY;
        }
        if (families.size() == 1) {
            return SchemaMetrics.generateSchemaMetricsPrefix(tableName, Bytes.toString(families.iterator().next()));
        }
        tableName = SchemaMetrics.getEffectiveTableName(tableName);
        ArrayList<byte[]> sortedFamilies = new ArrayList<byte[]>(families);
        Collections.sort(sortedFamilies, Bytes.BYTES_COMPARATOR);
        StringBuilder sb = new StringBuilder();
        int numCFsLeft = families.size();
        for (byte[] family : sortedFamilies) {
            if (sb.length() > MAX_METRIC_PREFIX_LENGTH) {
                sb.append(MORE_CFS_OMITTED_STR);
                break;
            }
            sb.append(Bytes.toString(family));
            if (--numCFsLeft <= 0) continue;
            sb.append("~");
        }
        return SchemaMetrics.generateSchemaMetricsPrefix(tableName, sb.toString());
    }

    static String generateRegionMetricsPrefix(String tableName, String regionName) {
        String schemaMetricPrefix = (tableName = SchemaMetrics.getEffectiveTableName(tableName)).equals(TOTAL_KEY) ? TOTAL_KEY : TABLE_PREFIX + tableName + ".";
        schemaMetricPrefix = schemaMetricPrefix + (regionName.equals(TOTAL_KEY) ? TOTAL_KEY : REGION_PREFIX + regionName + ".");
        return schemaMetricPrefix;
    }

    private static void setUseTableName(boolean useTableNameNew) {
        if (useTableNameGlobally == null) {
            useTableNameGlobally = useTableNameNew;
        } else if (useTableNameGlobally != useTableNameNew && !loggedConfInconsistency) {
            LOG.error((Object)("Inconsistent configuration. Previous configuration for using table name in metrics: " + useTableNameGlobally + ", " + "new configuration: " + useTableNameNew));
            loggedConfInconsistency = true;
        }
    }

    private static final String regexEscape(String s) {
        return s.replace(".", "\\.");
    }

    void printMetricNames() {
        for (BlockType.BlockCategory blockCategory : BlockType.BlockCategory.values()) {
            for (boolean isCompaction : BOOL_VALUES) {
                for (BlockMetricType metricType : BlockMetricType.values()) {
                    int i = SchemaMetrics.getBlockMetricIndex(blockCategory, isCompaction, metricType);
                    LOG.debug((Object)("blockCategory=" + (Object)((Object)blockCategory) + ", " + "metricType=" + (Object)((Object)metricType) + ", isCompaction=" + isCompaction + ", metricName=" + this.blockMetricNames[i]));
                }
            }
        }
    }

    private Collection<String> getAllMetricNames() {
        ArrayList<String> allMetricNames = new ArrayList<String>();
        for (int i = 0; i < this.blockMetricNames.length; ++i) {
            String blockMetricName = this.blockMetricNames[i];
            boolean timeVarying = this.blockMetricTimeVarying[i];
            if (blockMetricName == null) continue;
            if (timeVarying) {
                allMetricNames.add(blockMetricName + NUM_OPS_SUFFIX);
                allMetricNames.add(blockMetricName + TOTAL_SUFFIX);
                continue;
            }
            allMetricNames.add(blockMetricName);
        }
        allMetricNames.addAll(Arrays.asList(this.bloomMetricNames));
        return allMetricNames;
    }

    private static final boolean isTimeVaryingKey(String metricKey) {
        return metricKey.endsWith(NUM_OPS_SUFFIX) || metricKey.endsWith(TOTAL_SUFFIX);
    }

    private static final String stripTimeVaryingSuffix(String metricKey) {
        return TIME_VARYING_SUFFIX_RE.matcher(metricKey).replaceAll(TOTAL_KEY);
    }

    public static Map<String, Long> getMetricsSnapshot() {
        TreeMap<String, Long> metricsSnapshot = new TreeMap<String, Long>();
        for (SchemaMetrics cfm : tableAndFamilyToMetrics.values()) {
            cfm.flushMetrics();
            for (String metricName : cfm.getAllMetricNames()) {
                long metricValue;
                if (SchemaMetrics.isTimeVaryingKey(metricName)) {
                    Pair<Long, Integer> totalAndCount = RegionMetricsStorage.getTimeVaryingMetric(SchemaMetrics.stripTimeVaryingSuffix(metricName));
                    metricValue = metricName.endsWith(TOTAL_SUFFIX) ? totalAndCount.getFirst() : (long)totalAndCount.getSecond().intValue();
                } else {
                    metricValue = RegionMetricsStorage.getNumericMetric(metricName);
                }
                metricsSnapshot.put(metricName, metricValue);
            }
        }
        return metricsSnapshot;
    }

    public static long getLong(Map<String, Long> m, String k) {
        Long l = m.get(k);
        return l != null ? l : 0L;
    }

    private static void putLong(Map<String, Long> m, String k, long v) {
        if (v != 0L) {
            m.put(k, v);
        } else {
            m.remove(k);
        }
    }

    public static Map<String, Long> diffMetrics(Map<String, Long> a, Map<String, Long> b) {
        TreeSet<String> allKeys = new TreeSet<String>(a.keySet());
        allKeys.addAll(b.keySet());
        TreeMap<String, Long> diff = new TreeMap<String, Long>();
        for (String k : allKeys) {
            long bVal;
            long aVal = SchemaMetrics.getLong(a, k);
            if (aVal == (bVal = SchemaMetrics.getLong(b, k))) continue;
            diff.put(k, bVal - aVal);
        }
        return diff;
    }

    public static void validateMetricChanges(Map<String, Long> oldMetrics) {
        long expected;
        Map<String, Long> newMetrics = SchemaMetrics.getMetricsSnapshot();
        TreeMap<String, Long> allCfDeltas = new TreeMap<String, Long>();
        TreeMap<String, Long> allBlockCategoryDeltas = new TreeMap<String, Long>();
        Map<String, Long> deltas = SchemaMetrics.diffMetrics(oldMetrics, newMetrics);
        Pattern cfTableMetricRE = useTableNameGlobally != false ? TABLE_AND_CF_NAME_RE : CF_NAME_RE;
        TreeSet<String> allKeys = new TreeSet<String>(oldMetrics.keySet());
        allKeys.addAll(newMetrics.keySet());
        for (SchemaMetrics cfm : tableAndFamilyToMetrics.values()) {
            for (String metricName : cfm.getAllMetricNames()) {
                Matcher matcher;
                if (metricName.startsWith("cf.cf.")) {
                    throw new AssertionError((Object)("Column family prefix used twice: " + metricName));
                }
                long oldValue = SchemaMetrics.getLong(oldMetrics, metricName);
                long newValue = SchemaMetrics.getLong(newMetrics, metricName);
                long delta = newValue - oldValue;
                if (delta != 0L) {
                    if (cfm != ALL_SCHEMA_METRICS) {
                        String aggregateMetricName = cfTableMetricRE.matcher(metricName).replaceAll(TOTAL_KEY);
                        if (!aggregateMetricName.equals(metricName)) {
                            LOG.debug((Object)("Counting " + delta + " units of " + metricName + " towards " + aggregateMetricName));
                            SchemaMetrics.putLong(allCfDeltas, aggregateMetricName, SchemaMetrics.getLong(allCfDeltas, aggregateMetricName) + delta);
                        }
                    } else {
                        LOG.debug((Object)("Metric=" + metricName + ", delta=" + delta));
                    }
                }
                if (!(matcher = BLOCK_CATEGORY_RE.matcher(metricName)).find()) continue;
                String metricNoBlockCategory = matcher.replaceAll(TOTAL_KEY);
                SchemaMetrics.putLong(allBlockCategoryDeltas, metricNoBlockCategory, SchemaMetrics.getLong(allBlockCategoryDeltas, metricNoBlockCategory) + delta);
            }
        }
        StringBuilder errors = new StringBuilder();
        for (String key : ALL_SCHEMA_METRICS.getAllMetricNames()) {
            long actual = SchemaMetrics.getLong(deltas, key);
            if (actual == (expected = SchemaMetrics.getLong(allCfDeltas, key))) continue;
            if (errors.length() > 0) {
                errors.append("\n");
            }
            errors.append("The all-CF metric " + key + " changed by " + actual + " but the aggregation of per-CF/table metrics " + "yields " + expected);
        }
        for (String key : allKeys) {
            long actual;
            if (BLOCK_CATEGORY_RE.matcher(key).find() || key.contains(ALL_SCHEMA_METRICS.getBloomMetricName(false)) || key.contains(ALL_SCHEMA_METRICS.getBloomMetricName(true)) || (actual = SchemaMetrics.getLong(deltas, key)) == (expected = SchemaMetrics.getLong(allBlockCategoryDeltas, key))) continue;
            if (errors.length() > 0) {
                errors.append("\n");
            }
            errors.append("The all-block-category metric " + key + " changed by " + actual + " but the aggregation of " + "per-block-category metrics yields " + expected);
        }
        if (errors.length() > 0) {
            throw new AssertionError((Object)errors.toString());
        }
    }

    public static SchemaMetrics getUnknownInstanceForTest() {
        return SchemaMetrics.getInstance(UNKNOWN, UNKNOWN);
    }

    public static void setUseTableNameInTest(boolean useTableNameNew) {
        useTableNameGlobally = useTableNameNew;
    }

    public static String formatMetrics(Map<String, Long> metrics) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Long> entry : metrics.entrySet()) {
            if (sb.length() > 0) {
                sb.append('\n');
            }
            sb.append(entry.getKey() + " : " + entry.getValue());
        }
        return sb.toString();
    }

    static {
        WORD_AND_DOT_RE_STR = "([^.]+|" + SchemaMetrics.regexEscape(Bytes.toString(HConstants.META_TABLE_NAME)) + ")\\.";
        TABLE_NAME_RE_STR = "\\b" + SchemaMetrics.regexEscape(TABLE_PREFIX) + WORD_AND_DOT_RE_STR;
        CF_NAME_RE_STR = "\\b" + SchemaMetrics.regexEscape(CF_PREFIX) + WORD_AND_DOT_RE_STR;
        CF_NAME_RE = Pattern.compile(CF_NAME_RE_STR);
        TABLE_AND_CF_NAME_RE = Pattern.compile(TABLE_NAME_RE_STR + CF_NAME_RE_STR);
        BLOCK_CATEGORY_RE = Pattern.compile("\\b" + SchemaMetrics.regexEscape(BLOCK_TYPE_PREFIX) + "[^.]+\\." + "|" + META_BLOCK_CATEGORY_STR + "(?=" + BlockMetricType.BLOCK_METRIC_TYPE_RE + ")");
        NUM_OPS_SUFFIX = "numops";
        TOTAL_SUFFIX = "_total";
        TIME_VARYING_SUFFIX_RE = Pattern.compile("(" + NUM_OPS_SUFFIX + "|" + TOTAL_SUFFIX + ")$");
    }

    public static enum StoreMetricType {
        STORE_FILE_COUNT("storeFileCount"),
        STORE_FILE_INDEX_SIZE("storeFileIndexSizeMB"),
        STORE_FILE_SIZE_MB("storeFileSizeMB"),
        STATIC_BLOOM_SIZE_KB("staticBloomSizeKB"),
        MEMSTORE_SIZE_MB("memstoreSizeMB"),
        STATIC_INDEX_SIZE_KB("staticIndexSizeKB"),
        FLUSH_SIZE("flushSize");

        private final String metricStr;

        private StoreMetricType(String metricStr) {
            this.metricStr = metricStr;
        }

        public String toString() {
            return this.metricStr;
        }
    }

    public static enum BlockMetricType {
        READ_TIME("Read", true, true),
        READ_COUNT("BlockReadCnt", true, false),
        CACHE_HIT("BlockReadCacheHitCnt", true, false),
        CACHE_MISS("BlockReadCacheMissCnt", true, false),
        CACHE_SIZE("blockCacheSize", false, false),
        CACHED("blockCacheNumCached", false, false),
        EVICTED("blockCacheNumEvicted", false, false);

        private final String metricStr;
        private final boolean compactionAware;
        private final boolean timeVarying;
        private static final String BLOCK_METRIC_TYPE_RE;

        private BlockMetricType(String metricStr, boolean compactionAware, boolean timeVarying) {
            this.metricStr = metricStr;
            this.compactionAware = compactionAware;
            this.timeVarying = timeVarying;
        }

        public String toString() {
            return this.metricStr;
        }

        static {
            StringBuilder sb = new StringBuilder();
            for (BlockMetricType bmt : BlockMetricType.values()) {
                if (sb.length() > 0) {
                    sb.append("|");
                }
                sb.append((Object)bmt);
            }
            BLOCK_METRIC_TYPE_RE = sb.toString();
        }
    }

    public static interface SchemaAware {
        public String getTableName();

        public String getColumnFamilyName();

        public SchemaMetrics getSchemaMetrics();
    }
}

