/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.io.HeapSize;
import org.apache.hadoop.hbase.regionserver.wal.CompressionContext;
import org.apache.hadoop.hbase.regionserver.wal.KeyValueCompression;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ClassSize;
import org.apache.hadoop.io.Writable;

public class WALEdit
implements Writable,
HeapSize {
    private final int VERSION_2 = -1;
    private final ArrayList<KeyValue> kvs = new ArrayList();
    private NavigableMap<byte[], Integer> scopes;
    private CompressionContext compressionContext;

    public void setCompressionContext(CompressionContext compressionContext) {
        this.compressionContext = compressionContext;
    }

    public void add(KeyValue kv) {
        this.kvs.add(kv);
    }

    public boolean isEmpty() {
        return this.kvs.isEmpty();
    }

    public int size() {
        return this.kvs.size();
    }

    public List<KeyValue> getKeyValues() {
        return this.kvs;
    }

    public NavigableMap<byte[], Integer> getScopes() {
        return this.scopes;
    }

    public void setScopes(NavigableMap<byte[], Integer> scopes) {
        this.scopes = scopes;
    }

    public void readFields(DataInput in) throws IOException {
        int versionOrLength;
        this.kvs.clear();
        if (this.scopes != null) {
            this.scopes.clear();
        }
        if ((versionOrLength = in.readInt()) == -1) {
            int numEdits = in.readInt();
            for (int idx = 0; idx < numEdits; ++idx) {
                if (this.compressionContext != null) {
                    this.add(KeyValueCompression.readKV(in, this.compressionContext));
                    continue;
                }
                KeyValue kv = new KeyValue();
                kv.readFields(in);
                this.add(kv);
            }
            int numFamilies = in.readInt();
            if (numFamilies > 0) {
                if (this.scopes == null) {
                    this.scopes = new TreeMap<byte[], Integer>(Bytes.BYTES_COMPARATOR);
                }
                for (int i = 0; i < numFamilies; ++i) {
                    byte[] fam = Bytes.readByteArray(in);
                    int scope = in.readInt();
                    this.scopes.put(fam, scope);
                }
            }
        } else {
            KeyValue kv = new KeyValue();
            kv.readFields(versionOrLength, in);
            this.add(kv);
        }
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(-1);
        out.writeInt(this.kvs.size());
        for (KeyValue kv : this.kvs) {
            if (this.compressionContext != null) {
                KeyValueCompression.writeKV(out, kv, this.compressionContext);
                continue;
            }
            kv.write(out);
        }
        if (this.scopes == null) {
            out.writeInt(0);
        } else {
            out.writeInt(this.scopes.size());
            for (byte[] key : this.scopes.keySet()) {
                Bytes.writeByteArray(out, key);
                out.writeInt((Integer)this.scopes.get(key));
            }
        }
    }

    @Override
    public long heapSize() {
        long ret = 0L;
        for (KeyValue kv : this.kvs) {
            ret += kv.heapSize();
        }
        if (this.scopes != null) {
            ret += (long)ClassSize.TREEMAP;
            ret += (long)ClassSize.align(this.scopes.size() * ClassSize.MAP_ENTRY);
        }
        return ret;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[#edits: " + this.kvs.size() + " = <");
        for (KeyValue kv : this.kvs) {
            sb.append(kv.toString());
            sb.append("; ");
        }
        if (this.scopes != null) {
            sb.append(" scopes: " + this.scopes.toString());
        }
        sb.append(">]");
        return sb.toString();
    }
}

