/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import java.io.IOException;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.regionserver.ReplicationSinkService;
import org.apache.hadoop.hbase.regionserver.ReplicationSourceService;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.regionserver.wal.HLogKey;
import org.apache.hadoop.hbase.regionserver.wal.WALActionsListener;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.replication.ReplicationZookeeper;
import org.apache.hadoop.hbase.replication.master.ReplicationLogCleaner;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSink;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSourceManager;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.zookeeper.KeeperException;

public class Replication
implements WALActionsListener,
ReplicationSourceService,
ReplicationSinkService {
    private boolean replication;
    private ReplicationSourceManager replicationManager;
    private final AtomicBoolean replicating = new AtomicBoolean(true);
    private ReplicationZookeeper zkHelper;
    private Configuration conf;
    private ReplicationSink replicationSink;
    private Server server;

    public Replication(Server server, FileSystem fs, Path logDir, Path oldLogDir) throws IOException {
        this.initialize(server, fs, logDir, oldLogDir);
    }

    public Replication() {
    }

    @Override
    public void initialize(Server server, FileSystem fs, Path logDir, Path oldLogDir) throws IOException {
        this.server = server;
        this.conf = this.server.getConfiguration();
        this.replication = Replication.isReplication(this.conf);
        if (this.replication) {
            try {
                this.zkHelper = new ReplicationZookeeper(server, this.replicating);
            }
            catch (KeeperException ke) {
                throw new IOException("Failed replication handler create (replicating=" + this.replicating, ke);
            }
            this.replicationManager = new ReplicationSourceManager(this.zkHelper, this.conf, this.server, fs, this.replicating, logDir, oldLogDir);
        } else {
            this.replicationManager = null;
            this.zkHelper = null;
        }
    }

    public static boolean isReplication(Configuration c) {
        return c.getBoolean("hbase.replication", false);
    }

    @Override
    public WALActionsListener getWALActionsListener() {
        return this;
    }

    @Override
    public void stopReplicationService() {
        this.join();
    }

    public void join() {
        if (this.replication) {
            this.replicationManager.join();
            this.replicationSink.stopReplicationSinkServices();
        }
    }

    @Override
    public void replicateLogEntries(HLog.Entry[] entries) throws IOException {
        if (this.replication) {
            this.replicationSink.replicateEntries(entries);
        }
    }

    @Override
    public void startReplicationService() throws IOException {
        if (this.replication) {
            this.replicationManager.init();
            this.replicationSink = new ReplicationSink(this.conf, this.server);
        }
    }

    public ReplicationSourceManager getReplicationManager() {
        return this.replicationManager;
    }

    @Override
    public void visitLogEntryBeforeWrite(HRegionInfo info, HLogKey logKey, WALEdit logEdit) {
    }

    @Override
    public void visitLogEntryBeforeWrite(HTableDescriptor htd, HLogKey logKey, WALEdit logEdit) {
        TreeMap<byte[], Integer> scopes = new TreeMap<byte[], Integer>(Bytes.BYTES_COMPARATOR);
        for (KeyValue kv : logEdit.getKeyValues()) {
            byte[] family = kv.getFamily();
            int scope = htd.getFamily(family).getScope();
            if (scope == 0 || scopes.containsKey(family)) continue;
            scopes.put(family, scope);
        }
        if (!scopes.isEmpty()) {
            logEdit.setScopes(scopes);
        }
    }

    @Override
    public void preLogRoll(Path oldPath, Path newPath) throws IOException {
        this.getReplicationManager().preLogRoll(newPath);
    }

    @Override
    public void postLogRoll(Path oldPath, Path newPath) throws IOException {
        this.getReplicationManager().postLogRoll(newPath);
    }

    @Override
    public void preLogArchive(Path oldPath, Path newPath) throws IOException {
    }

    @Override
    public void postLogArchive(Path oldPath, Path newPath) throws IOException {
    }

    public static void decorateMasterConfiguration(Configuration conf) {
        if (!Replication.isReplication(conf)) {
            return;
        }
        String plugins = conf.get("hbase.master.logcleaner.plugins");
        if (!plugins.contains(ReplicationLogCleaner.class.toString())) {
            conf.set("hbase.master.logcleaner.plugins", plugins + "," + ReplicationLogCleaner.class.getCanonicalName());
        }
    }

    @Override
    public void logRollRequested() {
    }

    @Override
    public void logCloseRequested() {
    }
}

