/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import com.sun.jersey.spi.container.servlet.ServletContainer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.rest.Constants;
import org.apache.hadoop.hbase.rest.RESTServlet;
import org.apache.hadoop.hbase.rest.ResourceConfig;
import org.apache.hadoop.hbase.rest.filter.GzipFilter;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.util.InfoServer;
import org.apache.hadoop.hbase.util.Strings;
import org.apache.hadoop.hbase.util.VersionInfo;
import org.apache.hadoop.net.DNS;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.nio.SelectChannelConnector;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.thread.QueuedThreadPool;
import org.mortbay.thread.ThreadPool;

public class Main
implements Constants {
    private static void printUsageAndExit(Options options, int exitCode) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("bin/hbase rest start", "", options, "\nTo run the REST server as a daemon, execute bin/hbase-daemon.sh start|stop rest [--infoport <port>] [-p <port>] [-ro]\n", true);
        System.exit(exitCode);
    }

    public static void main(String[] args) throws Exception {
        String command;
        List remainingArgs;
        String val;
        Log LOG = LogFactory.getLog((String)"RESTServer");
        VersionInfo.logVersion();
        Configuration conf = HBaseConfiguration.create();
        if (User.isSecurityEnabled() && User.isHBaseSecurityEnabled(conf)) {
            String machineName = Strings.domainNamePointerToHostName(DNS.getDefaultHost((String)conf.get("hbase.rest.dns.interface", "default"), (String)conf.get("hbase.rest.dns.nameserver", "default")));
            User.login(conf, "hbase.rest.keytab.file", "hbase.rest.kerberos.principal", machineName);
        }
        RESTServlet servlet = RESTServlet.getInstance(conf);
        Options options = new Options();
        options.addOption("p", "port", true, "Port to bind to [default: 8080]");
        options.addOption("ro", "readonly", false, "Respond only to GET HTTP method requests [default: false]");
        options.addOption(null, "infoport", true, "Port for web UI");
        CommandLine commandLine = null;
        try {
            commandLine = new PosixParser().parse(options, args);
        }
        catch (ParseException e) {
            LOG.error((Object)"Could not parse: ", (Throwable)e);
            Main.printUsageAndExit(options, -1);
        }
        if (commandLine != null && commandLine.hasOption("port")) {
            val = commandLine.getOptionValue("port");
            servlet.getConfiguration().setInt("hbase.rest.port", Integer.valueOf(val).intValue());
            LOG.debug((Object)("port set to " + val));
        }
        if (commandLine != null && commandLine.hasOption("readonly")) {
            servlet.getConfiguration().setBoolean("hbase.rest.readonly", true);
            LOG.debug((Object)"readonly set to true");
        }
        if (commandLine != null && commandLine.hasOption("infoport")) {
            val = commandLine.getOptionValue("infoport");
            servlet.getConfiguration().setInt("hbase.rest.info.port", Integer.valueOf(val).intValue());
            LOG.debug((Object)("Web UI port set to " + val));
        }
        List list = remainingArgs = commandLine != null ? commandLine.getArgList() : new ArrayList();
        if (remainingArgs.size() != 1) {
            Main.printUsageAndExit(options, 1);
        }
        if (!"start".equals(command = (String)remainingArgs.get(0))) {
            if ("stop".equals(command)) {
                System.exit(1);
            } else {
                Main.printUsageAndExit(options, 1);
            }
        }
        ServletHolder sh = new ServletHolder(ServletContainer.class);
        sh.setInitParameter("com.sun.jersey.config.property.resourceConfigClass", ResourceConfig.class.getCanonicalName());
        sh.setInitParameter("com.sun.jersey.config.property.packages", "jetty");
        Server server = new Server();
        SelectChannelConnector connector = new SelectChannelConnector();
        connector.setPort(servlet.getConfiguration().getInt("hbase.rest.port", 8080));
        connector.setHost(servlet.getConfiguration().get("hbase.rest.host", "0.0.0.0"));
        server.addConnector((Connector)connector);
        int maxThreads = servlet.getConfiguration().getInt("hbase.rest.threads.max", 100);
        int minThreads = servlet.getConfiguration().getInt("hbase.rest.threads.min", 2);
        QueuedThreadPool threadPool = new QueuedThreadPool(maxThreads);
        threadPool.setMinThreads(minThreads);
        server.setThreadPool((ThreadPool)threadPool);
        server.setSendServerVersion(false);
        server.setSendDateHeader(false);
        server.setStopAtShutdown(true);
        Context context = new Context((HandlerContainer)server, "/", 1);
        context.addServlet(sh, "/*");
        context.addFilter(GzipFilter.class, "/*", 0);
        int port = conf.getInt("hbase.rest.info.port", 8085);
        if (port >= 0) {
            conf.setLong("startcode", System.currentTimeMillis());
            String a = conf.get("hbase.rest.info.bindAddress", "0.0.0.0");
            InfoServer infoServer = new InfoServer("rest", a, port, false, conf);
            infoServer.setAttribute("hbase.conf", conf);
            infoServer.start();
        }
        server.start();
        server.join();
    }
}

