/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.thrift2;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.thrift2.generated.TColumn;
import org.apache.hadoop.hbase.thrift2.generated.TColumnIncrement;
import org.apache.hadoop.hbase.thrift2.generated.TColumnValue;
import org.apache.hadoop.hbase.thrift2.generated.TDelete;
import org.apache.hadoop.hbase.thrift2.generated.TDeleteType;
import org.apache.hadoop.hbase.thrift2.generated.TGet;
import org.apache.hadoop.hbase.thrift2.generated.TIncrement;
import org.apache.hadoop.hbase.thrift2.generated.TPut;
import org.apache.hadoop.hbase.thrift2.generated.TResult;
import org.apache.hadoop.hbase.thrift2.generated.TScan;
import org.apache.hadoop.hbase.thrift2.generated.TTimeRange;

public class ThriftUtilities {
    private ThriftUtilities() {
        throw new UnsupportedOperationException("Can't initialize class");
    }

    public static Get getFromThrift(TGet in) throws IOException {
        Get out = new Get(in.getRow());
        if (in.isSetTimestamp()) {
            out.setTimeStamp(in.getTimestamp());
        } else if (in.isSetTimeRange()) {
            out.setTimeRange(in.getTimeRange().getMinStamp(), in.getTimeRange().getMaxStamp());
        }
        if (in.isSetMaxVersions()) {
            out.setMaxVersions(in.getMaxVersions());
        }
        if (!in.isSetColumns()) {
            return out;
        }
        for (TColumn column : in.getColumns()) {
            if (column.isSetQualifier()) {
                out.addColumn(column.getFamily(), column.getQualifier());
                continue;
            }
            out.addFamily(column.getFamily());
        }
        return out;
    }

    public static List<Get> getsFromThrift(List<TGet> in) throws IOException {
        ArrayList<Get> out = new ArrayList<Get>(in.size());
        for (TGet get2 : in) {
            out.add(ThriftUtilities.getFromThrift(get2));
        }
        return out;
    }

    public static TResult resultFromHBase(Result in) {
        KeyValue[] raw = in.raw();
        TResult out = new TResult();
        byte[] row = in.getRow();
        if (row != null) {
            out.setRow(in.getRow());
        }
        ArrayList<TColumnValue> columnValues = new ArrayList<TColumnValue>();
        for (KeyValue kv : raw) {
            TColumnValue col = new TColumnValue();
            col.setFamily(kv.getFamily());
            col.setQualifier(kv.getQualifier());
            col.setTimestamp(kv.getTimestamp());
            col.setValue(kv.getValue());
            columnValues.add(col);
        }
        out.setColumnValues(columnValues);
        return out;
    }

    public static List<TResult> resultsFromHBase(Result[] in) {
        ArrayList<TResult> out = new ArrayList<TResult>(in.length);
        for (Result result : in) {
            out.add(ThriftUtilities.resultFromHBase(result));
        }
        return out;
    }

    public static Put putFromThrift(TPut in) {
        Put out = in.isSetTimestamp() ? new Put(in.getRow(), in.getTimestamp(), null) : new Put(in.getRow());
        out.setWriteToWAL(in.isWriteToWal());
        for (TColumnValue columnValue : in.getColumnValues()) {
            if (columnValue.isSetTimestamp()) {
                out.add(columnValue.getFamily(), columnValue.getQualifier(), columnValue.getTimestamp(), columnValue.getValue());
                continue;
            }
            out.add(columnValue.getFamily(), columnValue.getQualifier(), columnValue.getValue());
        }
        return out;
    }

    public static List<Put> putsFromThrift(List<TPut> in) {
        ArrayList<Put> out = new ArrayList<Put>(in.size());
        for (TPut put2 : in) {
            out.add(ThriftUtilities.putFromThrift(put2));
        }
        return out;
    }

    public static Delete deleteFromThrift(TDelete in) {
        Delete out;
        if (in.isSetColumns()) {
            out = new Delete(in.getRow());
            for (TColumn column : in.getColumns()) {
                if (column.isSetQualifier()) {
                    if (column.isSetTimestamp()) {
                        if (in.isSetDeleteType() && in.getDeleteType().equals((Object)TDeleteType.DELETE_COLUMNS)) {
                            out.deleteColumns(column.getFamily(), column.getQualifier(), column.getTimestamp());
                            continue;
                        }
                        out.deleteColumn(column.getFamily(), column.getQualifier(), column.getTimestamp());
                        continue;
                    }
                    if (in.isSetDeleteType() && in.getDeleteType().equals((Object)TDeleteType.DELETE_COLUMNS)) {
                        out.deleteColumns(column.getFamily(), column.getQualifier());
                        continue;
                    }
                    out.deleteColumn(column.getFamily(), column.getQualifier());
                    continue;
                }
                if (column.isSetTimestamp()) {
                    out.deleteFamily(column.getFamily(), column.getTimestamp());
                    continue;
                }
                out.deleteFamily(column.getFamily());
            }
        } else {
            out = in.isSetTimestamp() ? new Delete(in.getRow(), in.getTimestamp(), null) : new Delete(in.getRow());
        }
        out.setWriteToWAL(in.isWriteToWal());
        return out;
    }

    public static List<Delete> deletesFromThrift(List<TDelete> in) {
        ArrayList<Delete> out = new ArrayList<Delete>(in.size());
        for (TDelete delete : in) {
            out.add(ThriftUtilities.deleteFromThrift(delete));
        }
        return out;
    }

    public static TDelete deleteFromHBase(Delete in) {
        TDelete out = new TDelete(ByteBuffer.wrap(in.getRow()));
        ArrayList<TColumn> columns = new ArrayList<TColumn>();
        long rowTimestamp = in.getTimeStamp();
        if (rowTimestamp != Long.MAX_VALUE) {
            out.setTimestamp(rowTimestamp);
        }
        for (Map.Entry<byte[], List<KeyValue>> familyEntry : in.getFamilyMap().entrySet()) {
            TColumn column = new TColumn(ByteBuffer.wrap(familyEntry.getKey()));
            for (KeyValue keyValue : familyEntry.getValue()) {
                byte[] family = keyValue.getFamily();
                byte[] qualifier = keyValue.getQualifier();
                long timestamp = keyValue.getTimestamp();
                if (family != null) {
                    column.setFamily(family);
                }
                if (qualifier != null) {
                    column.setQualifier(qualifier);
                }
                if (timestamp == Long.MAX_VALUE) continue;
                column.setTimestamp(keyValue.getTimestamp());
            }
            columns.add(column);
        }
        out.setColumns(columns);
        return out;
    }

    public static List<TDelete> deletesFromHBase(List<Delete> in) {
        ArrayList<TDelete> out = new ArrayList<TDelete>(in.size());
        for (Delete delete : in) {
            if (delete == null) {
                out.add(null);
                continue;
            }
            out.add(ThriftUtilities.deleteFromHBase(delete));
        }
        return out;
    }

    public static Scan scanFromThrift(TScan in) throws IOException {
        TTimeRange timeRange;
        Scan out = new Scan();
        if (in.isSetStartRow()) {
            out.setStartRow(in.getStartRow());
        }
        if (in.isSetStopRow()) {
            out.setStopRow(in.getStopRow());
        }
        if (in.isSetCaching()) {
            out.setCaching(in.getCaching());
        }
        if (in.isSetMaxVersions()) {
            out.setMaxVersions(in.getMaxVersions());
        }
        if (in.isSetColumns()) {
            for (TColumn column : in.getColumns()) {
                if (column.isSetQualifier()) {
                    out.addColumn(column.getFamily(), column.getQualifier());
                    continue;
                }
                out.addFamily(column.getFamily());
            }
        }
        if ((timeRange = in.getTimeRange()) != null && timeRange.isSetMinStamp() && timeRange.isSetMaxStamp()) {
            out.setTimeRange(timeRange.getMinStamp(), timeRange.getMaxStamp());
        }
        return out;
    }

    public static Increment incrementFromThrift(TIncrement in) throws IOException {
        Increment out = new Increment(in.getRow());
        for (TColumnIncrement column : in.getColumns()) {
            out.addColumn(column.getFamily(), column.getQualifier(), column.getAmount());
        }
        out.setWriteToWAL(in.isWriteToWal());
        return out;
    }
}

